diff -rc /usr2/sysref/0.97-1/linux/include/linux/config.h linux/include/linux/config.h
*** /usr2/sysref/0.97-1/linux/include/linux/config.h	Mon Aug 10 20:12:02 1992
--- linux/include/linux/config.h	Mon Aug 10 20:52:33 1992
***************
*** 1,7 ****
  #ifndef _LINUX_CONFIG_H
  #define _LINUX_CONFIG_H
  
! #define CONFIG_DISTRIBUTION
  
  /*
   * Defines for what uname() should return 
--- 1,7 ----
  #ifndef _LINUX_CONFIG_H
  #define _LINUX_CONFIG_H
  
! #undef CONFIG_DISTRIBUTION
  
  /*
   * Defines for what uname() should return 
diff -rc /usr2/sysref/0.97-1/linux/include/linux/config.site.h linux/include/linux/config.site.h
*** /usr2/sysref/0.97-1/linux/include/linux/config.site.h	Mon Aug 10 20:12:02 1992
--- linux/include/linux/config.site.h	Mon Aug 10 21:31:11 1992
***************
*** 6,9 ****
  	that you have added and config.dist will not know about.
  */
  
! #endif
--- 6,67 ----
  	that you have added and config.dist will not know about.
  */
  
! 
! /* QIC-02 Tape stuff added by hhb */
! 
! /* Tape configuration: 
!  * Support is intended for QIC02/Wangtek5150 and FDC/Colorado tape drives.
!  * FDC type tape drives are currently unsupported.
!  * QIC-02 and FD type controllers should be able to co-exist. Each type has
!  * it's own driver and it's own major number. At most one tapestreamer
!  * of each is supported. [If you have more than one of a kind, 
!  * get an extra machine. Or give one to me ;-)] 
!  *
!  * define CONFIG_TAPE_QIC02 for QIC02 type interface,
!  * define CONFIG_TAPE_FDC for tape streamers attached to a floppy controller.
!  *
!  * Possible controller/drives combinations:
!  *
!  * CONFIG_TAPE_QIC02 - TAPE_QIC02_WANGTEK5150
!  *	- Wangtek 5150, interface QIC02, format: up to QIC-150.
!  * CONFIG_TAPE_QIC02 - TAPE_QIC02_ALL_FEATURES
!  *	- Enables some optional QIC commands that some drives may lack.
!  *	  It is provided so you can check which are supported by your drive.
!  *	  Refer to tpqic02.h for others.
!  *
!  * Make sure you have the I/O ports/DMA channels 
!  * and IRQ stuff configured properly!
!  * NOTE: There may be other device drivers using the same major
!  *       number. This must be avoided.
!  */
! 
! #define CONFIG_TAPE_QIC02		/* flag */
! #ifdef CONFIG_TAPE_QIC02
! #define  TAPE_QIC02_WANGTEK5150		/* drive type */
! #define  TAPE_QIC02_MAJOR	12	/* major device number */
! #define  TAPE_QIC02_PORT	0x300	/* controller port adress */
! #define  TAPE_QIC02_IRQ		5	/* 2 might be shared */
! #define  TAPE_QIC02_DMA		1	/* either 1 or 3 */
! #endif /* CONFIG_TAPE_QIC02 */
! 
! 
! #undef CONFIG_TAPE_FDC			/* flag */
! #ifdef CONFIG_TAPE_FDC
! #define  TAPE_FDC_MAJOR		13	/* ? maybe 2? */
! #define  TAPE_FDC_DMA		2	/* uses floppy controller */
! #error "Not supported"
! #endif /* CONFIG_TAPE_FDC */
! 
! 
! 
! /*
!  * Define system bus type for lowlevel dependencies
!  */
! #ifndef _SYSTEM_BUS
! #define _SYSTEM_BUS
! #define SYSTEM_BUS_ISA
! #endif /* _SYSTEM_BUS */
! 
! 
! 
! #endif /* _CONFIG_SITE_H */
diff -rc /usr2/sysref/0.97-1/linux/include/linux/timer.h linux/include/linux/timer.h
*** /usr2/sysref/0.97-1/linux/include/linux/timer.h	Mon Aug 10 20:12:02 1992
--- linux/include/linux/timer.h	Mon Aug 10 20:28:58 1992
***************
*** 24,29 ****
--- 24,31 ----
   * SCSI_TIMER		scsi.c timeout timer
   *
   * NET_TIMER		tcp/ip timeout timer
+  *
+  * TAPE_QIC02_TIMER	timer for QIC-02 tape driver (it's not hardcoded)
   */
  
  #define BLANK_TIMER	0
***************
*** 43,48 ****
--- 45,52 ----
  #define FLOPPY_TIMER	17
  #define SCSI_TIMER 	18
  #define NET_TIMER	19
+ 
+ #define TAPE_QIC02_TIMER	21	/* hhb */
  
  struct timer_struct {
  	unsigned long expires;
diff -rc /usr2/sysref/0.97-1/linux/kernel/Makefile linux/kernel/Makefile
*** /usr2/sysref/0.97-1/linux/kernel/Makefile	Mon Aug 10 20:10:38 1992
--- linux/kernel/Makefile	Mon Aug 10 20:38:39 1992
***************
*** 20,26 ****
  
  OBJS  = sched.o sys_call.o traps.o irq.o fork.o \
  	panic.o printk.o vsprintf.o sys.o exit.o \
! 	signal.o mktime.o ptrace.o ioport.o itimer.o
  
  all: kernel.o kernelsubdirs
  
--- 20,26 ----
  
  OBJS  = sched.o sys_call.o traps.o irq.o fork.o \
  	panic.o printk.o vsprintf.o sys.o exit.o \
! 	signal.o mktime.o ptrace.o ioport.o itimer.o dma.o
  
  all: kernel.o kernelsubdirs
  
diff -rc /usr2/sysref/0.97-1/linux/kernel/chr_drv/Makefile linux/kernel/chr_drv/Makefile
*** /usr2/sysref/0.97-1/linux/kernel/chr_drv/Makefile	Mon Aug 10 20:10:38 1992
--- linux/kernel/chr_drv/Makefile	Mon Aug 10 20:38:47 1992
***************
*** 17,23 ****
  	$(CC) $(CFLAGS) -c $<
  
  OBJS  = tty_io.o console.o keyboard.o serial.o \
! 	tty_ioctl.o pty.o lp.o vt.o mem.o mouse.o
  
  chr_drv.a: $(OBJS)
  	$(AR) rcs chr_drv.a $(OBJS)
--- 17,23 ----
  	$(CC) $(CFLAGS) -c $<
  
  OBJS  = tty_io.o console.o keyboard.o serial.o \
! 	tty_ioctl.o pty.o lp.o vt.o mem.o mouse.o tpqic02.o
  
  chr_drv.a: $(OBJS)
  	$(AR) rcs chr_drv.a $(OBJS)
diff -rc /usr2/sysref/0.97-1/linux/kernel/chr_drv/mem.c linux/kernel/chr_drv/mem.c
*** /usr2/sysref/0.97-1/linux/kernel/chr_drv/mem.c	Mon Aug 10 20:10:38 1992
--- linux/kernel/chr_drv/mem.c	Mon Aug  3 21:30:52 1992
***************
*** 10,15 ****
--- 10,16 ----
  #include <linux/kernel.h>
  #include <linux/tty.h>
  #include <linux/mouse.h>
+ #include <linux/tpqic02.h>
  
  #include <asm/segment.h>
  #include <asm/io.h>
***************
*** 257,261 ****
--- 258,265 ----
  	mem_start = tty_init(mem_start);
  	mem_start = lp_init(mem_start);
  	mem_start = mouse_init(mem_start);
+ #ifdef CONFIG_TAPE_QIC02
+ 	mem_start = tape_qic02_init(mem_start);
+ #endif
  	return mem_start;
  }
diff -rc /usr2/sysref/0.97-1/linux/net/Makefile linux/net/Makefile
*** /usr2/sysref/0.97-1/linux/net/Makefile	Mon Aug 10 20:12:03 1992
--- linux/net/Makefile	Mon Aug 10 20:55:14 1992
***************
*** 37,43 ****
  	sed '/\#\#\# Dependencies/q' < Makefile > tmp_make
  	for i in *.c;do $(CPP) -M $$i;done >> tmp_make
  	cp tmp_make Makefile
! 	@for i in $(SUBDIRS); do (cd $$i; echo $$i; $(MAKE) dep || exit; done
  
  dummy:
  
--- 37,43 ----
  	sed '/\#\#\# Dependencies/q' < Makefile > tmp_make
  	for i in *.c;do $(CPP) -M $$i;done >> tmp_make
  	cp tmp_make Makefile
! 	@for i in $(SUBDIRS); do (cd $$i; echo $$i; $(MAKE) dep) || exit; done
  
  dummy:
  
