/*
 * Copyright 1989, 1990, John F. Haugh II
 * All rights reserved.
 *
 * Use, duplication, and disclosure prohibited without
 * the express written permission of the author.
 */

/*
 * faillog.h - login failure logging file format
 *
 *	@(#)faillog.h	2.2	19:23:46	7/29/90
 *
 * The login failure file is maintained by login(1) and fail(1L)
 * Each record in the file represents a separate UID and the file
 * is indexed in that fashion.
 */

#define	FAILFILE	"/usr/adm/faillog"

struct	faillog {
	short	fail_cnt;	/* failures since last success */
	short	fail_max;	/* failures before turning account off */
	char	fail_line[12];	/* last failure occured here */
	time_t	fail_time;	/* last failure occured then */
};
