/*
 * Copyright 1989, 1990, 1991, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 */

#include <sys/types.h>
#include <utmp.h>
#include "pwd.h"
#include <fcntl.h>
#include <time.h>
#ifndef	BSD
#include <string.h>
#include <memory.h>
#else
#include <strings.h>
#define	strchr	index
#define	strrchr	rindex
#endif
#include "config.h"

#ifndef	lint
static	char	sccsid[] = "@(#)log.c	3.2	07:43:10	9/17/91";
#endif

#include "lastlog.h"

extern	struct	utmp	utent;
extern	struct	passwd	pwent;
extern	struct	lastlog	lastlog;
extern	char	**environ;

long	lseek ();
time_t	time ();

void	log ()
{
	int	fd;
	off_t	offset;
	struct	lastlog	newlog;

	if ((fd = open ("/usr/adm/lastlog", O_RDWR)) == -1)
		return;

	offset = pwent.pw_uid * sizeof lastlog;

	if (lseek (fd, offset, 0) != offset) {
		(void) close (fd);
		return;
	}
	if (read (fd, (char *) &lastlog, sizeof lastlog) != sizeof lastlog)
#ifndef	BSD
		memset ((char *) &lastlog, sizeof lastlog, 0);
#else
		bzero ((char *) &lastlog, sizeof lastlog);
#endif
	newlog = lastlog;

	(void) time (&newlog.ll_time);
	(void) strncpy (newlog.ll_line, utent.ut_line, sizeof newlog.ll_line);
	(void) lseek (fd, offset, 0);
	(void) write (fd, (char *) &newlog, sizeof newlog);
	(void) close (fd);
}

