#!/bin/sh

# $Header: /home/x_cvs/mit/server/ddx/x386/LinkKit/x386config.sh,v 1.2 1992/09/01 12:40:51 dawes Exp $
#
# Generate X386Conf.tmpl Imake template
#
# Link Kit version
#
# Usage: x386config.sh MODULETYPE1 module ... MODULETYPE2 module ...
#

Iconfig=X386Conf.tmpl

ModuleHeader=
ModuleList=
ExtraRenderers=NO

# WriteModule  ModuleHeader is set, and $* is the list of modules names

WriteModule()
{
    if [ X"$ModuleHeader" != X ]; then
        if [ $# -eq 0 ]; then
            echo "$ModuleHeader" >> $Iconfig
        else
            echo "$ModuleHeader \\" >> $Iconfig
            while [ $# -gt 1 ]; do
                echo "                   $1 \\" >> $Iconfig
                shift
            done
            echo "                   $1" >> $Iconfig
        fi
    fi
}


cat > $Iconfig <<EOF
XCOMM  --------------------------------------------------------------------
XCOMM  X386Conf.tmpl  -- configuration parameters for X386
XCOMM  This file is automatically generated -- DO NOT EDIT
XCOMM  --------------------------------------------------------------------

         X386SRC = drivers
    VGADRIVERSRC = \$(X386SRC)/vga256
   VGA2DRIVERSRC = \$(X386SRC)/vga2
     RENDERERSRC = renderers
#if X386MonoServer
     VGA2CONFOBJ = \$(X386SRC)/vga2/vga2Conf.o
  VGA2CONFSUBDIR = \$(X386SRC)/vga2
   X386MCONFOBJS = \$(VGA2CONFOBJ)
X386MCONFSUBDIRS = \$(VGA2CONFSUBDIR)
#endif
#if X386Server
      VGACONFOBJ = \$(X386SRC)/vga256/vga256Conf.o
   VGACONFSUBDIR = \$(X386SRC)/vga256
    X386CONFOBJS = \$(VGACONFOBJ)
 X386CONFSUBDIRS = \$(VGACONFSUBDIR)
#endif
 RENDERERCONFOBJ = \$(RENDERERSRC)/rendererConf.o
RENDERERCONFSUBDIR = \$(RENDERERSRC)
EOF

while [ $# -gt 0 ]; do
    case $1 in
        VGADRIVER)
            ModuleHeader="$ObjsHeader"
            WriteModule $ModuleObjs
            ModuleHeader="$SubdirsHeader"
            WriteModule $ModuleSubdirs
            ModuleType=$1
            shift
            ObjsHeader='         VGAOBJS ='
            SubdirsHeader='      VGASUBDIRS ='
            ModuleObjs=
            ModuleSubdirs=
            ;;
        VGA2DRIVER)
            ModuleHeader="$ObjsHeader"
            WriteModule $ModuleObjs
            ModuleHeader="$SubdirsHeader"
            WriteModule $ModuleSubdirs
            ModuleType=$1
            shift
            ObjsHeader='        VGA2OBJS ='
            SubdirsHeader='     VGA2SUBDIRS ='
            ModuleObjs=
            ModuleSubdirs=
            ;;
        RENDERER)
            ModuleHeader="$ObjsHeader"
            WriteModule $ModuleObjs
            ModuleHeader="$SubdirsHeader"
            WriteModule $ModuleSubdirs
            ModuleType=$1
            shift
            ObjsHeader='    RENDERERLIBS ='
            SubdirsHeader=' RENDERERSUBDIRS ='
            ModuleObjs=
            ModuleSubdirs=
            ;;
        *)
            case $ModuleType in
                VGADRIVER)
                    ModuleObjs="$ModuleObjs "'$(VGADRIVERSRC)'/$1.o
                    ModuleSubdirs="$ModuleSubdirs $1"
                    ;;
                VGA2DRIVER)
                    ModuleObjs="$ModuleObjs "'$(VGA2DRIVERSRC)'/$1.o
                    ModuleSubdirs="$ModuleSubdirs $1"
                    ;;
                RENDERER)
                    ExtraRenderers=YES
                    ModuleObjs="$ModuleObjs "'$(RENDERERSRC)'/lib$1.a
                    ModuleSubdirs="$ModuleSubdirs "$1
                    ;;
            esac
            shift
            ;;
    esac
done
ModuleHeader="$ObjsHeader"
WriteModule $ModuleObjs
ModuleHeader="$SubdirsHeader"
WriteModule $ModuleSubdirs

echo "#define ExtraRenderers $ExtraRenderers" >> $Iconfig
