/*
 *
 * at - queues jobs to be run by /usr/lib/atrun
 *
 * Written 11/10/89 by Ed Carp (erc@apple.com)
 * Adapted for linux 08/11/92.
 *
 * Version	Date	Comments
 *
 *   1.1      08/11/92  Cleaned up security hole.
 *
 * Copyright 1992 by Ed Carp
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include "at.h"
#undef NULL
#define NULL (0)

long
sizefile (s)
     char *s;
{
   struct stat buf;

   if (EOF == stat (s, &buf))
      return ((long) EOF);
   return (buf.st_size);
}

main (argc, argv, envp)
     int argc;
     char **argv, **envp;
{
   char atfile[128], *getcwd (), **atenv, cmd[256], *user, *getlogin ();
   FILE *fp;
   register int i;
   int curtime, curdate, catflag;
   int hr, mi, mo, dy, yr;
   long secs, secs2, timelocal ();
   struct tm *attm;

   if (argc < 2 || argc > 3)
      usage (argv);
   if (strlen (argv[1]) != 4 || (argc == 3 && (strlen (argv[2]) < 4 || strlen (argv[2]) > 6)))
      usage (argv);
   time (&secs);
   attm = localtime (&secs);
   switch (argc)
     {
     case 2:
     case 3:
	attm->tm_hour = ((argv[1][0] - '0') * 10) + (argv[1][1] - '0');
	attm->tm_min = ((argv[1][2] - '0') * 10) + (argv[1][3] - '0');
	if (argc == 2)
	   break;
	attm->tm_mon = (argv[2][0] - '0') * 10 + (argv[2][1] - '0');
	attm->tm_mon--;
	attm->tm_mday = (argv[2][2] - '0') * 10 + (argv[2][3] - '0');
	if (strlen (argv[2]) == 6)
	   attm->tm_year = (argv[2][4] - '0') * 10 + (argv[2][5] - '0');
	break;
     }
   secs2 = timelocal (attm);
   if (secs >= secs2)
     {
	puts ("It's past that time!");
	printf ("It's %s", ctime(&secs));
        printf("You're trying to schedule a job for %s", ctime(&secs2));
	exit (1);
     }
   catflag = 0;
   if ((user = getlogin ()) == (char *) NULL)
      user = "root";
   do
     {
	sprintf (atfile, "%s/%02d%02d%02d%02d%02d.%d",
	ATJOBS, attm->tm_hour, attm->tm_min, attm->tm_mon + 1, attm->tm_mday,
		 attm->tm_year, catflag);
	catflag++;
	if (catflag > ATLIM)
	  {
	     puts ("Too many atjobs queued for this time!");
	     exit (1);
	  }
     }
   while (sizefile (atfile) != (long) EOF);
   if ((fp = fopen (atfile, "w")) == (FILE *) NULL)
     {
	perror (atfile);
	return;
     }
   fprintf (fp, "#\n# at job generated by /bin/at\n# Copyright 1992 by Ed Carp (erc@apple.com)\n#\n\n");
   /* get environment and write it out */
   atenv = envp;
   while (1)
     {
	if (*atenv == NULL)
	   break;
	if (strncmp ("TERMCAP=", *atenv, 8) != 0 && strncmp ("_=", *atenv, 2) != 0)
	   fprintf (fp, "%s\n", *atenv);
	atenv++;
     }
   /* get current working directory and put a cd command with it */
   fprintf (fp, "\n(cd %s", getcwd ((char *) NULL, 64));
   while (gets (cmd))
      fprintf (fp, "\n%s", cmd);
   fprintf (fp, ") | /bin/mail -s 'output of your at job' %s\n", user);
   fclose (fp);
   chown (atfile, getuid ());
   chmod (atfile, 0700);
}

usage (av)
     char **av;
{
   printf ("usage: %s HHMM [MMDD[YY]]\n", av[0]);
   exit (1);
}

int md[] =
{
   31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};

long
timelocal (t)
     struct tm *t;
{
   /* take t and convert it to seconds */
   long r;
   r = (long) t->tm_sec;
   r += (long) t->tm_min * 60L;
   r += (long) t->tm_hour * 3600L;
   r += (long) t->tm_mday * 24L * 3600L;
   r += (long) t->tm_mon * (long) md[t->tm_mon] * 24L * 3600L;
   r += (long) (t->tm_year - 70) * 365L * 24L * 3600L;
   /* how many leap years since 1970? */
   /* r += (long)((t->tm_year - 70) / 4) * 24L * 3600L; */
   return (r);
}
