


CPROTO(1)                                               CPROTO(1)


NNAAMMEE
       cproto  - generate C function prototypes and convert func-
       tion definitions

SSYYNNOOPPSSIISS
       ccpprroottoo [ _o_p_t_i_o_n ...  ] [ _f_i_l_e ...  ]

DDEESSCCRRIIPPTTIIOONN
       CCpprroottoo generates function prototypes for functions defined
       in  the  specified  C source files to the standard output.
       The function definitions may be in the old style or ANSI C
       style.   Optionally,  ccpprroottoo also outputs declarations for
       any variables defined in the file.  If no _f_i_l_e argument is
       given, ccpprroottoo reads its input from the standard input.

       By  giving a command line option, ccpprroottoo will also convert
       function definitions in the specified files from  the  old
       style  to  the  ANSI  C  style.  The original source files
       along with files specified by

            #include "file"

       directives appearing in the source code will be  overwrit-
       ten  with  the converted code.  If no file names are given
       on the command line, then the  program  reads  the  source
       code  from  the  standard  input and outputs the converted
       source to the standard output.

       If any comments appear in the parameter declarations for a
       function definition, such as in the example,

            main (argc, argv)
            int argc; /* number of arguments */
            char *argv[];  /* arguments */
            {
             ...
            }

       then the converted function definition will have the form

            int
            main (
                int argc;      /* number of arguments */
                char *argv[];   /* arguments */
            )
            {
             ...
            }

       Otherwise,  the  converted  function  definition will look







                          April 3, 1992                         1





CPROTO(1)                                               CPROTO(1)


       like

            int
            main (int argc, char *argv[])
            {
             ...
            }


       CCpprroottoo can optionally convert  function  definitions  from
       the  ANSI  style to the old style.  In this mode, the pro-
       gram also converts  function  declarators  and  prototypes
       that  appear  outside function bodies.  This is not a com-
       plete ANSI C to old C conversion.  The  program  does  not
       change anything within function bodies.

OOPPTTIIOONNSS
       --aa     Convert  function definitions from the old style to
              the ANSI C style.

       --ee     Output the keyword eexxtteerrnn in front of every  decla-
              ration having global scope.

       --ff_n    Set  the  style  of  generated  function prototypes
              where _n is a number from 0 to 4.  For example, con-
              sider the function definition

                   main (argc, argv)
                   int argc;
                   char *argv[];
                   {
                    ...
                   }

              If  the  value  is 0, then no prototypes are gener-
              ated.  When set to 1, the output is:

                   int main(/*int argc, char *argv[]*/);

              For a value of 2, the output has the form:

                   int main(int /*argc*/, char */*argv*/[]);

              The default value is 3.  It produces the full func-
              tion prototype:

                   int main(int argc, char *argv[]);

              A  value  of  4  produces  prototypes  guarded by a
              macro:

                   int main P_((int argc, char *argv[]));





                          April 3, 1992                         2





CPROTO(1)                                               CPROTO(1)


       --cc     Omit the parameter comments in the prototypes  gen-
              erated  by  the  -f1  and -f2 options.  This option
              also omits the comments  naming  the  source  files
              from which the prototypes were generated.

       --mm_n_a_m_e Set  the name of the macro used to guard prototypes
              when option -f4 is selected.  The default is  "P_".

       --dd     Omit the definition of the prototype macro named by
              the -m option.

       --pp     Disable promotion of formal parameters in old style
              function  definitions.   By  default, parameters of
              type cchhaarr or sshhoorrtt in old  style  function  defini-
              tions are promoted to type iinntt in the function pro-
              totype or converted  ANSI  C  function  definition.
              Parameters  of type ffllooaatt get promoted to ddoouubbllee as
              well.

       --ss     By default, ccpprroottoo only generates declarations  for
              functions  and variables having global scope.  This
              option will output ssttaattiicc declarations as well.

       --tt     Convert function definitions from the ANSI C  style
              to the traditional style.

       --vv     Also  output  declarations for variables defined in
              the source.

       --PP_t_e_m_p_l_a_t_e
       --FF_t_e_m_p_l_a_t_e
       --CC_t_e_m_p_l_a_t_e
            Set the output format for generated prototypes, func-
            tion   definitions,  and  function  definitions  with
            parameter comments respectively.  The format is spec-
            ified by a template in the form

                 " int main ( a, b )"

            but  you  may  replace each space in this string with
            any number of whitespace  characters.   For  example,
            the option

                 -F"int main(\n\ta,\n\tb\n\t)"

            will produce

                 int main(
                      int argc,
                      char *argv[]
                      )


       --DD_n_a_m_e This  option  is passed through to the preprocessor



                          April 3, 1992                         3





CPROTO(1)                                               CPROTO(1)


              and is used to define symbols for use  with  condi-
              tionals such as _#_i_f_d_e_f_.

       --UU_n_a_m_e This  option  is passed through to the preprocessor
              and is used to remove any definitions of this  sym-
              bol.

       --II_d_i_r_e_c_t_o_r_y
              This  option  is passed through to the preprocessor
              and is used to specify a directory  to  search  for
              files that are referenced with _#_i_n_c_l_u_d_e_.

       --VV     Print version information.

EENNVVIIRROONNMMEENNTT
       The  environment  variable CPROTO is scanned for a list of
       options in the same format as the command line options.

BBUUGGSS
       If an untagged struct, union or enum  declaration  appears
       in  a  generated  function prototype or converted function
       definition, the content of  the  declaration  between  the
       braces is empty.

       The  program  does not pipe the source files through the C
       preprocessor when it is converting  function  definitions.
       Instead,  it  tries  to handle preprocessor directives and
       macros itself and can be confused by tricky  macro  expan-
       sions.   The conversion also discards some comments in the
       function definition head.

       The -v option does not generate declarations for variables
       defined  with the eexxtteerrnn specifier.  This doesn't strictly
       conform to the C  language  standard  but  this  rule  was
       implemented  because  include files commonly declare vari-
       ables this way.

       When the program encounters an error, it  usually  outputs
       the not very descriptive message "syntax error".

       Options that take string arguments only interpret the fol-
       lowing character escape sequences:

            \n   newline
            \t   tab


AAUUTTHHOORR
       Chin Huang
       cthuang@zerosan.UUCP
       chin.huang@canrem.com

SSEEEE AALLSSOO
       cc(1), cpp(1)



                          April 3, 1992                         4


