#ifndef KEYS_H
#  define KEYS_H
  /*{{{  tokens*/
  typedef enum {
    /*{{{  tokens*/
    O_NOP=256,
    /*{{{  for macros*/
    M_ADD_COUNTER,
    M_BEGIN_FOLD_COMMENT,
    M_BEGIN_OF_LINE,
    M_BEHIND_COUNTER_X_POS,
    M_BOT_OF_FOLD,
    M_CALL,
    M_CHANGED,
    M_CLOSED_FOLD,
    M_END_FOLD_COMMENT,
    M_END_MACRO,
    M_END_OF_LINE,
    M_EXIT,
    M_FILED_FOLD,
    M_GO_COUNTER_X_POS,
    M_GO_LINE,
    M_GO_X_POS,
    M_INT_STRING,
    M_INV_COUNTER,
    M_JMP,
    M_JMP_FALSE,
    M_JMP_TRUE,
    M_LANGUAGE,
    M_NOT,
    M_NULL_COUNTER,
    M_POSITIV_COUNTER,
    M_POS_TO_COUNTER,
    M_PROMPT,
    M_READ_REPEAT,
    M_SET_COUNTER,
    M_STORE_LINE_NO,
    M_SUM_COUNTER,
    M_TEST_CHAR,
    M_TEXTLINE,
    M_TOP_OF_FOLD,
    /*}}}  */
    O_ATTACH_FILE,
    O_AUTO_FOLD,
    O_AUTO_SAVE,
    O_A_AUTO_SAVE,
    O_A_ECHO,
    O_A_OVER,
    O_A_VIEW,
    O_BOT_OF_FOLD,
    O_BREAK,
    O_CAPITALIZE_WORD,
    O_CLOSE_FOLD,
    O_COPY,
    O_COPY_PICK,
    O_CREATE_FOLD,
    O_DEF_FIX,
    O_DEF_MACRO,
    O_DELETE,
    O_DELTO_EOL,
    O_DEL_CHAR_R,
    O_DEL_LINE,
    O_DESCRIBE_BINDINGS,
    O_DOWN,
    O_D_AUTO_SAVE,
    O_D_ECHO,
    O_D_OVER,
    O_D_VIEW,
    O_END_OF_LINE,
    O_ENTER_FOLD,
    O_EXIT_FOLD,
    O_FILE_FOLD,
    O_FILTER_BUFFER,
    O_FIND,
    O_FIND_REVERSE,
    O_FINISH,
    O_FIRST_LINE_TO_FOLD_HEADER,
    O_FOLD_INFO,
    O_GOTO_LINE,
    O_HELP,
    O_INSERT_FILE,
    O_ITS_REVERSE,
    O_ITS_SEARCH,
    O_LANGUAGE,
    O_LEFT,
    O_LOWERCASE_WORD,
    O_MOVE,
    O_NEXT_FILE,
    O_OPEN_FOLD,
    O_OPEN_NEW_FILE,
    O_PAGE_DOWN,
    O_PAGE_UP,
    O_PICK,
    O_PIPE_FROM_COMMAND,
    O_PIPE_TO_COMMAND,
    O_PREV_FILE,
    O_PROMPT,
    O_PUT_PICK,
    O_QUERY_REPLACE,
    O_QUIT,
    O_REFRESH,
    O_REMOVE_FOLD,
    O_REPLACE,
    /*{{{  argument-repeat*/
    O_REP_0,
    O_REP_1,
    O_REP_2,
    O_REP_3,
    O_REP_4,
    O_REP_5,
    O_REP_6,
    O_REP_7,
    O_REP_8,
    O_REP_9,
    /*}}}  */
    O_RESET_USER_MODE,
    O_RETURN,
    O_RIGHT,
    O_SAVE_FILE,
    O_SET_USER_MODE,
    O_SHELL,
    O_SHELL_COMMAND,
    O_START_OF_LINE,
    O_SUSPEND,
    O_TOP_OF_FOLD,
    O_TRANSPOSE_CHARACTERS,
    O_UNDEL_CHAR,
    O_UNDEL_LINE,
    O_UP,
    O_UPPERCASE_WORD,
    O_WORD_LEFT,
    O_WORD_RIGHT,
    O_WRITE_FILE,
    /*{{{  macro calls*/
    O_EXE_MACRO,
    O_CALL_FIX_1,
    O_CALL_FIX_2,
    O_CALL_FIX_3,
    O_CALL_FIX_4,
    O_CALL_FIX_5,
    O_CALL_FIX_6,
    O_CALL_FIX_7,
    O_CALL_FIX_8,
    O_CALL_FIX_9,
    O_CALL_FIX_10,
    O_CALL_FIX_11,
    O_CALL_FIX_12,
    O_CALL_FIX_13,
    O_CALL_FIX_14,
    O_CALL_FIX_15,
    O_CALL_FIX_16,
    O_CALL_FIX_17,
    O_CALL_FIX_18,
    O_CALL_FIX_19,
    O_CALL_FIX_20,
    O_CALL_FIX_21,
    O_CALL_FIX_22,
    O_CALL_FIX_23,
    O_CALL_FIX_24,
    O_CALL_FIX_25,
    O_CALL_FIX_26,
    O_CALL_FIX_27,
    O_CALL_FIX_28,
    O_CALL_FIX_29,
    O_CALL_FIX_30,
    O_CALL_FIX_31,
    O_CALL_FIX_32,
    O_CALL_STRING,
    /*}}}  */
    /*}}}  */
  } TOKEN;
#  define MAX_MACRO (int) (O_CALL_FIX_32-O_EXE_MACRO)
  /*}}}  */
#  define mark_name_lg 9
  /*{{{  standard-marks*/
#    define tag_length 4
#    define begin_standard "{{{"
#    define file_standard  ":::"
#    define line_standard  "..."
#    define end_standard   "}}}"
  /*}}}  */
  /*{{{  keyname*/
#  define keyn_lg 16
  /*}}}  */
  /*{{{  KEY*/
  typedef struct KEY {
    TOKEN code;
    unsigned char key;
    struct KEY *next;
    struct KEY *n_level;
  } KEY;
  /*}}}  */
#endif /* KEYS_H */
