#ifdef sun

#ifdef i386
#define HOST_LOW_ENDIAN
#endif

#ifdef sparc
#define HOST_BIG_ENDIAN
#endif

#endif /* sun */

void
ieee_single(d,p)
    double d;
    unsigned long *p;
{
    union {
        float f;
        unsigned long ul;
    } u;

    /* This should work for any host with IEEE numbers */
    u.f = (float) d;
    p[0] = u.ul;
}

void
ieee_double(d,p)
    double d;
    unsigned long *p;
{
    union {
        double d;
        unsigned long ul[2];
    } u;

    u.d = d;
    /* One of these alternatives should work for any host with IEEE numbers */
#ifdef HOST_LOW_ENDIAN
    p[0] = u.ul[1];
    p[1] = u.ul[0];
    return;
#endif
#ifdef HOST_BIG_ENDIAN
    p[0] = u.ul[0];
    p[1] = u.ul[1];
    return;
#endif
    fatal ("IEEE_DOUBLE");
}
