!
! quotient and remainder of unsigned long quantities
!
!
.sect	.text
.sect	.rom
.sect	.data
.sect	.bss
!
! Export: _ulrem, _uldiv
!
.sect	.text
.define _ulrem
_ulrem:
	move.l	d6,a0
	move.l	d7,a1
	move.l	#1,d2		! Rest gewuenscht: Flag <> 0
	bra     do_divu
!
.define _uldiv
_uldiv:
	move.l	d6,a0
	move.l	d7,a1
	clr.w	d2		! Quotient gewuenscht: Flag =0
!
do_divu:
	clr.l	d0		! Quotient
	move.l	4(a7),d7	! Divident
	move.l	8(a7),d6	! Divisor
	bne	L2		! Divisor <> 0
	divs	#0,d0		! EXCEPTION
	bra	leave
L2:
!
	cmp.l	d7,d6
	bcs	L4		! Divident > Divisor
	beq	L5		! Divident = Divisor
!
!  Divident < Divisor: Quotient=0, Rest=Divisor
!
	bra	finish
L5:
	move.l	#1,d0		! Quotient=1
	clr.l	d7		! Rest=0
	bra	finish
!
L4:
	cmp.l   #0x10000,d7
	bcc	L6		! Divident>65536
!
! divu muss gelingen
!
	divu	d6,d7
	move.w	d7,d0
	clr.w	d7
	swap	d7
	bra	finish
!
! Jetzt muss es doch brutal gemacht werden
!
L6:
	move.l	#1,d1
L7:
	cmp.l	d6,d7
	bcs	L8
        tst.l   d6
        bmi     L8
!
	asl.l	#1,d6
	asl.l	#1,d1
	bra	L7
!
L8:
	tst.l	d1
	beq	finish
	cmp.l	d6,d7
	bcs	L9
	or.l	d1,d0
	sub.l	d6,d7
L9:
	lsr.l	#1,d1
	lsr.l	#1,d6
	bra	L8
!
finish:
!
! Quotient in d0, Rest in d7
!
	tst.w	d2
	bne	L10
!
! Quotient erwuenscht
!
leave:
	move.l	a0,d6
	move.l	a1,d7
	rts
!
L10:
!
! Rest erwuenscht
!
	move.l	d7,d0
	bra	leave

