| Copyright (c) 1988 by Sozobon, Limited.  Author: Johann Ruegg
|
| Permission is granted to anyone to use this software for any purpose
| on any computer system, and to redistribute it freely, with the
| following restrictions:
| 1) No charge may be made other than reasonable charges for reproduction.
| 2) Modified versions must be clearly marked as such.
| 3) The authors are not responsible for any harmful consequences
|    of using this software, even if they result from defects in it.
|
| Modified for the GAS assembler by Christoph van Wuellen, but I
| did not add functionality.
| These routines handle the Motorola FastFloatingPoint format.
|
| These  routines clobber the registers d0-d2/a0-a1. Check if this is
| compatible with your compiler!
| In the MINIX distribution, C68 fulfills this requirement. The CP/M-68K
| version of C68 even considers d0-d2/a0-a2 as scratch registers, so this
| works also.
| You will have difficulties with compiles that use less scratch registers,
| i.e. that expect one of d0-d2/a0-a1 to be unchanged across function
| calls.
|
|
| Export: .fpmult
|
	.text
|
	.globl	.fpmult
.fpmult:
	movel	d3,a0		| save d3
	movel	sp@(4),d0
	movel	sp@(8),d1
	moveb	d0,d2
	beq	ret0
	moveb	d1,d3
	beq	ret0

	andb	#0x7f,d0
	andb	#0x7f,d1
	eorb	d2,d3
	bpl	mpos
| result negative
	moveml	d4-d5,sp@-
	bsr	_u_mul
	moveml	sp@+,d4-d5
	tstb	d0
	beq	ret0
	movel	a0,d3		| restore d3
	orb	#0x80,d0
	rts
| result positive
mpos:
	moveml	d4-d5,sp@-
	bsr	_u_mul
	moveml	sp@+,d4-d5
	movel	a0,d3		| restore d3
	rts
ret0:
	movel	a0,d3		| restore d3
	clrl	d0
	rts

_u_mul:
	movel	d3,a1		| save d3
	moveb	d0,d2
	addb	d1,d2
	cmpb	#0x40,d2
	bls	underfl
	cmpb	#0xbf,d2
	bhi	overfl
	subb	#0x40,d2		| result exp

	clrb	d0
	clrb	d1
	movew	d0,d3
	mulu	d1,d3
|	clrw	d3	already 0 since low bytes 0
	swap	d3

	movew	d0,d4
	movew	d1,d5
	swap	d0
	swap	d1
	mulu	d0,d5
	mulu	d1,d4
	addl	d3,d4	| no carry since d3 <= fe01 && d4 <= fffe0001
	addl	d4,d5
	bcc	nocar
	movew	#1,d5
	bra	t1
nocar:
	clrw	d5
t1:
	swap	d5

	mulu	d1,d0
	addl	d5,d0
	bcc	nocar2
	roxrl	#1,d0
	addb	#1,d2
	bmi	overfl
	bra	norm
nocar2:
	bmi	norm
	addl	d0,d0	| only need at most 1 shift since started norm AB
	subb	#1,d2
	beq	underfl
norm:
	tstb	d0
	bpl	noround
	addl	#0x80,d0
	bcc	nocar3
	roxrl	#1,d0
	addb	#1,d2
	bmi	overfl
nocar3:
noround:
	movel	a1,d3		| restore d3
	moveb	d2,d0
	rts

underfl:
	movel	a1,d3		| restore d3
	clrl	d0
	rts
overfl:
	movel	a1,d3		| restore d3
	movel	#0xffffff7f,d0
	rts
