/*
 * C compiler
 * ==========
 *
 * Copyright 1989, 1990, 1991 Christoph van Wuellen.
 * Credits to Matthew Brandt.
 * All commercial rights reserved.
 *
 * This compiler may be redistributed as long there is no
 * commercial interest. The compiler must not be redistributed
 * without its full sources. This notice must stay intact.
 *
 * History:
 *
 * 1989   starting an 68000 C compiler, starting with material
 *        originally by M. Brandt
 * 1990   68000 C compiler further bug fixes
 *        started i386 port (December)
 * 1991   i386 port finished (January)
 *        further corrections in the front end and in the 68000
 *        code generator.
 *        The next port will be a SPARC port
 */

#include	"c.h"
#ifdef INTEL_386
#ifdef TARGET_BAS

#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"


/* variable initialization */

enum e_gt {
    nogen, bytegen, wordgen, longgen, floatgen
};
enum e_sg {
    noseg, codeseg, dataseg
};

static char *outlate();

enum e_gt       gentype;
enum e_sg       curseg;
int             outcol;

static char *regname[NUMREG+1];

#define	BI	1
#define SP	2

struct oplst {
    char           *s;
    enum e_op       ov;
    int		    sa;	/* special addressing modes:
    			 *	BI	immediate is bracketed,
    			 *	SP	size prefix needed.
    			 */
}               opl[] =

{
"mov",		op_mov,		BI | SP,
"movsx",	op_movsbl,	BI | SP,
"movzx",	op_movzbl,	BI | SP,
"movsx",	op_movswl,	BI | SP,
"movzx",	op_movzwl,	BI | SP,
"movzx",	op_movzbw,	BI | SP,
"movsx",	op_movsbw,	BI | SP,
"cdq",		op_cltd,	BI | SP,
"push",		op_push,	BI | SP,
"pop",		op_pop,		BI | SP,
"add",		op_add,		BI | SP,
"sub",		op_sub,		BI | SP,
"inc",		op_inc,		BI | SP,
"dec",		op_dec,		BI | SP,
"imul",		op_imul,	BI | SP,
"idiv",		op_idiv,	BI | SP,
"and",		op_and,		BI | SP,
"neg",		op_neg,		BI | SP,
"not",		op_not,		BI | SP,
"or",		op_or,		BI | SP,
"xor",		op_xor,		BI | SP,
"shl",		op_shl,		BI | SP,
"shr",		op_shr,		BI | SP,
"sar",		op_asr,		BI | SP,
"cmp",		op_cmp,		BI | SP,
"lea",		op_lea,		BI | SP,
"jmp",		op_bra,		SP,
"jmp",		op_jmp,		SP,
"call",		op_call,	SP,
"je",		op_je,		SP,
"jne",		op_jne,		SP,
"jle",		op_jle,		SP,
"jge",		op_jge,		SP,
"jl",		op_jl,		SP,
"jg",		op_jg,		SP,
"jbe",		op_jbe,		SP,
"jae",		op_jae,		SP,
"jb",		op_jb,		SP,
"ja",		op_ja,		SP,
"leave",	op_leave,	SP,
"ret",		op_ret,		SP,
"rep",		op_rep,		SP,
"movs",		op_smov,	BI | SP,
"test",		op_test,	BI | SP,
"fadd",		op_fadd,	BI | SP,
"fsub",		op_fsub,	BI | SP,
"fsubr",	op_fsubr,	BI | SP,
"fmul",		op_fmul,	BI | SP,
"fdiv",		op_fdiv,	BI | SP,
"fdivr",	op_fdivr,	BI | SP,
"fchs",		op_fchs,	BI | SP,
"fld",		op_fld,		BI | SP,
"fild",		op_fild,	BI | SP,
"fst",		op_fst,		BI | SP,
"fstp",		op_fstp,	BI | SP,
"fstp %st(0)",	op_fpop,	BI | SP,
"fcompp",	op_fcompp,	BI | SP,
"ftst",		op_ftst,	BI | SP,
"fnstsw",	op_fnstsw,	BI | SP,
"sahf",		op_sahf,	BI | SP,
0,		0,		0
};

out_init()
{
    int i;

    fprintf(output, "| Generated by c386 Version III.1 (bas)\n");
    fputs("c386_compiled.:\n", output);
    curseg = noseg;
    gentype = nogen;
    outcol = 0;
    for (i=0; i<=NUMREG; i++)
        regname[i]="%INVALID_REGISTER";
    regname[EAX]="eax";
    regname[EBX]="ebx";
    regname[ECX]="ecx";
    regname[EDX]="edx";
    regname[EDI]="edi";
    regname[ESI]="esi";
    regname[EBP]="ebp";
    regname[ESP]="esp";
    regname[AX] ="ax";
    regname[BX] ="bx";
    regname[CX] ="cx";
    regname[DX] ="dx";
    regname[DI] ="di";
    regname[SI] ="si";
    regname[AL] ="al";
    regname[BL] ="bl";
    regname[CL] ="cl";
    regname[DL] ="dl";
}

	int
putop(op)
    enum e_op       op;
{
    int             i;
    i = 0;
    while (opl[i].s) {
	if (opl[i].ov == op) {
#if 0
This looks nicer, but costs an extra byte per line.
Who looks at compiler-generated assembly code?
	    putc ('\t', output);	/* looks nicer	*/
#endif
	    fputs(opl[i].s, output);
	    return opl[i].sa;
	}
	++i;
    }
    fatal("illegal opcode");
}

putconst(offset)
/*
 * put a constant to the output file.
 */
    struct enode   *offset;
{

    if (offset == 0)
        fatal("PUTCONST");
    switch (offset->nodetype) {
      case en_autocon:
      case en_icon:
	fprintf(output, "%ld", offset->v.i);
	break;
      case en_labcon:
	fprintf(output, ".%ld", offset->v.i);
	break;
      case en_nacon:
	fputs(outlate(offset->v.sp), output);
	break;
      case en_add:
	putconst(offset->v.p[0]);
	putc('+', output);
	putconst(offset->v.p[1]);
	break;
      case en_sub:
	putconst(offset->v.p[0]);
	putc('-', output);
	putconst(offset->v.p[1]);
	break;
      case en_uminus:
	putc('-', output);
	putconst(offset->v.p[0]);
	break;
      case en_cast:
        putconst(offset->v.p[0]);
        break;
      default:
	fatal("illegal constant node");
	break;
    }
}

#if 0
...not needed here...
putlen(l)
/*
 * append the length field to an instruction.
 */
    int             l;
{
    if (l == 0)
	return;
    switch (l) {
      case 1:
	putc('b', output);
	break;
      case 2:
	putc('w', output);
	break;
      case 4:
	putc('l', output);
	break;
      case 5:
        /* special value for single precision float */
        putc('s', output);
        break;
      case 9:
        /* special value for double precision float */
        putc('l', output);
        break;
      default:
	fatal("illegal length field");
	break;
    }
}
#endif

putamode(ap,len, sa)
/*
 * output a general addressing mode.
 */
    struct amode   *ap;
{
    int reg;
    
    if (sa & SP) {
	switch (len) {	/* kludge for movsx and movzx	*/
	case 1:
	    fputs (" byte ", output);
	    break;
	case 2:
	    fputs (" word ", output);
	    break;
	}
    }	
    switch (ap->mode) {
      case am_immed:
	putc('#', output);
	putconst(ap->offset);
	break;
      case am_direct:
	if (sa & BI) {
		putc ('[', output);
		putconst(ap->offset);
		putc (']', output);
	} else {
        	putconst (ap->offset);
        }
	break;
      case am_star:
      case am_reg:
        reg=ap->preg;
        if (len == 1) reg=REG8(reg);
        if (len == 2) reg=REG16(reg);
        fputs (regname[reg], output);
	break;
      case am_indx:
	if (ap->offset != 0)
            putconst(ap->offset);
        fprintf(output,"[%s]",regname[ap->preg]);
	break;
      case am_indx2:
	if (ap->offset != 0)
            putconst(ap->offset);
        fprintf(output,"[%s+%s]",regname[ap->preg],regname[ap->sreg]);
        break;
      default:
	fatal("illegal address mode");
	break;
    }
}

put_code(op, len, aps, apd)
/*
 * output a generic instruction.
 */
    struct amode   *aps, *apd;
    int             len;
    enum e_op       op;
{
    int len1=len, len2=len;
    int sa;
    
    sa = putop(op);
/*
 * this is expensive, but some assemblers require it
 * this is to be moved to the peephole optimizer
 */
    switch(op) {
      case op_movsbw:
      case op_movzbw:
        len2=2;
      case op_movsbl:
      case op_movzbl:
        len1=1;
        break;
      case op_movswl:
      case op_movzwl:
        len1=2;
        break;
      case op_smov:
        switch (len) {
        case 1:
            putc ('b', output);
            break;
        case 2:
            putc ('w', output);
            break;
        case 4:
            putc ('d', output);
            break;
        default:
            fprintf ("illegal length %d\n", len);
        }  
    }

/*
 * Bas uses the INTEL syntax:
 * The destination comes first
 * The source comes second
 */
    if (aps != 0) {
	putc(' ', output);
	if (apd != 0) {
	    putamode(apd,len2,sa);
	    putc(',', output);
	}
        putamode(aps,len1,sa);
    }
    putc('\n', output);
}


g_strlab(s)
/*
 * generate a named label.
 */
    char           *s;
{
    fputs(outlate(s), output);
    putc(':', output);
    putc('\n', output);
}

put_label(lab)
/*
 * output a compiler generated label.
 */
    unsigned int    lab;
{
    fprintf(output, ".%u:\n", lab);
}

genbyte(val)
    int             val;
{
    if (gentype == bytegen && outcol < 60) {
	fprintf(output, ",%d", val & 0x00ff);
	outcol += 4;
    } else {
	nl();
	fprintf(output, "\t.byte %d", val & 0x00ff);
	gentype = bytegen;
	outcol = 19;
    }
}

genword(val)
    int             val;
{
    /* stupid assembler has no .word */
    /* emit low byte, high byte */
    genbyte(val & 255);
    genbyte((val >> 8) & 255);
}

#ifndef NOFLOAT
genfloat(val)
    double          val;
{
    fprintf(output,"\t.float %20.15e\n",val);
}

gendouble(val)
    double          val;
{
    fprintf(output,"\t.double %20.15e\n",val);
}
#endif

genlong(val)
    long            val;
{
    if (gentype == longgen && outcol < 56) {
	fprintf(output, ",%ld", val);
	outcol += 10;
    } else {
	nl();
	fprintf(output, "\t.long %ld", val);
	gentype = longgen;
	outcol = 25;
    }
}

genptr(node)
    struct enode   *node;
{
    if (gentype == longgen && outcol < 56) {
	putc(',', output);
	putconst(node);
	outcol += 10;
    } else {
	nl();
	fputs("\t.long ", output);
	putconst(node);
	gentype = longgen;
	outcol = 25;
    }
}


genstorage(sp, align)
    struct sym     *sp;
    int             align;
{
    long size = sp->tp->size;
    long remain;
    nl();
/*
 * round up size so that it will fit all needs
 */
    remain = size % AL_DEFAULT;
    if (remain != 0)
        size = size + AL_DEFAULT - remain;
    if (sp->storage_class == sc_static) {
	fprintf(output, ".lcomm .%ld,%ld\n", sp->value.i, size);
        lc_bss += sp->tp->size;
     } else {
	fprintf(output, ".comm %s,%ld\n", outlate(sp->name),size);
        sp->value.i = -1;
     }
}


int
stringlit(s, len)
/*
 * mk_ s a string literal and return it's label number.
 */
    char           *s;
    int             len;	/* without \0 */
{
    struct slit    *lp;
    char           *p;
    int             local_global = global_flag;
    global_flag = 0;		/* always allocate from local space. */
    lp = (struct slit *) xalloc((int) sizeof(struct slit));
    lp->label = nextlabel++;
    p = lp->str = (char *) xalloc(len);
    lp->len = len;
    while (len--)
	*p++ = *s++;
    lp->next = strtab;
    strtab = lp;
    global_flag = local_global;
    return lp->label;
}

dumplits()
/*
 * dump the string literal pool.
 */
{
    char           *cp;
    int             len;
    while (strtab != 0) {
	dseg();
	nl();
	put_label((unsigned int) strtab->label);
	cp = strtab->str;
	len = strtab->len;
	while (len--)
	    genbyte(*cp++);
	genbyte(0);
	strtab = strtab->next;
    }
    nl();
}


put_external(s)
    char           *s;
/* put the definition of an external name in the ouput file */
/* assembler can find out about externals itself. This also has the
 * advantage that I don't have to worry if the symbol is in text or
 * data segment. Therefore this function is a noop
 */
{
}


put_global(s)
    char           *s;
/* put the definition of a global name in the output file */
{
    fputs(".globl ", output);
    fputs(outlate(s), output);
    putc('\n', output);
}

put_align(align)
    int             align;
/* align the following data */
{
/*
 * In the default GAS setup, .align n aligns to a boundary of
 * 2**n
 */
    switch (align) {
      case 1:
        break;
      case 2:
#ifdef SUN_ASM_SYNTAX
        fputs("\t.align 2\n",output);
#else
        fputs("\t.align 1\n",output);
#endif
        break;
      case 4:
#ifdef SUN_ASM_SYNTAX
        fputs("\t.align 4\n",output);
#else
        fputs("\t.align 2\n",output);
#endif
        break;
      default:
        fatal("PUT_ALIGN");
    }
}

nl()
{
    if (outcol > 0) {
	putc('\n', output);
	outcol = 0;
	gentype = nogen;
    }
}

cseg()
{
    if (curseg != codeseg) {
	nl();
	fputs("\t.text\n", output);
	curseg = codeseg;
    }
}

dseg()
{
    if (curseg != dataseg) {
	nl();
	fputs("\t.data\n", output);
	curseg = dataseg;
    }
}

static char           *
outlate(s)
    char           *s;
{
    static char     symbol[MAX_ID_LEN + 1];
    if (*s == '.')
        return s;
    symbol[0] = '_';
    strcpy(symbol + 1, s);
    return symbol;
}

#endif /* TARGET_BAS */
#endif /* INTEL_386 */
