/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <string.h>
#include "MuWin.h"
#include "MmDecl.h"

void
                DisplayCurLetterPartialCallback(),
                DisplayCurLetterWholeCallback();

void
ClearCutBufferAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  XStoreBytes(XtDisplay(widget), "", 1);
}

void
CloseWindowAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  if ((widget = XtWindowToWidget(event->xany.display, event->xany.window)) 
	  == NULL) return;
  CloseWindow(WidgetToScn(widget));
}

void
IconifyWindowAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  IconifyWindowCallback(widget, WidgetToScn(widget), (XtPointer)NULL);
}

void
HighlightCurrentLineAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  HighlightCurrentLine(widget);
}

void
SetCurLetterNumberAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SetCurLetterNumber(WidgetToScn(widget));
}

void
HighlightToEndOFLineAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SCREEN *scn = WidgetToScn(widget);
  HighlightToEndOFLine(scn->toc.tocW);
}

void
IncCurLetterNumberAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SCREEN *scn = WidgetToScn(widget);
  
  if (scn->folder.curLetterN + 1 > scn->folder.numLetters - 1) return;
  ++(scn->folder.curLetterN);
}

void
DecrCurLetterNumberAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SCREEN *scn = WidgetToScn(widget);
  
  if (scn->folder.curLetterN - 1 < 0) return;
  --(scn->folder.curLetterN);
}

/*---------------------------------------------------------------------------+
| Body box actions.
+---------------------------------------------------------------------------*/

void
BodyBoxNextPageAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CallSimpleAction(WidgetToScn(widget)->bodyW, "next-page");
}

void
BodyBoxPrevPageAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CallSimpleAction(WidgetToScn(widget)->bodyW, "previous-page");
}

void
BodyBoxNextLineAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CallSimpleAction(WidgetToScn(widget)->bodyW, "next-line");
}

void
BodyBoxEndOfPageAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  MoveToEndOfPage(WidgetToScn(widget)->bodyW);
}

/*---------------------------------------------------------------------------+
| Letter actions.
+---------------------------------------------------------------------------*/

void
RedisplayCurLetterPartialAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  DisplayCurLetterPartialCallback(widget, WidgetToScn(widget), 
								  (XtPointer)NULL);
}

void
DisplayLetterGeneralAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SCREEN          *scn = WidgetToScn(widget);

  BodyBoxEndOfPageAction(widget, event, param, numParam);

  if (scn->folder.curDispLetN != scn->folder.curLetN)
	RedisplayCurLetterPartialAction(widget, event, param, numParam);

  else if (FindEndOfCurrentLine(scn->bodyW) == FindEndOfBuffer(scn->bodyW)) {
	CallSimpleAction(scn->toc.tocW, "next-line");
	HighlightCurrentLine(scn->toc.tocW);
	SetCurLetterNumber(scn);
	RedisplayCurLetterPartialAction(widget, event, param, numParam);
  }
  
  else
	BodyBoxNextPageAction(widget, event, param, numParam);
}

void
RedisplayCurLetterWholeAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  DisplayCurLetterWholeCallback(widget, WidgetToScn(widget), (XtPointer)NULL);
}

void
DisplayInsertionPointPosAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  printf("pos = %d\n", 
		 XawTextGetInsertionPoint(WidgetToScn(widget)->toc.tocW));
}

void
OpenFolderAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  OpenFolderCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

void
SaveFolderAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SaveFolderCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}


void
CommitChangesAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CommitChangesCallback(widget, (XtPointer)WidgetToScn(widget), 
						(XtPointer)NULL);
}

void
FolderInfoAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  FolderInfoCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

void
QuickExitAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  QuickExit(WidgetToScn(widget));
}

void
ExitAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ExitCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

void
TagUntagLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  TagUntagLetterCallback(widget, (XtPointer)WidgetToScn(widget), 
						 (XtPointer)NULL);
}

void
RetagLettersAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  RetagLettersCallback(widget, (XtPointer)WidgetToScn(widget), 
					   (XtPointer)NULL);
}

void
DeleteLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  DeleteLetterCallback(widget, (XtPointer)WidgetToScn(widget), 
					   (XtPointer)NULL);
}

void
UndeleteLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  UndeleteLetterCallback(widget, (XtPointer)WidgetToScn(widget), 
						 (XtPointer)NULL);
}

void
ComposeLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ComposeLetter(WidgetToScn(widget));
}

void
ReplyToLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ReplyToLetter(WidgetToScn(widget));
}

void
ForwardLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ForwardLetter(WidgetToScn(widget));
}

void
ExternalComposeLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ExternalComposeLetter(WidgetToScn(widget));
}

void
CopyLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CopyLetterCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

void
RefileLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  RefileLetterCallback(widget, (XtPointer)WidgetToScn(widget), 
					   (XtPointer)NULL);
}

void
LetterInfoAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  LetterInfo(WidgetToScn(widget));
}

void
SendDraftAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SendDraftCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

void
CancelDraftAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  CancelDraftCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

void
QuoteRnStyleAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  QuoteRnStyleCallback(widget, (XtPointer)WidgetToScn(widget), 
					   (XtPointer)NULL);
}

void
QuoteScStyleFmtAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  NonNestedCitation(WidgetToScn(widget), CITE_FMT);
}

void
QuoteScStyleUnfmtAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  NonNestedCitation(WidgetToScn(widget), CITE_UNFMT);
}

void
InsertSignatureAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  InsertSignatureCallback(widget, (XtPointer)WidgetToScn(widget), 
						  (XtPointer)NULL);
}

/*---------------------------------------------------------------------------+
| Menu actions.
+---------------------------------------------------------------------------*/

void
MenuButtonPopdownMenuAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  String          menuName;
  Widget          menuW;

  XtVaGetValues(widget, XtNmenuName, &menuName, NULL);
  if ((menuW = XtNameToWidget(widget, menuName)))
	XtPopdown(menuW);
  else printf("null\n");
}

void
PopupMenuIfMenuButtonAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  Widget          entry = XawSimpleMenuGetActiveEntry(widget);

  if (entry == NULL) return;

  if (XtClass(entry) == menuButtonWidgetClass)
	XtCallActionProc(entry, "PopupMenu", event, param, *numParam);
}
