/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmBoduBox.c --- Body box routines
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Fri Jun  4 10:40:58 1993
 * Update Count    : 8
 * Status          : Mostly OK, needs some cleaning up
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include "MuWin.h"
#include "MuGeneric.h"
#include "MmDecl.h"

Boolean
BodyBoxEditable(scn)
	 SCREEN           *scn;
{
  XawTextEditType editType;

  XtVaGetValues(scn->bodyW, XtNeditType, &editType, NULL);
  return (Boolean)(editType == XawtextEdit);
}

void 
DisplayBufferInBodyBox(scn, buffer)
	 SCREEN           *scn;
	 String            buffer;
{
  XawTextDisableRedisplay(scn->bodyW);
  XtVaSetValues(scn->bodyW, XtNtype, XawAsciiString, XtNstring, buffer, 
				XtNdisplayCaret, False, XtNeditType, XawtextRead, 
				XtNwrap, XawtextWrapLine, NULL);
  XawTextEnableRedisplay(scn->bodyW);
}

void 
DisplayFileInBodyBox(scn, fileName)
	 SCREEN           *scn;
	 String            fileName;
{
  String          buffer,
                  fullName;

  if ((buffer = CopyFileToBuffer((fullName = ExpandTilda(fileName)))) == NULL) 
	return;
  CloneString(&scn->edit.fileName, fullName);

  DisplayBufferInBodyBox(scn, buffer);
  XtFree(buffer);
}

void 
EditBufferInBodyBox(scn, buffer)
	 SCREEN           *scn;
	 String            buffer;
{
  XawTextDisableRedisplay(scn->bodyW);
  XtVaSetValues(scn->bodyW, XtNtype, XawAsciiString, XtNstring, buffer, 
				XtNeditType, XawtextEdit, XtNdisplayCaret, True, 
				XtNwrap, XawtextWrapNever, NULL);
  XawTextEnableRedisplay(scn->bodyW);
}

void
EditFileInBodyBox(scn, fileName)
	 SCREEN          *scn;
	 String          fileName;
{
  String          buffer,
                  fullName;
  
  if ((buffer = CopyFileToBuffer((fullName = ExpandTilda(fileName)))) == NULL) 
	return;
  CloneString(&scn->edit.fileName, fullName);

  EditBufferInBodyBox(scn, buffer);
  XtFree(buffer);
}

void
ExternalEditFileOfBodyBoxCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;

  if (XawAsciiSaveAsFile(XawTextGetSource(scn->bodyW), scn->edit.fileName) 
	  == False) return;

  ExternalEditFile(scn->edit.fileName);
  EditFileInBodyBox(scn, scn->edit.fileName);
} 

String
GetTextSourceOfBodyBox(scn)
	 SCREEN          *scn;
{
  /* If something goes wrong, we want it to return NULL */
  String          buffer = NULL;

  XtVaGetValues(scn->bodyW, XtNstring, &buffer, NULL);
  return buffer;

  /* Will be freed at the next call */
}
