/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmDecl.h --- Declarations headers file
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Sun Jun 20 15:54:08 1993
 * Update Count    : 36
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"
#include <X11/Intrinsic.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>
#include <time.h>

extern String
                GetTextSourceOfBodyBox(),

                ConstructLetter(),

                FormatParagraph(),
                GetTextSource(),
                GetCurrentTextSelection(),
                TextFindHeaderField(),

                BuildAddress(),

                DialogPrompt(),

                FileFullName(),
                FileBaseName(),
                FolderFullName(),
                FileInMumailDir(),

                SelectFile(),

                XMailerMessage();


Boolean
                BodyBoxEditable();

extern int

                ExternalEditFileOfBodyBox(),

                PrepareDraft(),

                QueryMailBox(),
                OpenFolder(),
                CbSaveFolder(),
                CommitChanges(),

                DisplayLetterInBodyBox(),
                DisplayLetterProc(),
                DisplayCurLetterProc(),

                DeleteLetterProc(),
                UndeleteLetterProc(),
                ComposeLetter(),
                ReplyToLetter(),
                ForwardLetter(),
                ExternalComposeLetter(),
                CopyLetter(),
                RefileLetterProc(),
                DeleteLetter(),
                UndeleteLetter(),
                LetterInfo(),

                BusyPointer(),
                Anim(),
                KeyboardFocus(),
                BooleanPrompt(),

                SetCurLetterNumber(),

                ReadParseMailFile(),

                GetLettersFromFolder(),
                ActualOpenFolder(),
                SaveFolder(),

                TocSetLetterFlag(),               
                MarkLetterAsRepliedTo(),
             
                InsertText(),        
                InsertFile();

extern XawTextPosition 
                FindEndOfLine(),
                FindEndOfCurrentLine(),
                FindEndOfBuffer(),

                SearchForText(),
                ReplaceTextByPos(),
                ReplaceText();

  
extern void

                CloseWindow(),
                QuickExit(),
                ExitCallback(),

                DisplayBufferInBodyBox(),
                DisplayFileInBodyBox(),
                EditFileInBodyBox(),

                EditDraft(),
                CancelDraftCallback(),
                NonNestedCitation(),
                InsertLetterWhole(),
                InsertSignatureCallback(),

                ParseFolderName(),
                OpenFolderCallback(),
                OpenFolderCallback1_1(),

                ViewLetterCallback(),
                DisplayCurLetterPartialCallback(),
                TagUntagLetterCallback(),
                RetagLettersCallback(),
                DeleteLetterCallback(),
                UndeleteLetterCallback(),
                CopyLetterCallback(),
                RefileLetterCallback(),

                CompactFolder(),

                Message(),
                MessagePError(),
                AnimStart(),
                AnimStop(),
                FileChooserCallback(),
                DisableDialogInput(),
                DelayedCallback(),

                ScrollTextToLine(),

                CallAction(),
                CallSimpleAction(),
                MoveToStartOfLine(),
                MoveToEndOfLine(),
                MoveToNextLine(),
                MoveToPrevLine(),
                MoveToStartOfBuffer(),
                MoveToEndOfBuffer(),
                MoveToStartOfParagraph(),
                MoveToEndOfPage(),

                ReMakeToc(),
                RedisplayToc(),
                ScrollTocToLine(),
                TocHighlightLetter(),

                ClearCutBufferAction(),
                SetCurLetterNumberAction(),
                ViewCurLetterAction(),
                IncCurLetterNumberAction(),
                DecrCurLetterNumberAction(),

                DisplayLogo(),
                CreateMainMenu(),

                HighlightCurrentLine(),
                HighlightToEndOFLine();

/*---------------------------------------------------------------------------+
| Callbacks.
+---------------------------------------------------------------------------*/

extern void

         NotImplementedCallback(),
         NewWindowCallback(),
         CloseWindowCallback(),
         IconifyWindowCallback(),
         ExitCallback(),
         QuickExitCallback(),

         CheckMailBoxCallback(),
         IncorporateNewMailCallback(),
         OpenFolderCallback(),
         OpenFolderViaFileChooserCallback(),
         ReOpenFolderCallback(),
         OpenFolderInNextScreenCallback(),
         NewFolderCallback(),
         SaveFolderCallback(),
         SaveFolderAsCallback(),
         SaveFolderAsCompressedCallback(),
         SaveFolderAsGZippedCallback(),
         SaveFolderAsUnpackedCallback(),
         EditFolderCallback(),
         DeleteFolderCallback(),
         CommitChangesCallback(),
         SortFolderCallback(),
         SearchFolderCallback(),
         FolderInfoCallback(),
         RedisplayTocCallback(),
         ReDrawTocCallback(),

         DisplayCurLetterPartialCallback(),
         DisplayCurLetterWholeCallback(),
         DisplayLetterPartialInNextScreenCallback(),
         PipeLetterToMimeCommandCallback(),
         ComposeLetterCallback(),
         ReplyToLetterCallback(),
         ForwardLetterCallback(),
         FollowUpToLetterCallback(),
         QuoteScStyleFmtAndReplyCallback(),
         QuoteScStyleUnfmtAndReplyCallback(),
         QuoteRnStyleAndReplyToLetterCallback(),
         ExternalComposeLetterCallback(),
         ExternalReplyToLetterCallback(),
         LetterInfoCallback(),

         TagAllLettersCallback(),
         TagRangeOfLettersCallback(),
         UntagAllLettersCallback(),
         PipeLetterCallback(),
         PrintLetterCallback(),
         BurstDefactoDigestCallback(),
         BurstGrottyDigestCallback(),

         SendDraftCallback(),
         ExpandAliasesCallback(),
         ExpandMimeInclusionsCallback(),
         QuoteScStyleFmtCallback(),
         QuoteScStyleUnfmtCallback(),
         QuoteRnStyleCallback(),
         InsertSignatureCallback(),
         InsertLetterBodyCallback(),
         InsertLetterPartialCallback(),
         InsertLetterWholeCallback(),
         CancelDraftCallback(),

         GotoEditCallback(),
         EditSaveCallback(),
         EditCancelCallback(),
         EditCutCallback(),
         EditCutEolCallback(),
         EditPasteCallback(),
         EditSearchCallback(),
         EditInsertFileCallback(),
         EditFormatCallback(),
         EditRedrawCallback(),
         ExternalEditFileOfBodyBoxCallback(),

         EditCustomHeadersCallback(),
         EditAliasesCallback(),
         ViewAnyFileCallback(),
         EditAnyFileCallback(),

         HelpAllCallback(),
         HelpOverviewCallback(),
         HelpOptionsCallback(),
         HelpResourcesCallback(),
         HelpMailAgentsCallback(),
         HelpAliasesCallback(),
         HelpMimeCallback(),
         HelpMenusCallback(),
         HelpBindingsCallback(),
         HelpFilesCallback(),
         HelpBugsCallback(),
         HelpCopyrightCallback(),
         HelpAuthorCallback(),
         HelpAckCallback(),
         HelpNewsCallback();


#define MAX_SCREENS 10
#define MAX_BUFFERS 256
#define MAX_LETTERS 9999
#define MAX_HEADERS 256
#define MAX_ALIASES 256
#define MAX_FCC     256

#define INFOLDER_NAME      "MUINBOX"
#define DRAFT_NAME         "draft"
#define SIG_FILE           ".signature"
#define HEADERS_FILE       "headers"
#define ALIASES_FILE       "aliases"

#define FROM_TITLE             "From:"
#define QUOTED_FROM_TITLE      ">From:"
#define TO_TITLE               "To:"
#define SUBJECT_TITLE          "Subject:"
#define DATE_TITLE             "Date:"
#define REPLY_TO_TITLE         "Reply-To:"
#define READ_TITLE             "Read:"
#define REPLIED_TITLE          "Replied:"
#define CC_TITLE               "cc:"
#define BCC_TITLE              "Bcc:"
#define FCC_TITLE              "Fcc:"
#define MIME_VERSION_TITLE     "MIME-Version:"
#define CONTENT_TYPE_TITLE     "Content-Type:"
#define CHAR_SET_TITLE         "charset="
#define BOUNDARY_TITLE         "boundary="
#define TRANSFER_ENCODING_TITLE "Content-Transfer-Encoding:"

#define curLetterN curLetN
#define DRAFT_NO_REPLY         -1
#define DRAFT_MODE_COMPOSE     1
#define DRAFT_MODE_REPLY       2
#define DRAFT_MODE_FOLLOW_UP   3

#define MIME_VERSION        "1.0"

#define LETTER_COMP_DELIMITER "-- letter body follows --"

#define QM_NO_MAILBOX_NAME   -10
#define QM_STAT_ERROR        -11
#define QM_MAILBOX_EMPTY     0
#define QM_MAILBOX_HAS_MAIL  1

#define TOC_CLEAR_FLAG     " "
#define TOC_UNREAD_FLAG    "N"
#define TOC_READ_FLAG      TOC_CLEAR_FLAG
#define TOC_DEL_FLAG       "D"
#define TOC_REPL_FLAG      "R"
#define TOC_TAG_FLAG       "T"
#define TOC_MIME_FLAG      "M"

#define LETTER_NEW         (1<<1)
#define LETTER_UNREAD      (1<<2)
#define LETTER_READ        (1<<3)
#define LETTER_REPLIED     (1<<4)
#define LETTER_DELETED     (1<<5)
#define LETTER_TAGGED      (1<<6)
#define LETTER_RETAG       (1<<7)
#define LETTER_MIME        (1<<10)

#define LETTER_MAKE_BODY             1
#define LETTER_MAKE_PARTIAL          2
#define LETTER_MAKE_WHOLE            3
#define LETTER_MAKE_WITH_DELIMITER   4
#define LETTER_MAKE_FOR_FOLDER       5

#define CONTENT_TYPE_TEXT_PLAIN      1
#define CONTENT_TYPE_OTHER         100

#define MIME_TYPE_TEXT_PLAIN_S "text/plain"
#define MIME_TYPE_MULTIPART_MIXED_S "multipart/mixed"

#define MIME_INVOKE_NEVER     1
#define MIME_INVOKE_ALWAYS    2
#define MIME_INVOKE_ASK       3

#define MSG_CLEAR_NEVER     0
#define MSG_REMOVE_TIMER    0
#define MSG_CLEAR_DEFAULT  15	/* in seconds */

#define KEYBOARD_FOCUS_SET      1
#define KEYBOARD_FOCUS_RESTORE  2
#define KEYBOARD_FOCUS_CLEAR    3  

#define DP_OK                 1
#define DP_CANCEL             2
#define BP_YES                1
#define BP_NO                 2

#define CITE_UNFMT            1
#define CITE_FMT              2

#define SET_BUSY_POINTER       0
#define ANIMATE_BUSY_POINTER   1
#define CLEAR_BUSY_POINTER    10

#define DIALOG_INACTIVE        0
#define DIALOG_MODE_VALUE      1
#define DIALOG_MODE_BOOLEAN    2

#define BUF10       10
#define BUF80       80
#define BUF256      256

#define CNULL       ('\0')
#define SPACE       (' ')
#define NEWLINE     ('\n')
#define TAB         ('\t')

/*---------------------------------------------------------------------------+
| Macros.
+---------------------------------------------------------------------------*/

#define OpenStream(fp,name,mode,retValue)\
  {if ((fp = fopen(name, mode)) == NULL)\
     {MuPError(FmtString1("Could not open file ``%s''", name));\
	  return retValue;}}

#define SetupTextBlock(var,text){\
  textBlock.ptr = text; textBlock.firstPos = 0;\
  textBlock.length = strlen(textBlock.ptr);\
  textBlock.format = FMT8BIT;}

#define SimpleMessage(scn,msg) Message(scn,msg,MSG_CLEAR_DEFAULT)
#define SimpleErrorMsg(scn,msg,ret) {SimpleMessage(scn,msg); return ret;}

#define SetKeyboardFocus(scn,widget)\
  KeyboardFocus(scn,widget,KEYBOARD_FOCUS_SET)
#define RestoreKeyboardFocus(scn)\
  KeyboardFocus(scn,(Widget)NULL,KEYBOARD_FOCUS_RESTORE)

#define EditMode(scn,mode)\
  {scn->edit.active = mode;\
   KeyboardFocus(scn, scn->bodyW, mode ? KEYBOARD_FOCUS_SET :\
				 KEYBOARD_FOCUS_RESTORE);\
   XtVaSetValues(scn->edit.buttonW, XtNsensitive, mode, NULL);}
#define DraftMode(scn,mode)\
  {scn->draft.active = mode;\
   XtVaSetValues(scn->draft.buttonW, XtNsensitive, mode, NULL);\
   EditMode(scn,mode);\
   XtVaSetValues(scn->edit.cancelW, XtNsensitive, !mode, NULL);}

#define LetterNumberOk(scn,letterN)\
  (!(letterN < 0 || letterN > scn->folder.numLetters - 1))
#define CheckIfLetterOk(scn,letterN,ret)\
  {if (!LetterNumberOk(scn,letterN)) return ret;}

#define ErrorIfEditOrDialogMode(scn,ret)\
  {if (scn->edit.active || scn->dialog.mode != DIALOG_INACTIVE) return ret;}
#define ErrorIfBodyBoxNotEditable(scn,ret)\
  {if (!BodyBoxEditable(scn)) return ret;}

/*---------------------------------------------------------------------------+
| Structures.
+---------------------------------------------------------------------------*/

typedef struct {
  String          name;
  String          path;
  String          buffer[MAX_BUFFERS];
  int             numLetters;
  int             curLetN;
  int             curDispLetN;
  Boolean         changed;
  int             numTagged;

  Boolean         unused3;
  Boolean         unused4;
} Folder;

typedef struct {
  String          fullS;
  time_t          timeU;
} Date;

typedef struct {
  String          mimeVersionS;
  int             mimeVersion;
  String          contentTypeS;
  int             contentType;
} Mime;

typedef struct {
  int             number;
  long            totalLength;

  String          delimiter;

  String          from;
  String          to;
  String          subject;
  String          cc;
  Date            date;
  String          replyTo;
  Mime            mime;

  String          otherHeaders;
  String          content;
  
  String          readS;
  String          repliedS;

  int             status;

  Boolean         unused1;
  Boolean         unused2;
  Boolean         unused3;
  Boolean         unused4;
  Boolean         unused5;
  Boolean         unused6;
  Boolean         unused7;
} Letter;

typedef struct {
  Widget          buttonW;
  String          name;
  String          tmpName;
  Boolean         active;
  int             replLetN;

  Boolean         unused1;
  Boolean         unused2;
  Boolean         unused3;
} Draft;

typedef struct {
  Widget          tocW;
  String          tocS;
  int             flagPos;
  
  Boolean         unused1;
  Boolean         unused2;
} Toc;

typedef struct {
  Widget          valueW;
  Widget          yesW;
  Widget          noW;
  Widget          cancelW;
  int             mode;

  Boolean         unused1;
  Boolean         unused2;
} Dialog;

typedef struct {
  Widget          buttonW;
  Widget          saveW;
  Widget          cancelW;

  String          fileName;
  Boolean         active;

  Boolean         unused1;
  Boolean         unused2;
  Boolean         unused3;
  Boolean         unused4;
} Edit;

typedef struct {
  XtPointer field[6];
} ClientDataRec;

typedef struct {
  int             number;

  Widget          topLevelW;
  Widget          parentW;
  Widget          panedW;
  Widget          labelW;
  Widget          bodyW;

  Folder          folder;
  Letter          *letterList[MAX_LETTERS];
  Draft           draft;

  Toc             toc;  
  Dialog          dialog;
  Edit            edit;
  ClientDataRec   clientDataRec1;
  /* Reserved for the dialog box internal use */
  ClientDataRec   clientDataRec2;

  Boolean         unused1;
  Boolean         unused2;
  Boolean         unused3;
  Boolean         unused4;

} SCREEN;


typedef struct {
  String          externalEditor;
  String          printCommand;

  Boolean         mailAgentPassAddress;
  String          mailAgentProgram;
  String          mailAgentArgs;

  String          mimeCommand;
  String          invokeMimeS;
  int             invokeMime;
  Boolean         addMimeHeaders;
  String          defaultContentType;
  String          defaultCharSet;
  String          defaultTransferEncoding;
  String          mimeBoundary;

  int             quoteFillColumn;
  String          quoteIndentString;
  String          quoteNestedAttribFmt;
  String          quoteNonNestedAttribFmt;

  String          signatureFile;

  String          unused2;
  String          unused3;
  String          unused4;
  String          unused5;
  String          unused6;
  String          unused7;
  String          unused8;
  String          unused9;
} QueryResources;

typedef Draft DRAFT;
typedef Edit EDIT;
typedef Dialog DIALOG;
typedef Letter LETTER;
typedef Folder FOLDER;
typedef ClientDataRec _clientDataRec;

extern QueryResources res;

extern SCREEN
                *AddScreen(),
                *FirstScreen(),
                *NextScreen(),
                *WidgetToScn(),
                *NewWindowProc();
