/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>
#include <string.h>
#include "MuGeneric.h"
#include "MmDecl.h"

#define DIGEST_TYPE_DEFACTO        1
#define DIGEST_TYPE_GROTTY         2

#define DIGEST_DEFACTO_FIRST_LETTER_DELIMITER \
"\n----------------------------------------------------------------------\n\n"
#define DIGEST_DEFACTO_LETTER_END_DELIMITER \
  "\n\n------------------------------\n\n"
#define DIGEST_DEFACTO_TRAILER_DELIMITER "End of "

#define DIGEST_GROTTY_LETTER_DELIMITER \
  "------------------------------\n"

extern Letter   *ExtractLetterComponents();

String
DigestGetNextLetterStart(mailBuffer, type)
	 String          mailBuffer;
	 int             type;
{
  static String          curBufPos, delim;
  String                 bufPtr;

  if (mailBuffer)
	delim = type == DIGEST_TYPE_DEFACTO ? 
	  DIGEST_DEFACTO_FIRST_LETTER_DELIMITER : 
		DIGEST_GROTTY_LETTER_DELIMITER;

  else {
	mailBuffer = curBufPos;
	delim = type == DIGEST_TYPE_DEFACTO ? 
	  DIGEST_DEFACTO_LETTER_END_DELIMITER : 
		DIGEST_GROTTY_LETTER_DELIMITER;
  }

  if ((bufPtr = Strstr(mailBuffer, delim)) == NULL)
	return NULL;

  /* With this each message is guarantted to end with a newline, since
	 RFC-1153 stipulates that the message must be separated from the
	 rest of the digest with a bank line followed by the separator */

  /* Delimit the end of the previous letter. Add 3 (2 would be enough,
	 actually) to catch the newlines that are part of the delimiter */
  for (curBufPos = bufPtr+3; 
	   curBufPos > mailBuffer && *curBufPos != NEWLINE; curBufPos--);
  *curBufPos = CNULL;

  curBufPos = bufPtr + strlen(delim);

  /* Check to see if this is the trailer and not a message */
  if (strncmp(curBufPos, DIGEST_DEFACTO_TRAILER_DELIMITER, 
			  strlen(DIGEST_DEFACTO_TRAILER_DELIMITER)) == 0) {
	*curBufPos = CNULL;
	return NULL;
  }

  return curBufPos;
}

String
DigestGetNextLetter(mailBuffer, type)
	 String          mailBuffer;
	 int             type;
{
  static String          nextLetterStart;
  String                 letterStart;

  if (mailBuffer == NULL) letterStart = nextLetterStart;
  else if ((letterStart = DigestGetNextLetterStart(mailBuffer, type)) == NULL) 
	return (nextLetterStart = NULL);

  /* This would happen if nextLetterStart from the previous call was NULL */
  if (letterStart == NULL) return letterStart;

  nextLetterStart = DigestGetNextLetterStart(NULL, type);

  /* Remove white space preceeding the headers */
  return StripStringB(letterStart);
}

int
ExtractLettersFromDigest(scn, digest, defaultLet, type)
	 SCREEN          *scn;
	 String          digest;
	 Letter          *defaultLet;
	 int             type;
{
  String          rawLetter;
  int             i, curBuffer, 
                  numLetters = scn->folder.numLetters;

  AnimStart(scn);
  Message(scn, "Exploding digest...", MSG_CLEAR_DEFAULT);

  /* Find the first avilable buffer */
  for (i = 0; scn->folder.buffer[i]; i++);
  curBuffer = i;

  scn->folder.buffer[i] = XtNewString(digest);
  scn->folder.buffer[++i] = NULL;

  for (i = numLetters; 
	   (rawLetter = DigestGetNextLetter(i == numLetters ? 
		scn->folder.buffer[curBuffer] : NULL, type)); 
	   i++) {
	
	scn->letterList[i] = ExtractLetterComponents(rawLetter, defaultLet);
	Anim(scn);
  }
  
  scn->letterList[i] = NULL;
  scn->folder.numLetters = i;

  /* No CompactFolder here */
  AnimStop(scn);
  return scn->folder.numLetters - numLetters;
}

void 
BurstDigestProc(scn, type)
	 SCREEN          *scn;
	 int             type;
{
  Letter          *letter;
  int             numLetters;
  
  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  if ((numLetters = 
	   ExtractLettersFromDigest(scn, letter->content, letter, type))
	  == 0) {
	SimpleMessage(scn, "Not a recognized digest");
	return;
  }

  scn->folder.changed = True;
  ReMakeToc(scn);
  SimpleMessage(scn, FmtString1("Digest exploded into %d letters", 
								numLetters));
}

void 
BurstDefactoDigestCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  BurstDigestProc(scn, DIGEST_TYPE_DEFACTO);
}

void 
BurstGrottyDigestCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  BurstDigestProc(scn, DIGEST_TYPE_GROTTY);
}
