/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmDraft.c --- Draft handling
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Sun Jun 20 15:54:08 1993
 * Update Count    : 12
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "MuWin.h"
#include "MuGeneric.h"
#include "MmDecl.h"

#define DRAFT_TO_TYPE            1
#define DRAFT_CC_TYPE            2
#define DRAFT_BCC_TYPE           3
#define DRAFT_FCC_TYPE           4
#define DRAFT_CONTENT_TYPE_TYPE  5
#define DRAFT_TRANSFER_ENCODING_TYPE 6

extern String
                FindHeaderFieldFromFile();

extern void
                InsertLetterBodyCallback();

/*---------------------------------------------------------------------------+
| Prepare draft routine.
+---------------------------------------------------------------------------*/

int
PrepareDraft(scn, mode)
	 SCREEN          *scn;
     int             mode;
{
  Letter          *letter;
  FILE            *draft;
  String          headersFile, headersBuf;

  CheckIfLetterOk(scn, scn->folder.curLetN,-1);
  letter = scn->letterList[scn->folder.curLetN];

  OpenStream(draft, FileInMailDir(scn->draft.name), "w", -1);
  
  if (mode == DRAFT_MODE_REPLY) 
	fprintf(draft, "%s %s\n%s %s%s\n%s %s\n",
			TO_TITLE, *letter->replyTo ? letter->replyTo : letter->from, 
			SUBJECT_TITLE, 
			CaseNStrSame(letter->subject, "Re:", 3) ? "" : "Re: ", 
			letter->subject,
			"In-reply-to: Your message of",  letter->date.fullS);
  else if (mode == DRAFT_MODE_FOLLOW_UP) 
	fprintf(draft, "%s %s\n%s %s%s\n%s %s\n",
			TO_TITLE, letter->to, 
			SUBJECT_TITLE,
			CaseNStrSame(letter->subject, "Re:", 3) ? "" : "Re: ", 
			letter->subject,
			"In-follow-up-to: The message of",  letter->from);
  else fprintf(draft, "%s \n%s \n", 
			   TO_TITLE, 
			   SUBJECT_TITLE);

  if (access(headersFile = FileInMumailDir(HEADERS_FILE), R_OK) == 0 &&
	  (headersBuf = CopyFileToBuffer(headersFile))) {
	/* Just to make sure the custom headers have no 
	   leading or trailing blank lines */
	fprintf(draft, "%s\n", CleanSimpleCommentedBuffer(headersBuf));
	XtFree(headersBuf);
  }

  if (res.addMimeHeaders)
	fprintf(draft, "%s %s\n%s %s; %s%s\n%s %s\n",  
			MIME_VERSION_TITLE, MIME_VERSION, 
			CONTENT_TYPE_TITLE, res.defaultContentType, 
			CHAR_SET_TITLE, res.defaultCharSet, 
			TRANSFER_ENCODING_TITLE, res.defaultTransferEncoding);

  fprintf(draft, "%s\n", LETTER_COMP_DELIMITER);
  fclose(draft);

  scn->draft.replLetN = mode == DRAFT_MODE_REPLY ? scn->folder.curLetN : 
	DRAFT_NO_REPLY;
  return 0;
}

#if 0
PrepareDraft(scn, mode)
	 SCREEN          *scn;
     int             mode;
{
  scn->clientDataRec1.field[0] = (XtPointer)scn;
  scn->clientDataRec1.field[1] = (XtPointer)(long)mode;

  if (acess(FileInMailDir(scn->draft.name), R_OK) < 0) {
	PrepareDraftCallBack1(scn->parentW, (XtPointer)&scn->clientDataRec1,
						  (XtPointer)NULL);
	

  case MIME_INVOKE_ASK:

	if (BooleanInputAndDispatch(scn, PipeLetterToMimeCommandCallback1, 
								(XtPointer)&scn->clientDataRec1) < 0) 
	  break;
	SimpleMessage(scn, "Letter content is not plain text, MIME-view?");
	break;
#endif 

void
EditDraft(scn)
	 SCREEN          *scn;
{
  EditFileInBodyBox(scn, FileInMailDir(scn->draft.name));
  DraftMode(scn, True);
}


int
ExpandAlias(alias)
	 String          *alias;
{
  static struct {
	String          alias;
	String          address;
  } aliasRec[MAX_ALIASES];

  struct stat     statInfo;
  static time_t   timeLastRead;
  static String   aliasBuf;
  String          aliasFile, 
                  lineStartPtr, lineEndPtr, sepPtr;
  int             i;

  if (*alias == NULL) return -1;

  /* Couldn't stat -> file possibly doesn't exist. No need to bother
	 with checking errno, the file seems problematic anyway */
  if (stat(aliasFile = FileInMumailDir(ALIASES_FILE), &statInfo) < 0)
	return 0;

  if (aliasRec[0].alias == NULL || statInfo.st_mtime > timeLastRead) {

	if (aliasBuf) XtFree(aliasBuf);
	if ((aliasBuf = CopyFileToBuffer(aliasFile)) == NULL) return -1;

	timeLastRead = time((int*)0);
	aliasBuf = CleanSimpleCommentedBuffer(aliasBuf);

	for (i = 0, lineStartPtr = lineEndPtr = aliasBuf; 
		 lineEndPtr && (sepPtr = strchr(lineStartPtr, '='));
		 lineStartPtr = lineEndPtr+1, i++) {

	  if ((lineEndPtr = strchr(sepPtr, NEWLINE))) *lineEndPtr = CNULL;
	  *sepPtr = CNULL;

	  aliasRec[i].alias = StripStringA(lineStartPtr);
	  aliasRec[i].address = StripStringA(++sepPtr);

	}
	aliasRec[i].alias = (String)NULL;
  }

  *alias = StripStringA(*alias);
  for (i = 0; aliasRec[i].alias; i++)
	if (strcmp(*alias, aliasRec[i].alias) == 0) {
	  *alias = aliasRec[i].address;
	  break;
	}

  return 0;
}

String
TokenizeHeaders(headersBuf)
     String          headersBuf;
{
  static String          lastBufPos;
  String                 curPtr;
  
  if (headersBuf == NULL) headersBuf = lastBufPos;
  curPtr = headersBuf = StripStringB(headersBuf);
  if (*curPtr == CNULL) return NULL;

  while (*curPtr && 
		 (*curPtr != NEWLINE || 
		  (*(curPtr+1) && isspace(*(curPtr+1))))) curPtr++;

  lastBufPos = curPtr ? curPtr+1 : curPtr;
  *curPtr = CNULL;
  return headersBuf;
}

#define MAX_ALIASES_PER_LINE 256

int
ExpandAliasLine(aliasesLine, addressPtr)
	 String          aliasesLine,
                     **addressPtr;
{
  static String          address[MAX_ALIASES_PER_LINE];
  int                    n, ret = 0;

  for (n = 0; (address[n] = strtok((n ? NULL : aliasesLine), ",")); n++)
	if (ExpandAlias(&address[n]) < 0 && ret >= 0) ret = -1;
  
  *addressPtr = address;
  return ret;
}

int
AppendDraftToFccFolder(scn, folder)
	 SCREEN          *scn;
	 String          folder;
{
  FILE            *folderFP;
  String          date, name, path, fullfolderName;
  time_t          curTime = time((time_t*)NULL);
  
  folder = StripStringA(folder);
  if (*folder == CNULL) return -1;
  
  if (FileIsPacked(folder)) {
	Message(scn, FmtString1("Cannot append to compressed folder (%s)", 
							folder), MSG_CLEAR_DEFAULT);
	MuError(FmtString1("Cannot append to compressed folder (%s)", folder));
	return -1;
  }
  
  ParseFolderName(folder, &name, &path);
  fullfolderName = FileFullName(name, path);

  if ((folderFP = fopen(fullfolderName, "a")) == NULL) {
	MessagePError(scn, FmtString1("Could not open folder %s", fullfolderName));
	return -1;
  }
  
  strftime(date = FmtString0(""), 80, "%a, %d %b %y %H:%M:%S %Z", 
		   localtime(&curTime));

  fprintf(folderFP, "From mailer-mumail %s\n%s %s\n", 
		  CurrentLocalTimeString(), DATE_TITLE, date);
  AppendFileToStream(FileInMailDir(scn->draft.name), folderFP);
  fprintf(folderFP, "\n\n"); 
  
  fclose(folderFP);
  return 0;
}

#define MI_ERR_NO_END_DELIMITER  -1
#define MI_ERR_NO_FILE_NAME      -2
#define MI_ERR_NO_CONTENT_TYPE   -3
#define MI_ERR_OPEN_READ_FILE    -4

#define DOLLAR_CHAR '$'
#define AT_CHAR     '@'

#define MIME_INCLUDE_CMD            "mime-include"
#define MIME_INCLUDE_CMD_DELIM      AT_CHAR
#define MIME_INCLUDE_CMD_PIPE_IDENT DOLLAR_CHAR

int
InsertMimedContent(draftFP, content)
	 FILE            *draftFP;
	 String          content;
{
  String          incCmd, incCmdLine, curContent, nextPartStart,
                  fileName, contentType, encoding,
                  fileBuffer;
  char            c;

  curContent = content; 
  while ((incCmdLine = CaseStrstr(curContent, incCmd = FmtString2("%c%s",
		 MIME_INCLUDE_CMD_DELIM, MIME_INCLUDE_CMD)))) {
	
	/* This is rather kludgy */
	if (*(incCmdLine-1) != NEWLINE && incCmdLine != content) 
	  {curContent += strlen(incCmd); continue;}

	/* NULL-terminate for NextWord, then increment */
	if ((nextPartStart = strchr(incCmdLine+1, MIME_INCLUDE_CMD_DELIM)))
	  *nextPartStart++ = CNULL; 
	else return MI_ERR_NO_END_DELIMITER;
	
	if ((fileName = NextWord(incCmdLine + strlen(incCmd))) == CNULL)
	  return MI_ERR_NO_FILE_NAME;
   	if ((contentType = NextWord(NULL)) == CNULL) return MI_ERR_NO_CONTENT_TYPE;
	if ((encoding = NextWord(NULL)) == CNULL) encoding = "";

	fileName = ExpandTilda(fileName);
	if ((fileBuffer = *fileName == MIME_INCLUDE_CMD_PIPE_IDENT ?
		 CopyPipeToBuffer(++fileName) : CopyFileToBuffer(fileName)) == NULL)
	  return MI_ERR_OPEN_READ_FILE;
	
	if ((content = StripStringB(content)) != incCmdLine) {
	  fprintf(draftFP, "\n--%s\n%s %s; %s%s\n%s %s\n",  
			  res.mimeBoundary,
			  CONTENT_TYPE_TITLE, res.defaultContentType, 
			  CHAR_SET_TITLE, res.defaultCharSet, 
			  TRANSFER_ENCODING_TITLE, res.defaultTransferEncoding);

	  c = *incCmdLine; *incCmdLine = CNULL;
	  fprintf(draftFP, "\n%s", content); 
	  *incCmdLine = c;
	}

	curContent = content = nextPartStart;	
	fprintf(draftFP, "\n--%s\n%s %s\n",  
			res.mimeBoundary,
			CONTENT_TYPE_TITLE, contentType);
	if (*encoding) fprintf(draftFP, "%s %s\n", 
						   TRANSFER_ENCODING_TITLE, encoding);
	fprintf(draftFP, "\n%s", fileBuffer); 
	XtFree(fileBuffer);
  }
  
  if (*(content = StripStringB(content)) != CNULL) {

	fprintf(draftFP, "\n--%s\n%s %s; %s%s\n%s %s\n",  
			res.mimeBoundary,
			CONTENT_TYPE_TITLE, res.defaultContentType, 
			CHAR_SET_TITLE, res.defaultCharSet, 
			TRANSFER_ENCODING_TITLE, res.defaultTransferEncoding);
	
	fprintf(draftFP, "\n%s", content); 
  }
  
  fprintf(draftFP, "\n--%s--\n",  res.mimeBoundary);

  return 0;
}

#define DRAFT_ERR_SAVE_DRAFT       -11
#define DRAFT_ERR_NO_DELIMITER     -12
#define DRAFT_ERR_OPENW_TMP_DRAFT  -13
#define DRAFT_ERR_MIME_INCLUSION   -14

#define FINAL_PROCESSING        (1<<1)
#define EXPAND_ALIASES          (1<<2)
#define EXPAND_MIME_INCLUSIONS  (1<<3)
#define FILE_IF_FCC             (1<<4)
#define BUILD_RECEIP_ADDR       (1<<5)

int
ProcessDraft(scn, receipient, mode)
	 SCREEN          *scn;
	 String          *receipient;
	 int             mode;
{
  FILE             *draftFP;
  char             addressLine[4096];
  String           draftBuf, headersEnd, content, *address, 
                   msg, mimeIncCmd;
  Boolean          writeToDraft, mimeInclude = False;
  int              n, i, tokenLen, ret = 0, retStatus;

  struct {
	String           string;
	String           title;
	int              type;
  } header[MAX_HEADERS];

  Anim(scn);

  /* Save the draft buffer */
  if (!XawAsciiSaveAsFile(XawTextGetSource(scn->bodyW), 
						  FileInMailDir(scn->draft.name))) {
	MessagePError(scn, FmtString1("Could not save draft to %s", 
								  scn->draft.name));
	return DRAFT_ERR_SAVE_DRAFT;
  }

  draftBuf = GetTextSourceOfBodyBox(scn);

  if ((headersEnd = strstr(draftBuf, LETTER_COMP_DELIMITER)) == NULL) {
	msg = FmtString0("Malformed draft: no header delimiter");
	if (mode & FINAL_PROCESSING) strcat(msg, ", not sending, draft left");
	SimpleMessage(scn, msg);
	return DRAFT_ERR_NO_DELIMITER;
  }
  
  *headersEnd = CNULL;
  /* Add 1 for the newline at the end of the delimiter */
  content = headersEnd + strlen(LETTER_COMP_DELIMITER) + 1;

  mimeIncCmd = FmtString2("%c%s", MIME_INCLUDE_CMD_DELIM, MIME_INCLUDE_CMD);
  if ((mode & EXPAND_MIME_INCLUSIONS) && 
	  (CaseNStrSame(content, mimeIncCmd, strlen(mimeIncCmd)) ||
	   CaseStrstr(content, FmtString("\n%s", mimeIncCmd)))) 
	mimeInclude = True;

  /* Parse the headers buffer into strings */
  for (n = 0; (header[n].string = TokenizeHeaders((n ? NULL : draftBuf))); 
	   header[n].type = 0, n++);

#define IdentifyHeader(token,tokType) {\
  tokenLen = strlen(token);\
  for (i = 0; i < n; i++)\
	if (header[i].type == 0 &&\
		CaseNStrSame(header[i].string, token, tokenLen)) {\
	  header[i].type = tokType;\
	  header[i].title = token;\
	  header[i].string += tokenLen;\
	  header[i].string = StripStringB(header[i].string);\
	}}

  Anim(scn);
  if (mode & EXPAND_ALIASES) {
	IdentifyHeader(TO_TITLE, DRAFT_TO_TYPE);
	IdentifyHeader(CC_TITLE, DRAFT_CC_TYPE);
	IdentifyHeader(BCC_TITLE, DRAFT_BCC_TYPE);
  }

  if (mode & FILE_IF_FCC)
	IdentifyHeader(FCC_TITLE, DRAFT_FCC_TYPE);

  if (mimeInclude) {
	IdentifyHeader(CONTENT_TYPE_TITLE, DRAFT_CONTENT_TYPE_TYPE);
	IdentifyHeader(TRANSFER_ENCODING_TITLE, DRAFT_TRANSFER_ENCODING_TYPE);
  }
#undef IdentifyHeader

  if ((draftFP = fopen(FileInMailDir(scn->draft.tmpName), "w")) == NULL) {
	MessagePError(scn, FmtString1("Could not save draft to %s", 
								  scn->draft.tmpName));
	return DRAFT_ERR_OPENW_TMP_DRAFT;
  }

  /* Will remain an empty string if mailAgentPassAddress is false */
  *addressLine = CNULL;
  for (i = 0; i < n; i++) {

	Anim(scn);
	if (header[i].type == DRAFT_TO_TYPE || 
		header[i].type == DRAFT_CC_TYPE ||
		header[i].type == DRAFT_BCC_TYPE) {

	  writeToDraft = (header[i].type != DRAFT_BCC_TYPE || 
					  !(mode & BUILD_RECEIP_ADDR) ||
					  !(mode & FINAL_PROCESSING));
	  if (writeToDraft)	fprintf(draftFP, "%s ", header[i].title); 

	  if (ExpandAliasLine(header[i].string, &address) < 0 && ret >= 0)
		ret = -1;
	  
	  if (writeToDraft)	fprintf(draftFP, "%s", *address);
	  if (mode & BUILD_RECEIP_ADDR) strcat(addressLine, *address);
	  
	  while (*++address) { 
		if (writeToDraft) fprintf(draftFP, ", %s", *address);
		if (mode & BUILD_RECEIP_ADDR) 
		  strcat(strcat(addressLine, " "), *address);
	  }
	  if (mode & BUILD_RECEIP_ADDR) strcat(addressLine, " ");
	  if (writeToDraft) fprintf(draftFP, "\n"); 
	}

	/* This will not happen unless FILE_IF_FCC is set,
	   do not write it to the draft */
	else if (header[i].type == DRAFT_FCC_TYPE);

	/* This will not happen unless mimeInclude == True */
	else if (header[i].type == DRAFT_CONTENT_TYPE_TYPE)
	  fprintf(draftFP, "%s %s\n", header[i].title, FmtString3("%s; %s%s", 
			  MIME_TYPE_MULTIPART_MIXED_S, BOUNDARY_TITLE, res.mimeBoundary));

	/* This will not happen unless mimeInclude == True, 
	   do not write it to the draft */
	else if (header[i].type == DRAFT_TRANSFER_ENCODING_TYPE); 
	
	else fprintf(draftFP, "%s\n", header[i].string);
  }

  if (mode & FINAL_PROCESSING) fprintf(draftFP, "%s\n", XMailerMessage());
  else fprintf(draftFP, "%s", LETTER_COMP_DELIMITER);

  if (!mimeInclude) fprintf(draftFP, "\n%s", content);
  else if ((retStatus = InsertMimedContent(draftFP, content)) < 0) {
	  msg = FmtString0("MIME inclusion: ");
	  switch(retStatus) {
	  case MI_ERR_NO_END_DELIMITER:
		strcat(msg, "missing end delimiter"); 
		break;
	  case MI_ERR_NO_FILE_NAME:
		strcat(msg, "missing file name"); 
		break;
	  case MI_ERR_NO_CONTENT_TYPE:
		strcat(msg, "missing content-type");
		break;
	  case MI_ERR_OPEN_READ_FILE:
		strcat(msg, "error in opening/reading the given file");
		break;
	  }
	  if (mode & FINAL_PROCESSING) strcat(msg, ", not sending, draft left");
	  SimpleMessage(scn, msg);
	  fclose(draftFP);
	  unlink(FileInMailDir(scn->draft.tmpName));
	  return DRAFT_ERR_MIME_INCLUSION;
	}

  fclose(draftFP);
  unlink(FileInMailDir(scn->draft.name));
  link(FileInMailDir(scn->draft.tmpName), FileInMailDir(scn->draft.name));
  unlink(FileInMailDir(scn->draft.tmpName));

  Anim(scn);
  if (mode & FILE_IF_FCC)
	for (i = 0; i < n; i++) if (header[i].type == DRAFT_FCC_TYPE) 
	  if (AppendDraftToFccFolder(scn, header[i].string) < 0) ret = -1;
  /* Trailing white space will be stripped in AppendDraftToFccFolder */

  *receipient = StripStringA(addressLine);
  Anim(scn);
  return ret;
}

/*---------------------------------------------------------------------------+
| Send draft routines.
+---------------------------------------------------------------------------*/

int
SendDraftProc(scn)
	 SCREEN          *scn;
{
  String          draftName, sendCmd, receipient;
  int             ret;

  if (scn->draft.active == False) return -1;

  AnimStart(scn);
  SimpleMessage(scn, "Sending letter...");

  if ((ret = ProcessDraft(scn, &receipient, FINAL_PROCESSING | 
      EXPAND_ALIASES | EXPAND_MIME_INCLUSIONS | FILE_IF_FCC | 
      (res.mailAgentPassAddress ? BUILD_RECEIP_ADDR : 0))) < -10);

  else if (res.mailAgentPassAddress && *receipient == CNULL) 
	SimpleMessage(scn, 
				  "Unable to determine receipient, not sending, draft left");
  
  else if ((res.mailAgentPassAddress && *(receipient = 
			BuildAddress(receipient)) == CNULL) || !Anim(scn))
	SimpleMessage(scn, "Bad address, not sending, draft left");

  else if (MuSystem(sendCmd = FmtString4("%s %s \"%s\" < %s", 
		   res.mailAgentProgram, res.mailAgentArgs, receipient, draftName = 
		   FileInMailDir(scn->draft.name))) < 0  || !Anim(scn)) {
	SimpleMessage(scn, 
       "Draft send command failed, letter may not have been sent, draft left");
	MuError(FmtString1("Command ``%s'' failed", sendCmd));
  } 

  else {
	Anim(scn);

	BackupFile(draftName);
	unlink(draftName);

	if (scn->draft.replLetN != DRAFT_NO_REPLY) 
	  MarkLetterAsRepliedTo(scn, scn->draft.replLetN);

	SimpleMessage(scn, FmtString2("%s%s", "Letter sent", (ret < 0) ? 
								  " (errors)" :	""));
#ifdef DEBUG
	MuNotice(FmtString1("(debug) send command = ``%s''\n", sendCmd));
#endif
  }

  AnimStop(scn);
  DraftMode(scn, False);
  DisplayLetterProc(scn, scn->folder.curDispLetN, LETTER_MAKE_PARTIAL);
  return 0;
}

void 
SendDraftCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SendDraftProc((SCREEN*)clientData);
}

void 
ExpandAliasesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          dummyS;

  AnimStart(scn);
  ProcessDraft(scn, &dummyS, EXPAND_ALIASES);
  EditDraft(scn);
  AnimStop(scn);
}

void 
ExpandMimeInclusionsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          dummyS;

  AnimStart(scn);
  ProcessDraft(scn, &dummyS, EXPAND_MIME_INCLUSIONS);
  EditDraft(scn);
  AnimStop(scn);
}

void
CancelDraftCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;

  if (scn->draft.active == False) return;

  DraftMode(scn, False);
  SimpleMessage(scn, FmtString1("Composition aborted, draft kept as %s", 
								scn->draft.name));
  DisplayLetterProc(scn, scn->folder.curDispLetN, LETTER_MAKE_PARTIAL);}

/*---------------------------------------------------------------------------+
| rn-style quote routine.
+---------------------------------------------------------------------------*/

void 
QuoteRnStyleCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  LETTER          *letter;
  String          lineStartPtr, lineEndPtr;
  char            c;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  AnimStart(scn);
  XawTextDisableRedisplay(scn->bodyW);
  InsertText(scn->bodyW, FmtString1(res.quoteNestedAttribFmt, letter->from)); 

  for (lineStartPtr = letter->content; 
	   (lineEndPtr = strchr(lineStartPtr, '\n')); 
	   lineStartPtr = lineEndPtr) {

	c = *(++lineEndPtr);
	*lineEndPtr = CNULL;
	InsertText(scn->bodyW, ">");
	InsertText(scn->bodyW, lineStartPtr);
	*lineEndPtr = c;
	Anim(scn);
  }
  InsertText(scn->bodyW, "\n");
  AnimStop(scn);
  XawTextEnableRedisplay(scn->bodyW);
}

/*---------------------------------------------------------------------------+
| SuperCite-style quote routines.
+---------------------------------------------------------------------------*/

Boolean
OkToQuoteLine(line)
	 String          line;
{
  String          firstSpacePtr;

  while(*line && isspace(*line)) line++;

  if (*line == CNULL || *line == '>' || 
	  ((firstSpacePtr = strchr(line, SPACE)) && 
	   *(firstSpacePtr - 1) == '>'))
	return False;

  return True;
}

void 
NonNestedCitationUnfmtProc(scn, buffer, initials, indent)
	 SCREEN          *scn;
	 String          buffer,
	                 initials;
	 String          indent;
{
  LETTER          *letter;
  String          lineStartPtr, lineEndPtr;
  char            c;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  AnimStart(scn);
  XawTextDisableRedisplay(scn->bodyW);
  InsertText(scn->bodyW, FmtString2(res.quoteNonNestedAttribFmt, initials, 
									letter->from)); 

/*  printf("BBBBBBBBBB\n%s\n", buffer);*/

  lineStartPtr = buffer;

  do {
	if ((lineEndPtr = strchr(lineStartPtr, NEWLINE)) == NULL)
	  lineEndPtr = strend(lineStartPtr);
	
	c = *lineEndPtr ? *++lineEndPtr : *lineEndPtr;
	*lineEndPtr = CNULL;
	
	if(OkToQuoteLine(lineStartPtr))
	  InsertText(scn->bodyW, FmtString2("%s%s> ", indent, initials));
	
	InsertText(scn->bodyW, lineStartPtr);
	
	*lineEndPtr = c;

	lineStartPtr = lineEndPtr;
	Anim(scn);  
  
  } while(c);

  InsertText(scn->bodyW, "\n");
  AnimStop(scn);
  XawTextEnableRedisplay(scn->bodyW);
}

void 
NonNestedCitationUnfmt(scn, initials)
	 SCREEN          *scn;
	 String          initials;
{
  Letter          *letter;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  NonNestedCitationUnfmtProc(scn, letter->content, initials, "");
}

#define MAX_PARAGRAPHS 256

void 
NonNestedCitationFmt(scn, initials)
	 SCREEN          *scn;
	 String          initials;
{
  Letter          *letter;
  char            c, c2;
  Boolean         quoteOk;
  String          parStartPtr, lineStartPtr, lineEndPtr,
                  par, buffer, bufPtr;
  int             maxWidth;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  AnimStart(scn);
  maxWidth = res.quoteFillColumn - strlen(initials) - 2;
  for (bufPtr = res.quoteIndentString; *bufPtr; bufPtr++)
	maxWidth -= *bufPtr == TAB ? 8 : 1;

  buffer = XtMalloc(strlen(letter->content)+1);
  *buffer = CNULL;

  lineStartPtr = parStartPtr = letter->content;

  do {
	if ((lineEndPtr = strchr(lineStartPtr, NEWLINE)) == NULL)
	  lineEndPtr = strend(lineStartPtr);

	c = *lineEndPtr ? *++lineEndPtr : *lineEndPtr;
	*lineEndPtr = CNULL;

	if (!(quoteOk = OkToQuoteLine(lineStartPtr)) ||
		c == NEWLINE || c == CNULL) {

	  c2 = *lineStartPtr;
	  if (!quoteOk) *lineStartPtr = CNULL;

	  if (strlen(parStartPtr) > 1) {
		par = FormatParagraph(parStartPtr, maxWidth);
		strcat(buffer, par);
		XtFree(par);
	  }		

	  *lineStartPtr = c2;
	  if (!quoteOk) strcat(buffer, lineStartPtr);

	  parStartPtr = lineEndPtr;
	}

	*lineEndPtr = c;

	lineStartPtr = lineEndPtr;
	Anim(scn);

  } while(c);
  
  /* AnimStop will be called there */
  NonNestedCitationUnfmtProc(scn, buffer, initials, res.quoteIndentString);
  XtFree(buffer);
}

void 
NonNestedCitation(scn, style)
	 SCREEN          *scn;
	 int             style;
{
  String          initials;

  ErrorIfBodyBoxNotEditable(scn,);

  SimpleMessage(scn, "Enter initials above");
  if ((initials = DialogPrompt(scn)) == NULL) return;

  if (style == CITE_UNFMT) NonNestedCitationUnfmt(scn, initials);
  else if (style == CITE_FMT) NonNestedCitationFmt(scn, initials);
}

void 
QuoteScStyleUnfmtCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  NonNestedCitation((SCREEN*)clientData, CITE_UNFMT);
}

void 
QuoteScStyleFmtCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  NonNestedCitation((SCREEN*)clientData, CITE_FMT);
}

#if 0
void 
QuoteIIICallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  LETTER          *letter;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  XawTextDisableRedisplay(scn->bodyW);
  InsertText(scn->bodyW, FmtString("\n>>> %s wrote:\n", letter->from, 
									  "", ""));
  /* Redisplay will be enabled there */
  InsertLetterBodyCallback(widget, clientData, callData);
}
#endif

void
InsertLetterBodyCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  LETTER          *letter;
  String          letterBuffer;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  XawTextDisableRedisplay(scn->bodyW);

  letterBuffer = ConstructLetter(letter, LETTER_MAKE_BODY);
  InsertText(scn->bodyW, letterBuffer);
  XtFree(letterBuffer);

  XawTextEnableRedisplay(scn->bodyW);


/*  InsertText(scn->bodyW, letter->content); 
this would suffice, but I want consistency */
}

void
InsertLetterPartialCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  LETTER          *letter;
  String          letterBuffer;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  XawTextDisableRedisplay(scn->bodyW);

  letterBuffer = ConstructLetter(letter, LETTER_MAKE_PARTIAL);
  InsertText(scn->bodyW, letterBuffer);
  XtFree(letterBuffer);

  XawTextEnableRedisplay(scn->bodyW);
}

void
InsertLetterWhole(scn)
  SCREEN *scn;
{
  LETTER          *letter;
  String          letterBuffer;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  XawTextDisableRedisplay(scn->bodyW);
  letterBuffer = ConstructLetter(letter, LETTER_MAKE_WHOLE);
  InsertText(scn->bodyW, letterBuffer);
  XtFree(letterBuffer);
}

void
InsertLetterWholeCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  InsertLetterWhole(scn);
  XawTextEnableRedisplay(scn->bodyW);
}

void 
InsertSignatureCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  InsertFile(scn->bodyW, FileInHomeDir(res.signatureFile));
}

void 
EditCustomHeadersCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  EditFileInBodyBox(scn, FileInMumailDir(HEADERS_FILE));
  EditMode(scn, True);
}

void 
  EditAliasesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  EditFileInBodyBox((SCREEN*)clientData, FileInMumailDir(ALIASES_FILE));
  EditMode(scn, True);
}

/*---------------------------------------------------------------------------+
| Old stuff.
+---------------------------------------------------------------------------*/

#if 0
void 
QuoteScStyleFmtCallback1(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  Letter          *letter;
  Boolean         noQuotePar;
  char            c;
  String          parStartPtr, lineStartPtr, lineEndPtr,
                  par[MAX_PARAGRAPHS], buffer;
  int             parN, i;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  AnimStart(scn);
  for (parN = 0, lineEndPtr = parStartPtr = letter->content; 
	   lineEndPtr && parN < MAX_PARAGRAPHS; 
	   parStartPtr = lineEndPtr, parN++) {

	for (lineStartPtr = parStartPtr; 
		 *lineStartPtr == '\n'; lineStartPtr++);
	
	for (noQuotePar = False; 
		 (lineEndPtr = strchr(lineStartPtr, '\n')) && 
		 *(lineEndPtr+1) != '\n';
		 lineStartPtr = lineEndPtr) {

	  if (noQuotePar) {++lineEndPtr; continue;}

	  c = *(++lineEndPtr);
	  *lineEndPtr = CNULL;

	  if(!OkToQuoteLine(lineStartPtr))
		noQuotePar = True;
	  
	  *lineEndPtr = c;
	  Anim(scn);
	}

	if (lineEndPtr) {
	  c = *++lineEndPtr;
	  *lineEndPtr = CNULL;
	  par[parN] = noQuotePar ? XtNewString(parStartPtr) :
		FormatParagraph(parStartPtr, MAXWIDTH - strlen(initials));
	  *lineEndPtr = c;
	}
	else
	  par[parN] =  noQuotePar ? XtNewString(parStartPtr) :
		FormatParagraph(parStartPtr, MAXWIDTH - strlen(initials));
  }
  par[parN] = NULL;

  buffer = XtMalloc(strlen(letter->content)+1);

  for (i = 0, *buffer = CNULL; i < parN; i++) {
	strcat(buffer, par[i]);
	XtFree(par[i]);
  }
  
  /* AnimStop will be called there */
  QuoteScStyleUnfmtProc1(scn, buffer, initials, INDENT);
}
#endif

#if 0

XawTextPosition
FindHeadersEnd(textW)
	 Widget          textW;
{
  return SearchForText(textW, "\n\n", 0, FindEndOfBuffer(textW), XawsdRight);
}

String
FindHeaderFieldFromTextW(textW, headerTitle)
	 Widget          textW;
	 String          headerTitle;
{
  XawTextPosition          endPos, findPos;

  if ((endPos = FindHeadersEnd(textW)) == XawTextSearchError) return NULL;
  if ((findPos = SearchForText(textW, headerTitle, 0, endPos, XawsdRight)) 
	  == XawTextSearchError) return NULL;

  return StripStringB(GetTextSource(textW, findPos + strlen(headerTitle), 
									FindEndOfLine(textW, findPos) - 1));
}

int
FileDraftIfFcc(scn)
	 SCREEN          *scn;
{
  String                   folderName[MAX_FCC],
                           draftBuf, date;
  FILE                     *folderFP;
  XawTextPosition          headersEndPos, findPos, lineEndPos;
  time_t                   curTime = time((time_t*)NULL);
  int                      len = strlen(FCC_TITLE),
                           n, i, ret = 0;

  if ((headersEndPos = FindHeadersEnd(scn->bodyW)) == XawTextSearchError) 
	return -1;

  for (findPos = 0, i = 0, folderName[i] = NULL; 
	   (findPos = SearchForText(scn->bodyW, FCC_TITLE, 0, headersEndPos,
								XawsdRight)) != XawTextSearchError; i++) {

	Anim(scn);
	folderName[i] = XtNewString(StripStringA(GetTextSource(scn->bodyW, 
					  findPos + len, (lineEndPos = FindEndOfLine(scn->bodyW, 
                      findPos)) - 1)));
	ReplaceTextByPos(scn->bodyW, findPos, lineEndPos + 1, "");

	/* Recalculate the headers end since the buffer has changed */
	if ((headersEndPos = FindHeadersEnd(scn->bodyW)) == XawTextSearchError) 
	  {ret--; break;}
  }
  folderName[n = i] = NULL;
  if (ret < 0) {FreeList(folderName); return ret;}

  draftBuf = GetTextSourceOfBodyBox(scn);
  strftime(date = FmtString0(""), 80, "%a, %d %b %y %H:%M:%S %Z", 
		   localtime(&curTime));

  for (i = 0; i < n; i++) {

	Anim(scn);
	if (FileIsPacked(folderName[i])) {
	  Message(scn, FmtString1("Cannot append to compressed folder (%s)", 
							  folderName[i]), MSG_CLEAR_DEFAULT);
	  MuError(FmtString1("Cannot append to compressed folder (%s)",
						 folderName[i]));
	  ret--;
	  continue;
	}

	if ((folderFP = fopen(FileInMailDir(folderName[i]), "a")) == NULL) {
	  Message(scn, FmtString2("Could not open folder %s: %s", folderName[i], 
							  strerror(errno)), MSG_CLEAR_DEFAULT);
	  MuPError(FmtString1("Could not open file `%s'", 
						  FileInMailDir(folderName[i])));
	  ret--;
	  continue;
	}
	
	fprintf(folderFP, "From mailer-mumail %s\n%s %s\n%s\n\n", 
			CurrentLocalTimeString(), DATE_TITLE, date, draftBuf);
	
	fclose(folderFP);
	XtFree(folderName[i]);
  }

  return ret;
}

int
SubstitueAlias(alias, address)
	 String          alias,
                     *address;
{
  static struct {
	String          alias;
	String          address;
  } aliasRec[MAX_ALIASES];

  struct stat     statInfo;
  static time_t   timeLastRead;
  static String   aliasBuf;
  String          aliasFile, 
                  lineStartPtr, lineEndPtr, sepPtr;
  int             i;

  /* So that the returned address is always valid */
  *address = alias;
  if (alias == NULL) return -1;

  /* Couldn't stat -> file possibly doesn't exist. No need to bother
	 with checking errno, the file seems problematic anyway */
  if (stat(aliasFile = FileInMumailDir(ALIASES_FILE), &statInfo) < 0)
	return 0;

  if (aliasRec[0].alias == NULL || statInfo.st_mtime > timeLastRead) {

	if (aliasBuf) XtFree(aliasBuf);
	if ((aliasBuf = CopyFileToBuffer(aliasFile)) == NULL) return -1;

	timeLastRead = time((int*)0);
	aliasBuf = CleanSimpleCommentedBuffer(aliasBuf);

	for (i = 0, lineStartPtr = lineEndPtr = aliasBuf; 
		 lineEndPtr && (sepPtr = strchr(lineStartPtr, '='));
		 lineStartPtr = lineEndPtr+1, i++) {

	  if ((lineEndPtr = strchr(sepPtr, NEWLINE))) *lineEndPtr = CNULL;
	  *sepPtr = CNULL;

	  aliasRec[i].alias = StripStringA(lineStartPtr);
	  aliasRec[i].address = StripStringA(++sepPtr);

	}
	aliasRec[i].alias = (String)NULL;
  }

  *address = alias;
  for (i = 0; aliasRec[i].alias; i++)
	if (strcmp(StripStringA(alias), aliasRec[i].alias) == 0) {
	  *address = aliasRec[i].address;
	  break;
	}

  return 0;
}

int
SubstitueAliasInTextW(textW)
	 Widget          textW;
{
  XawTextPosition          headersEndPos, findPos, lineEndPos;
  String                   alias, address;

  if ((headersEndPos = FindHeadersEnd(textW)) == XawTextSearchError) return -1;
  if ((findPos = SearchForText(textW, TO_TITLE, 0, headersEndPos, XawsdRight)) 
	  == XawTextSearchError) return -1;

  alias = StripStringB(GetTextSource(textW, findPos + strlen(TO_TITLE), 
						   (lineEndPos = FindEndOfLine(textW, findPos)) - 1));

  if (SubstitueAlias(alias, &address) < 0) return -1;
  if (ReplaceTextByPos(textW, findPos + strlen(TO_TITLE), lineEndPos, 
					   FmtString1(" %s", address)) == XawEditError) return -1;
  return 0;
}
#endif
