/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include "MmDecl.h"

void
GotoEditCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  EditFileInBodyBox(scn, scn->edit.fileName);
  SimpleMessage(scn, "Back to file being edited (changes not saved are lost)");
}

void
EditSaveCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  if (XawAsciiSaveAsFile(XawTextGetSource(scn->bodyW), scn->edit.fileName))
	SimpleMessage(scn, "File saved successfully");
  else
	SimpleMessage(scn, "Could not save file, file not saved");
}

void
EditCancelCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;

  Message(scn, "Editing ended", MSG_CLEAR_DEFAULT);
  EditMode(scn, False);
  DisplayLetterProc(scn, scn->folder.curDispLetN, LETTER_MAKE_PARTIAL);
}

void
EditCutCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "kill-selection");
}

void
EditCutEolCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "kill-to-end-of-line");
}

void
EditPasteCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  static String   arg[] = {"CUT_BUFFER1"};
  CallAction(scn->bodyW, "insert-selection", arg, 1);
}

void
EditSearchCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  static String arg[] = {"forward"};
  CallAction(scn->bodyW, "search", arg, 1);
}

void
EditInsertFileCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "insert-file");
}

void
EditFormatCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "form-paragraph");
}

void
EditRedrawCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "redraw-display");
}

