/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <string.h>

#include "MmDecl.h"
#include "MuGeneric.h"

#ifndef HELPFILE
#define HELPFILE "/usr/lib/X11/mumail.help"
#endif

#define HELP_DELIMITER ""

void
DisplayHelpText(scn, topicName)
	 SCREEN          *scn;
	 String          topicName;
{
  static String          wholeBuffer;
  String                 bufferStart;

  if (wholeBuffer == NULL) wholeBuffer = CopyFileToBuffer(HELPFILE);

  if ((bufferStart = Strstr(wholeBuffer, FmtString2("%s\n%s", HELP_DELIMITER, 
													topicName))))
	bufferStart += strlen(HELP_DELIMITER);
  else bufferStart = wholeBuffer;

  DisplayBufferInBodyBox(scn, bufferStart);
}

void
HelpAllCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "ALL");
}

void
HelpOverviewCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "NAME");
}

void
HelpResourcesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "RESOURCES");
}

void
HelpOptionsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "OPTIONS");
}

void
HelpMailAgentsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "MAIL DELIVERY AGENTS");
}

void
HelpAliasesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "ALIASES");
}

void
HelpMimeCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "MIME SUPPORT");
}

void
HelpMenusCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "MENUS");
}

void
HelpBindingsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "MOUSE AND KEY BINDINGS");
}

void
HelpFilesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "FILES");
}

void
HelpBugsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "BUGS");
}

void
HelpCopyrightCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "COPYRIGHT");
}

void
HelpAuthorCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "AUTHOR");
}

void
HelpAckCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "ACKNOWLEDGEMENT");
}

void
HelpNewsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "NEWS/CHANGES");
}
