/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmMain.c --- Main module
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Mon Jun 21 02:01:02 1993
 * Update Count    : 27
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#if USE_3D_FRAME
#include "Xfwf/Frame.h"
#endif

#include "MmDecl.h"
#include "MuWin.h"
#include "MuGeneric.h"
#define IS_MAIN
#include "version.h"

extern void
                HighlightToEndOFLineAction(),

                BodyBoxNextPageAction(),
                BodyBoxPrevPageAction(),
                BodyBoxNextLineAction(),
                BodyBoxEndOfPageAction(),
               
                CloseWindowAction(),
                IconifyWindowAction(),
                HighlightCurrentLineAction(),

                OpenFolderAction(),
                SaveFolderAction(),
                CommitChangesAction(),
                FolderInfoAction(),
                QuickExitAction(),
                ExitAction(),

                DisplayLetterGeneralAction(),
                RedisplayCurLetterPartialAction(),
                RedisplayCurLetterWholeAction(),

                TagUntagLetterAction(),
                RetagLettersAction(),
                DeleteLetterAction(),
                UndeleteLetterAction(),
                ComposeLetterAction(),
                ReplyToLetterAction(),
                ForwardLetterAction(),
                ExternalComposeLetterAction(),
                CopyLetterAction(),
                RefileLetterAction(),
                LetterInfoAction(),

                SendDraftAction(),
                CancelDraftAction(),
                QuoteScStyleFmtAction(),
                QuoteScStyleUnfmtAction(),
                QuoteRnStyleAction(),
                InsertSignatureAction(),

                MenuButtonPopdownMenuAction(),
                PopupMenuIfMenuButtonAction();

void
                GetResources();

QueryResources res;

void
main(argc, argv)
     int             argc;
     char           *argv[];
{
  XtAppContext    appContext;  
  Widget          topLevel;
  SCREEN          *firstScn;

  static char    *fallbackResources[] = {
#include "Mumail.ad.h"
    NULL,
  };

  static XrmOptionDescRec optionList[] =  {
    {"-modems", "modems", XrmoptionSepArg, NULL},
    {"-script", "script", XrmoptionSepArg, NULL},
    {"-entries", "defaultPhoneEntries", XrmoptionSepArg, NULL},
    {"-dial", "dialAutoStart", XrmoptionNoArg, "True"},
    {"-nodial", "dialAutoStart", XrmoptionNoArg, "False"},
    {"-emulator", "emulator", XrmoptionSepArg, ""},
    {"-noemulator", "noemulator", XrmoptionNoArg, ""},
    {"-nodefargs", "nodefargs", XrmoptionNoArg, ""},
  };

  static XtActionsRec actionTable[] = {
    {"ClearCutBuffer", ClearCutBufferAction},
    {"HighlightToEndOFLine", HighlightToEndOFLineAction},
    {"IncCurLetterNumber", IncCurLetterNumberAction},
    {"DecrCurLetterNumber", DecrCurLetterNumberAction},

    {"BodyBoxNextPage", BodyBoxNextPageAction},
    {"BodyBoxPrevPage", BodyBoxPrevPageAction},
    {"BodyBoxNextLine", BodyBoxNextLineAction},
    {"BodyBoxEndOfPage", BodyBoxEndOfPageAction},

    {"CloseWindow", CloseWindowAction},
    {"IconifyWindow", IconifyWindowAction},
    {"HighlightCurrentLine", HighlightCurrentLineAction},

    {"OpenFolder", OpenFolderAction},
    {"SaveFolder", SaveFolderAction},
    {"CommitChanges", CommitChangesAction},
    {"FolderInfo", FolderInfoAction},
    {"QuickExit", QuickExitAction},
    {"Exit", ExitAction},

    {"SetCurLetterNumber", SetCurLetterNumberAction},
    {"DisplayLetterGeneral", DisplayLetterGeneralAction},
    {"RedisplayCurLetterPartial", RedisplayCurLetterPartialAction},
    {"RedisplayCurLetterWhole", RedisplayCurLetterWholeAction},

    {"TagUntagLetter", TagUntagLetterAction},
    {"RetagLetters", RetagLettersAction},
    {"DeleteLetter", DeleteLetterAction},
    {"UndeleteLetter", UndeleteLetterAction},
    {"ComposeLetter", ComposeLetterAction},
    {"ReplyToLetter", ReplyToLetterAction},
    {"ForwardLetter", ForwardLetterAction},
    {"ExternalComposeLetter", ExternalComposeLetterAction},
    {"CopyLetter", CopyLetterAction},
    {"RefileLetter", RefileLetterAction},
    {"LetterInfo", LetterInfoAction},

    {"SendDraft", SendDraftAction},
    {"CancelDraft", CancelDraftAction},
    {"QuoteScStyleFmt", QuoteScStyleFmtAction},
    {"QuoteScStyleUnfmt", QuoteScStyleUnfmtAction},
    {"QuoteRnStyle", QuoteRnStyleAction},
    {"InsertSignature", InsertSignatureAction},

    {"MenuButtonPopdownMenu", MenuButtonPopdownMenuAction},
    {"PopupMenuIfMenuButton", PopupMenuIfMenuButtonAction},
  };

  topLevel = XtAppInitialize(&appContext, "Mumail", optionList,
							 XtNumber(optionList), &argc, argv,
							 fallbackResources, NULL, 0);
  if (argc > 1)
	{MuError(FmtString1("Wrong argument: %s", argv[1])); exit(1);}
  MuNotice(FmtString2("Mumail %s.%s is initializing..", VERSION, REVISION));  

  XtAppAddActions(appContext, actionTable, XtNumber(actionTable));
  XtOverrideTranslations(topLevel,
		       XtParseTranslationTable("<Message>WM_PROTOCOLS: QuickExit()"));

  GetResources(topLevel);

  firstScn = AddScreen(topLevel, FileInMailDir(INFOLDER_NAME));
  XtAppMainLoop(appContext);
}

Widget
CreateTocW(parentW)
	 Widget parentW;
{
  Widget          frameW, widget;
  static          XawTextSelectType selectTypes[] = {XawselectLine,
													   XawselectNull};
  
#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("tocFrame", xfwfFrameWidgetClass,
									parentW, NULL); 
#else
  frameW = parentW;
#endif

  widget = AddAsciiText("tocW", frameW);
  XtVaSetValues(widget, XtNselectTypes, selectTypes, NULL);
  return widget;
}

Widget
CreateBodyW(parentW)
	 Widget parentW;
{
  Widget          widget, frameW;
  Widget          textSinkW;
  XFontStruct    *font;
  Dimension       width;

#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("bodyFrame", xfwfFrameWidgetClass,
									parentW, NULL); 
#else
  frameW = parentW;
#endif

  widget = AddAsciiText("bodyW", frameW);

  XtVaGetValues(widget, XtNfont, &font, XtNtextSink, 
				&textSinkW,	NULL);
  width = font->max_bounds.rbearing + font->min_bounds.lbearing;
  XtVaSetValues(widget, XtNwidth, 81 * width, NULL);
  XtVaSetValues(widget, XtNrightMargin, 10 * width, NULL); 
  return widget;

/*  XtVaSetValues(widget, XtNwidth, 81 * width, XtNleftMargin, 
				width, XtNrightMargin, 10 * width, NULL); 

  XtVaSetValues(textSinkW, XtNwidth, (Dimension)486, 
				XtNleftMargin, 
				(Dimension) 6 , XtNrightMargin,  (Dimension) 60,
				NULL); 
  printf("-%d-\n", (int)width);*/
}

void
CreateDialogW(scn, parentW)
	 SCREEN          *scn;
	 Widget          parentW;
{
  Widget          dialogW, frameW;

#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("dialogFrame", xfwfFrameWidgetClass,
									parentW, NULL); 
#else
  frameW = parentW;
#endif

  dialogW = AddPaned("dialogW", frameW);

  scn->dialog.yesW = AddButton("yesW", dialogW, NULL, NULL);
  scn->dialog.cancelW = AddButton("cancelW", dialogW, NULL, NULL);
  scn->dialog.valueW = AddAsciiText("valueW", dialogW);

  XtVaSetValues(scn->dialog.yesW, XtNmappedWhenManaged, False, NULL);
  XtVaSetValues(scn->dialog.cancelW, XtNmappedWhenManaged, False, NULL);

  scn->dialog.mode = DIALOG_INACTIVE;
}

void
SetIcon(parentW)
     Widget          parentW;
{
#include "Mumail.icon.h"

  Pixmap icon;

  icon = 
	XCreateBitmapFromData(XtDisplay(parentW),
						  DefaultRootWindow(XtDisplay(parentW)),
						  icon_bits, icon_width, icon_height);
  XtVaSetValues(GetShell(parentW), XtNiconPixmap, icon, NULL);
}

void
DisplayLogo(scn)
	 SCREEN   *scn;
{
#include "Mumail.logo.h"

  char        versionInfo[BUF256];
  String      logoBuffer; 

  sprintf(versionInfo, "%5sVersion %s rev. %s %s-%s %s@%s %s %s\n\n\n%12s%s", 
		  "", VERSION, REVISION, COMPILE_HOSTTYPE, COMPILE_OSNAME, 
		  COMPILE_BY, COMPILE_HOST, COMPILE_DATE, COMPILE_TIME, "",
		  "Comments, suggestions, and bug fixes are welcome");
  
  logoBuffer = XtMalloc(strlen(logo)+strlen(versionInfo));
  sprintf(logoBuffer, "%s%s", logo, versionInfo);

  DisplayBufferInBodyBox(scn, logoBuffer);
  XtFree(logoBuffer);
}

void
DisplayLogoCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  DisplayLogo((SCREEN*)clientData);
}

String
XMailerMessage()
{
  /* Instead of allocating new space */
  String buffer = FmtString0(""); 

  sprintf(buffer, "X-Mailer: Mumail [version %s.%s %s-%s]", 
		  VERSION, REVISION, COMPILE_HOSTTYPE, COMPILE_OSNAME);
  return buffer;
}


/*---------------------------------------------------------------------------+
| GetResources - gets the application resources.
+---------------------------------------------------------------------------*/

void
GetResources(topLevel)
	 Widget          topLevel;
{
  String          tmpPtr;

#define offset(field) XtOffsetOf(QueryResources, field)
  static XtResource resources[] = {
    {"printCommand", "printCommand", XtRString, sizeof(String),
	   offset(printCommand), XtRString, (XtPointer)"lpr"},
    {"externalEditor", "ExternalEditor", XtRString, sizeof(String),
	   offset(externalEditor), XtRString, (XtPointer)"emacs"},
	
	{"signatureFile", "SignatureFile", XtRString, sizeof(String),
	   offset(signatureFile), XtRString, (XtPointer)".signature"},
  },

  mailAgentResources[] = {
    {"passAddress", "PassAddress", XtRBoolean, sizeof(Boolean), 
	   offset(mailAgentPassAddress), XtRImmediate, (XtPointer)False},
    {"program", "Program", XtRString, sizeof(String),
	   offset(mailAgentProgram), XtRString, (XtPointer)"/usr/lib/sendmail"},
    {"arguments", "Arguments", XtRString, sizeof(String),
	   offset(mailAgentArgs), XtRString, (XtPointer)"-bm -oi -oem -t"},
  },

  citeResources[] = {
    {"fillColumn", "FillColumn", XtRInt, sizeof(int),
	   offset(quoteFillColumn), XtRImmediate, (XtPointer)70},
    {"indentString", "IndentString", XtRString, sizeof(String),
	   offset(quoteIndentString), XtRString, (XtPointer)"\t"},
    {"nestedAttribFmt", "NestedAttribFmt", XtRString, sizeof(String),
	   offset(quoteNestedAttribFmt), XtRString, 
	   (XtPointer)"\n>>>>> %s wrote:\n>\n"},
    {"nonNestedAttribFmt", "NonNestedAttribFmt", XtRString, 
	   sizeof(String), offset(quoteNonNestedAttribFmt), XtRString, 
	   (XtPointer)"\n>>>>> %s == %s wrote:\n\n"},
  },

  mimeResources[] = {
    {"agentCommand", "AgentCommand", XtRString, sizeof(String), 
	   offset(mimeCommand), XtRString, 
	   (XtPointer)"metamail -d -r -x -m Mumail"},
    {"invokeAgent", "InvokeAgent", XtRString, sizeof(String),
	   offset(invokeMimeS), XtRString, (XtPointer)"ask"},
    {"addHeaders", "AddHeaders", XtRBoolean, sizeof(Boolean),
	   offset(addMimeHeaders), XtRImmediate, (XtPointer)True},
    {"defaultContentType", "DefaultContentType", XtRString, sizeof(String),
	   offset(defaultContentType), XtRString, (XtPointer)"text/plain"},
    {"defaultCharSet", "DefaultCharSet", XtRString, sizeof(String),
	   offset(defaultCharSet), XtRString, (XtPointer)"US-ASCII"},
    {"defaultTransferEncoding", "DefaultTransferEncoding", XtRString, 
	   sizeof(String), offset(defaultTransferEncoding), XtRString, 
	   (XtPointer)"7BIT"},
    {"multipartBoundary", "MultipartBoundary", XtRString, sizeof(String),
	   offset(mimeBoundary), XtRString, (XtPointer)"####"},
  };
#undef offset

  XtGetApplicationResources(topLevel, (XtPointer)&res, resources,
							XtNumber(resources), NULL, 0);

  XtGetSubresources(topLevel, (XtPointer)&res, "mailAgent", "MailAgent", 
					mailAgentResources, XtNumber(mailAgentResources), NULL, 0);
  XtGetSubresources(topLevel, (XtPointer)&res, "cite", "Cite", 
					citeResources, XtNumber(citeResources), NULL, 0);
  XtGetSubresources(topLevel, (XtPointer)&res, "mime", "Mime", 
					mimeResources, XtNumber(mimeResources), NULL, 0);

  tmpPtr = StripStringB(res.invokeMimeS); 

  if (CaseNStrSame(tmpPtr, "never", 5)) 
	res.invokeMime = MIME_INVOKE_NEVER;
  else if (CaseNStrSame(tmpPtr, "always", 6)) 
	res.invokeMime = MIME_INVOKE_ALWAYS;
  else res.invokeMime = MIME_INVOKE_ASK;
}
