/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#if USE_3D_FRAME
#include "Xfwf/Frame.h"
#endif

#include "MuWin.h"
#include "MmDecl.h"


extern void
         DisplayLogoCallback();

Widget 
AddFramedMenuButton(name, parentW)
	 String          name;
	 Widget           parentW;
{
  Widget          frameW;

#if 0 /*USE_3D_FRAME*/
  frameW = XtVaCreateManagedWidget("menuButtonFrame", xfwfFrameWidgetClass,
								   parentW, NULL);
#else
  frameW = parentW;
#endif

  return AddMenuButton(name, frameW);
}

void
CreateMainMenu(scn, parentW)
	 SCREEN          *scn;
	 Widget          parentW;
{
  Widget          frameW, menuBox,
                  button, menu;

#if 0 /*USE_3D_FRAME*/
  frameW = 	XtVaCreateManagedWidget("mainMenuFrame", xfwfFrameWidgetClass,
									parentW, NULL); 
#else
  frameW = parentW;
#endif

  menuBox = AddBox("mainMenu", frameW);

  /* Window Button */

  button = AddFramedMenuButton("windowButton", menuBox);
  menu = AddSimpleMenu("windowMenu", button);
  AddMenuEntry("new", menu, NewWindowCallback, (XtPointer)scn);
  AddMenuEntry("close", menu, CloseWindowCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("iconify", menu, IconifyWindowCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("exit", menu, ExitCallback, (XtPointer)scn);
  AddMenuEntry("quickExit", menu, QuickExitCallback, (XtPointer)scn);

  /* Folder Button */

  button = AddFramedMenuButton("folderButton", menuBox);
  menu = AddSimpleMenu("folderMenu", button);
  AddMenuEntry("checkMailbox", menu, CheckMailBoxCallback, (XtPointer)scn);
  AddMenuEntry("getNew", menu, IncorporateNewMailCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("open", menu, OpenFolderCallback, (XtPointer)scn); 
  AddMenuEntry("reopen", menu, ReOpenFolderCallback, (XtPointer)scn);
  AddMenuEntry("openInNextScn", menu, OpenFolderInNextScreenCallback, 
			   (XtPointer)scn);
/*  AddMenuEntry("new", menu, RedisplayTocCallback, (XtPointer)scn);*/

  AddMenuLine("line", menu);
  AddMenuEntry("save", menu, SaveFolderCallback, (XtPointer)scn);
  AddMenuEntry("saveAs", menu, SaveFolderAsCallback, (XtPointer)scn);
  AddMenuEntry("saveCompressed", menu, SaveFolderAsCompressedCallback, 
			   (XtPointer)scn);
  AddMenuEntry("saveGZipped", menu, SaveFolderAsGZippedCallback, 
			   (XtPointer)scn);
  AddMenuEntry("saveUnpacked", menu, SaveFolderAsUnpackedCallback, 
			   (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("edit", menu, EditFolderCallback, (XtPointer)scn);
  AddMenuEntry("delete", menu, DeleteFolderCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("commit", menu, CommitChangesCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("sort", menu, SortFolderCallback, (XtPointer)scn);
  AddMenuEntry("search", menu, SearchFolderCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("info", menu, FolderInfoCallback, (XtPointer)scn);
  AddMenuEntry("remake", menu, RedisplayTocCallback, (XtPointer)scn);
  AddMenuEntry("redraw", menu, ReDrawTocCallback, (XtPointer)scn);

/*---------------------------------------------------------------------------+
| Letter menu.
+---------------------------------------------------------------------------*/

  button = AddFramedMenuButton("letterButton1", menuBox);
  menu = AddSimpleMenu("letterMenu1", button);

  AddMenuEntry("displayPartial", menu, DisplayCurLetterPartialCallback, 
			   (XtPointer)scn);
  AddMenuEntry("displayWhole", menu, DisplayCurLetterWholeCallback, 
			   (XtPointer)scn);
  AddMenuEntry("displayPartialInNextScn", menu, 
			   DisplayLetterPartialInNextScreenCallback, (XtPointer)scn);
  AddMenuEntry("pipeToMime", menu, PipeLetterToMimeCommandCallback, 
			   (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("compose", menu, ComposeLetterCallback, (XtPointer)scn);
  AddMenuEntry("reply", menu, ReplyToLetterCallback, (XtPointer)scn);
  AddMenuEntry("forward", menu, ForwardLetterCallback, (XtPointer)scn);
  AddMenuEntry("followup", menu, FollowUpToLetterCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("quoteScFmtReply", menu, QuoteScStyleFmtAndReplyCallback, 
			   (XtPointer)scn);
  AddMenuEntry("quoteScUnfmtReply", menu, QuoteScStyleUnfmtAndReplyCallback, 
			   (XtPointer)scn);
  AddMenuEntry("quoteRnReply", menu, QuoteRnStyleAndReplyToLetterCallback, 
			   (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("composeExt", menu, ExternalComposeLetterCallback, 
			   (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("info", menu, LetterInfoCallback, (XtPointer)scn);

  button = AddFramedMenuButton("letterButton2", menuBox);
  menu = AddSimpleMenu("letterMenu2", button);

  AddMenuEntry("tag", menu, TagUntagLetterCallback, (XtPointer)scn);
  AddMenuEntry("tagAll", menu, TagAllLettersCallback, (XtPointer)scn);
  AddMenuEntry("tagRange", menu, TagRangeOfLettersCallback, (XtPointer)scn);
  AddMenuEntry("untagAll", menu, UntagAllLettersCallback, (XtPointer)scn);
  AddMenuEntry("retag", menu, RetagLettersCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("delete", menu, DeleteLetterCallback, (XtPointer)scn);
  AddMenuEntry("undelete", menu, UndeleteLetterCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("copy", menu, CopyLetterCallback, (XtPointer)scn);
  AddMenuEntry("refile", menu, RefileLetterCallback, (XtPointer)scn);
  AddMenuEntry("pipe", menu, PipeLetterCallback, (XtPointer)scn);
  AddMenuEntry("print", menu, PrintLetterCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("digestDefacto", menu, BurstDefactoDigestCallback, 
			   (XtPointer)scn);
  AddMenuEntry("digestGrotty", menu, BurstGrottyDigestCallback, 
			   (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("search", menu, EditSearchCallback, (XtPointer)scn);

/*---------------------------------------------------------------------------+
| Draft menu.
+---------------------------------------------------------------------------*/

  button = scn->draft.buttonW = AddFramedMenuButton("draftButton", menuBox);
  menu = AddSimpleMenu("draftMenu", button);

  AddMenuEntry("send", menu, SendDraftCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("expandAliases", menu, ExpandAliasesCallback, (XtPointer)scn);
  AddMenuEntry("expMimeInc", menu, ExpandMimeInclusionsCallback, 
			   (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("quoteScFmt", menu, QuoteScStyleFmtCallback, (XtPointer)scn);
  AddMenuEntry("quoteScUnfmt", menu, QuoteScStyleUnfmtCallback, 
			   (XtPointer)scn);
  AddMenuEntry("quoteRn", menu, QuoteRnStyleCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("signature", menu, InsertSignatureCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("body", menu, InsertLetterBodyCallback, (XtPointer)scn);
  AddMenuEntry("partial", menu, InsertLetterPartialCallback, (XtPointer)scn);
  AddMenuEntry("whole", menu, InsertLetterWholeCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("cancel", menu, CancelDraftCallback, (XtPointer)scn);

  /* Edit Button */

  button = scn->edit.buttonW = 
	AddFramedMenuButton("editButton", menuBox);
  menu = AddSimpleMenu("editMenu", button);
  AddMenuEntry("goto", menu, GotoEditCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  scn->edit.saveW = 
	AddMenuEntry("save", menu, EditSaveCallback, (XtPointer)scn);
  scn->edit.cancelW = 
	AddMenuEntry("cancel", menu, EditCancelCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("cut", menu, EditCutCallback, (XtPointer)scn);
  AddMenuEntry("cutEol", menu, EditCutEolCallback, (XtPointer)scn);
  AddMenuEntry("paste", menu, EditPasteCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("search", menu, EditSearchCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("insert", menu, EditInsertFileCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("format", menu, EditFormatCallback, (XtPointer)scn);
  AddMenuEntry("redraw", menu, EditRedrawCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("editExt", menu, ExternalEditFileOfBodyBoxCallback, 
			   (XtPointer)scn);

  DraftMode(scn, False);

/*---------------------------------------------------------------------------+
| Misc menu.
+---------------------------------------------------------------------------*/

  button = AddFramedMenuButton("miscButton", menuBox);
  menu = AddSimpleMenu("miscMenu", button);
  AddMenuEntry("editHeaders", menu, EditCustomHeadersCallback, (XtPointer)scn);
  AddMenuEntry("editAliases", menu, EditAliasesCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("viewFile", menu, ViewAnyFileCallback, (XtPointer)scn);
  AddMenuEntry("editFile", menu, EditAnyFileCallback, (XtPointer)scn);

/*---------------------------------------------------------------------------+
| Help menu.
+---------------------------------------------------------------------------*/

  button = AddFramedMenuButton("helpButton", menuBox);
  menu = AddSimpleMenu("helpMenu", button);

  AddMenuEntry("about", menu, DisplayLogoCallback, (XtPointer)scn);
  AddMenuEntry("all", menu, HelpAllCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("overview", menu, HelpOverviewCallback, (XtPointer)scn);
  AddMenuEntry("options", menu, HelpOptionsCallback, (XtPointer)scn);
  AddMenuEntry("resources", menu, HelpResourcesCallback, (XtPointer)scn);
  AddMenuEntry("mailAgents", menu, HelpMailAgentsCallback, (XtPointer)scn);
  AddMenuEntry("aliases", menu, HelpAliasesCallback, (XtPointer)scn);
  AddMenuEntry("mime", menu, HelpMimeCallback, (XtPointer)scn);
  AddMenuEntry("menus", menu, HelpMenusCallback, (XtPointer)scn);
  AddMenuEntry("bindings", menu, HelpBindingsCallback, (XtPointer)scn);
  AddMenuEntry("files", menu, HelpFilesCallback, (XtPointer)scn);
  AddMenuEntry("bugs", menu, HelpBugsCallback, (XtPointer)scn);
  AddMenuEntry("copyright", menu, HelpCopyrightCallback, (XtPointer)scn);
  AddMenuEntry("author", menu, HelpAuthorCallback, (XtPointer)scn);
  AddMenuEntry("ack", menu, HelpAckCallback, (XtPointer)scn);

  AddMenuLine("line", menu);
  AddMenuEntry("news", menu, HelpNewsCallback, (XtPointer)scn);
}

void 
NotImplementedCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  Message(scn, "This feature in not yet imlemented", MSG_CLEAR_DEFAULT);
}
