/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmMisc.c --- Misc. routines
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Sun Jun 20 16:56:49 1993
 * Update Count    : 42
 * Status          : Mostly OK, needs some cleaning up
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Xaw/AsciiText.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include "MuWin.h"
#include "MuGeneric.h"
#include "MmDecl.h"

#define DIALOG_END_CHAR ('\200')

typedef struct {
  SCREEN          *scn;
  XtCallbackProc  callBack;
  XtPointer       clientData;
  String          dialogString;
} _dialogRec;


void
MuXFlush(display)
	 Display          *display;
{
  XEvent          event;

/*  int             type;
  
  XSync(display, False);
  while (XPending(display)) {
	XNextEvent(display, &event);
	if ((type = event.type) == Expose || type == GraphicsExpose ||
		type == VisibilityNotify || type == ConfigureNotify ||
		type == ConfigureRequest || type == PropertyNotify ||
		type == ClientMessage)
	  XtDispatchEvent(&event);
  }  XEvent          event;
*/

  long            eventMask;
  
  eventMask = ExposureMask | VisibilityChangeMask | PropertyChangeMask;

  XSync(display, False);
  while (XCheckMaskEvent(display, eventMask, &event))
    XtDispatchEvent(&event);
}

#if 0
void
MuXFlush(widget)
	 Widget          widget;
{
  XtAppContext          appCon = XtWidgetToApplicationContext(widget);
  XSync(XtDisplay(widget), False);
  while (XtAppPending(appCon)) XtAppProcessEvent(appCon, XtIMAll);
}
#endif

/*---------------------------------------------------------------------------+
| Message routines.
+---------------------------------------------------------------------------*/

void
ClearMessageTimerCallback(clientData, timerId)
	 XtPointer             clientData;
	 XtIntervalId          *timerId;
{
  SCREEN          *scn = (SCREEN*)clientData;
  XtVaSetValues(scn->labelW, XtNlabel, "", NULL);
  MuXFlush(XtDisplay(scn->parentW));
}

void
Message(scn, msg, persistenceTime)
	 SCREEN   *scn;
	 String    msg;
	 int       persistenceTime;
{
  static XtIntervalId timerId[MAX_SCREENS];

  XtVaSetValues(scn->labelW, XtNlabel, msg, NULL);
  MuXFlush(XtDisplay(scn->parentW));

  if (timerId[scn->number]) XtRemoveTimeOut(timerId[scn->number]);
  if (persistenceTime) timerId[scn->number] = 
	XtAppAddTimeOut(XtWidgetToApplicationContext(scn->parentW),
					persistenceTime*1000, ClearMessageTimerCallback, 
					(XtPointer)scn);
}

void
MessagePError(scn, msg)
	 SCREEN   *scn;
	 String    msg;
{
  MuPError(msg);
  Message(scn, FmtString("%s: %s", msg, strerror(errno)), MSG_CLEAR_NEVER);
}

/*---------------------------------------------------------------------------+
| BusyPointer routines.
+---------------------------------------------------------------------------*/

int
BusyPointer(scn, flag)
	 SCREEN          *scn;
	 int             flag;
{
#ifndef XtNcursor
#define XtNcursor "cursor"
#endif

#define NUM_CURSORS 4

#include "Mumail.cursors.h"

  /* Same unbusy cursors for all screens (static origCursor) */

  static Cursor          busyCursor[10],
                         origCursor[10];
  static int             curCursor;
  XColor                 fg, bg;
  Pixmap                 sourcePix, maskPix;

  Display                *display = XtDisplay(scn->parentW);
  SCREEN                 *curScn;
  Widget                 widget[10];
  int                    n;

  /*-----*/

#define MakeCursor(n,sourceBits,maskBits,width,height) {\
  sourcePix = XCreateBitmapFromData(display, DefaultRootWindow(display),\
									sourceBits, width, height);\
  maskPix = XCreateBitmapFromData(display, DefaultRootWindow(display),\
								  maskBits, width, height);\
  busyCursor[n] = XCreatePixmapCursor(display, sourcePix, maskPix, &fg, &bg,\
									  7, 7);\
  XFreePixmap(display, sourcePix); XFreePixmap(display, maskPix);}

  if (busyCursor[0] == (Cursor)NULL) {
	fg.red = fg.green = fg.blue = 0;
	bg.red = bg.green = bg.blue = 0xffff;
	
	n = 0;
	MakeCursor(n++, c1_bits, cm_bits, c1_width, c1_height);
	MakeCursor(n++, c2_bits, cm_bits, c2_width, c2_height);
	MakeCursor(n++, c3_bits, cm_bits, c3_width, c3_height);
	MakeCursor(n++, c4_bits, cm_bits, c4_width, c4_height);
/*	MakeCursor(n++, c5_bits, cm_bits, c5_width, c5_height);
	MakeCursor(n++, c6_bits, cm_bits, c6_width, c6_height);
	MakeCursor(n++, c7_bits, cm_bits, c7_width, c7_height);
	MakeCursor(n++, c8_bits, cm_bits, c8_width, c8_height);
*/  }
#undef MakeCursor()

  /*-----*/

  if (flag == CLEAR_BUSY_POINTER && origCursor[0] == (Cursor)NULL) return -1;
  if (flag == ANIMATE_BUSY_POINTER) curCursor = (curCursor+1) % NUM_CURSORS;

  for (curScn = FirstScreen(scn); curScn;
	   curScn = NextScreen(curScn)) {

	n = 0;
	widget[n++] = curScn->panedW;
	widget[n++] = curScn->toc.tocW;
	widget[n++] = curScn->bodyW;
	widget[n++] = curScn->dialog.valueW;
	widget[n++] = (Widget)NULL;
	
	if (origCursor[0] == (Cursor)NULL) for (n = 0; widget[n]; n++)
	  XtVaGetValues(widget[n], XtNcursor, &origCursor[n], NULL);
	
	if (flag == ANIMATE_BUSY_POINTER) for (n = 0; widget[n]; n++) 
	  XDefineCursor(display, XtWindow(widget[n]), busyCursor[curCursor]);
	
	else if (flag == CLEAR_BUSY_POINTER) for (n = 0; widget[n]; n++)
	  XDefineCursor(display, XtWindow(widget[n]), origCursor[n]);
  }	
  
  MuXFlush(XtDisplay(scn->parentW));
  return 0;
}

void
AnimatePointer(scn, start)
	 SCREEN          *scn;
	 Boolean         start;
{
  if (start || ElapsedMTimeGreater(100))
	BusyPointer(scn, ANIMATE_BUSY_POINTER);
}

void
AnimStart(scn)
	 SCREEN          *scn;
{
  AnimatePointer(scn, True);
}

void
AnimStop(scn)
	 SCREEN          *scn;
{
  BusyPointer(scn, CLEAR_BUSY_POINTER);
}

int
Anim(scn)
	 SCREEN          *scn;
{
  /* Always returns true */

  AnimatePointer(scn, False);
  return 1;
}

#define MAX_FOCUS_STACK 5

int
KeyboardFocus(scn, widget, flag)
	 SCREEN          *scn;
	 Widget          widget;
	 int             flag;
{
  static Widget          focusWidget[MAX_SCREENS][MAX_FOCUS_STACK];
  int                    focusWidgetN;

  for (focusWidgetN = 0; focusWidgetN < MAX_FOCUS_STACK-1 && 
	   focusWidget[scn->number][focusWidgetN]; focusWidgetN++);

  switch(flag) {

  case KEYBOARD_FOCUS_SET:
	if (focusWidgetN && widget == 
		focusWidget[scn->number][focusWidgetN-1])
	  break;

	if (focusWidgetN == MAX_FOCUS_STACK-1)
	  {MuError("Keyboard focus stack exhausted!"); return -1;}

	XtSetKeyboardFocus(scn->parentW, 
					   focusWidget[scn->number][focusWidgetN] = widget);
	focusWidget[scn->number][++focusWidgetN] = (Widget)NULL;
	break;
   
  case KEYBOARD_FOCUS_RESTORE:
	focusWidgetN -= 2;
	XtSetKeyboardFocus(scn->parentW, focusWidgetN < 0 ? None :
					   focusWidget[scn->number][focusWidgetN]);
	if (++focusWidgetN >= 0) 
	  focusWidget[scn->number][focusWidgetN] = (Widget)NULL;
	break;

  case KEYBOARD_FOCUS_CLEAR:
	XtSetKeyboardFocus(scn->parentW, None);
	focusWidget[scn->number][0] = (Widget)NULL;
	break;
  }
  
  return 0;
}

/*---------------------------------------------------------------------------+
| Dialog input routines.
+---------------------------------------------------------------------------*/

void
DisableDialogInput(scn)
	 SCREEN         *scn;
{
  XtRemoveAllCallbacks(XawTextGetSource(scn->dialog.valueW), XtNcallback);
  XtRemoveAllCallbacks(scn->dialog.yesW, XtNcallback);
  XtRemoveAllCallbacks(scn->dialog.cancelW, XtNcallback);

  XtVaSetValues(scn->dialog.valueW, 
				XtNdisplayCaret, False, 
				XtNeditType, XawtextRead, 
				XtNstring, "", 
				NULL);
  XtVaSetValues(scn->dialog.yesW, 
				XtNmappedWhenManaged, False, 
				NULL);
  XtVaSetValues(scn->dialog.cancelW, 
				XtNmappedWhenManaged, False, 
				NULL);

  RestoreKeyboardFocus(scn);
  XtRemoveGrab(XtParent(scn->dialog.yesW));

  scn->dialog.mode = DIALOG_INACTIVE;
}

void
MonitorDialogValueCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  String               dialogString;

  XtVaGetValues(widget, 
				XtNstring, &dialogString, 
				NULL);
  if (strchr(dialogString, DIALOG_END_CHAR)) *(int*)clientData = DP_OK;;
}

void
DialogPromptOkCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  *(int*)clientData = DP_OK;
}

void
DialogPromptCancelCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  *(int*)clientData = DP_CANCEL;
}

String
DialogPrompt(scn)
	 SCREEN          *scn;
{
  static int              loopValue;
  static String          dialogString;
  String                 valueS, tmpPtr;

  if (scn->dialog.mode != DIALOG_INACTIVE) return NULL;
  scn->dialog.mode = DIALOG_MODE_VALUE;

  SetKeyboardFocus(scn, scn->dialog.valueW);
  XtAddGrab(XtParent(scn->dialog.yesW), True, False); 

  XtVaSetValues(scn->dialog.valueW, 
				XtNdisplayCaret, True, 
				XtNeditType, XawtextEdit, 
				XtNstring, dialogString ? dialogString : "", 
				NULL);

  XtAddCallback(XawTextGetSource(scn->dialog.valueW), XtNcallback, 
				MonitorDialogValueCallback, (XtPointer)&loopValue);

  XtAddCallback(scn->dialog.yesW, XtNcallback, DialogPromptOkCallback, 
				(XtPointer)&loopValue);
  XtAddCallback(scn->dialog.cancelW, XtNcallback, DialogPromptCancelCallback, 
				(XtPointer)&loopValue);

  XtVaSetValues(scn->dialog.yesW, 
				XtNlabel, "OK", 
				XtNmappedWhenManaged, True, 
				NULL);
  XtVaSetValues(scn->dialog.cancelW, 
				XtNlabel, "Cancel", 
				XtNmappedWhenManaged, True, 
				NULL);

  loopValue = 0;
  while (loopValue == 0) 
	MuProcessEvent(scn->parentW);

  XtVaGetValues(scn->dialog.valueW, 
				XtNstring, &valueS, 
				NULL);
  if (dialogString) XtFree(dialogString);
  dialogString = XtNewString(valueS);
  DisableDialogInput(scn);	

  if (loopValue == DP_CANCEL) {
	SimpleMessage(scn, "Cancelled");
	return NULL;
  }

  if ((tmpPtr = strchr(dialogString, DIALOG_END_CHAR)))
	while(*tmpPtr) {*tmpPtr = *(tmpPtr+1); tmpPtr++;}

  if (*dialogString == CNULL) {
	SimpleMessage(scn, "Empty string, cancelled");
	return NULL;
  }

  return dialogString;
}

/*---------------------------------------------------------------------------+
| Boolean input routines.
+---------------------------------------------------------------------------*/

void
BoleanPromptYesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  *(int*)clientData = BP_YES;
}

void
BoleanPromptNoCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  *(int*)clientData = BP_NO;
}

int
BooleanPrompt(scn)
	 SCREEN          *scn;
{
  static int          loopValue;

  if (scn->dialog.mode != DIALOG_INACTIVE) return -1;
  scn->dialog.mode = DIALOG_MODE_BOOLEAN;

  SetKeyboardFocus(scn, scn->dialog.valueW);
  XtAddGrab(XtParent(scn->dialog.yesW), True, False); 

  XtAddCallback(scn->dialog.yesW, XtNcallback, BoleanPromptYesCallback, 
				(XtPointer)&loopValue);
  XtAddCallback(scn->dialog.cancelW, XtNcallback, BoleanPromptNoCallback, 
				(XtPointer)&loopValue);

  XtVaSetValues(scn->dialog.yesW, 
				XtNlabel, "Yes", 
				XtNmappedWhenManaged, True, 
				NULL);
  XtVaSetValues(scn->dialog.cancelW, 
				XtNlabel, "No", 
				XtNmappedWhenManaged, True, 
				NULL);

  loopValue = 0;
  while (loopValue == 0) 
	MuProcessEvent(scn->parentW);

  DisableDialogInput(scn);	

  if (loopValue == BP_NO) SimpleMessage(scn, "Unconfirmed");

  return loopValue;
}

String
FileInMumailDir(fileName)
	 String fileName;
{
  return FileInHomeDir(FmtString1(".mumail/%s", fileName));
}

void 
ViewAnyFileCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          fileName;

  if ((fileName = SelectFile(scn)) == NULL) return;
  DisplayFileInBodyBox(scn, fileName);
}

void 
EditAnyFileCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          fileName;

  if ((fileName = SelectFile(scn)) == NULL) return;
  EditFileInBodyBox(scn, fileName);
  EditMode(scn, True);
}

int
ExternalEditFile(fileName)
	 String          fileName;
{
  return MuSystem(FmtString2("%s %s", res.externalEditor, fileName));
}

#if 0
/*---------------------------------------------------------------------------+
| Delayed procedure execution routines.
+---------------------------------------------------------------------------*/

void
ExecDelayedCallback(clientData, source, id)
     XtPointer      clientData;
	 int            *source;
	 XtInputId      *id;
{
  _clientDataRec  *clientDataRec = (_clientDataRec*)clientData;
  char            dummy;

  printf("got it\n");
  ReadFromPipe(source, &dummy, sizeof(char));
  (*(XtCallbackProc)clientDataRec->field[0])((Widget)clientDataRec->field[1],
											 clientDataRec->field[2],
											 clientDataRec->field[3]);
}

void
DelayedCallback(scn, widget, callback, clientData, callData)
	 SCREEN         *scn;
	 XtCallbackProc callback;
     Widget         widget;
     XtPointer      clientData,
                    callData;
{
  static int            pd[2];
  static _clientDataRec clientDataRec;
  char                  dummy = CNULL;

  clientDataRec.field[0] = (XtPointer)callback;
  clientDataRec.field[1] = (XtPointer)widget;
  clientDataRec.field[2] = clientData;
  clientDataRec.field[3] = callData;

  if (pd[0] == 0) {
	pipe(pd);
	XtAppAddInput(XtWidgetToApplicationContext(scn->parentW), pd[0], 
				  (XtPointer)XtInputReadMask, ExecDelayedCallback, 
				  (XtPointer)&clientDataRec);
  }

  WriteToPipe(pd, &dummy, sizeof(char));
}
#endif
