/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Paned.h>
#if USE_3D_FRAME
#include "Xfwf/Frame.h"
#endif

#include "MmDecl.h"
#include "MuWin.h"
#include "MuGeneric.h"
#include "version.h"

extern Widget
                CreateTocW(),
                CreateBodyW();

extern void
                SetIcon(),
                CreateDialogW();

SCREEN          *scnList[MAX_SCREENS];
int             numScreens;

SCREEN*
AddScreen(topLevelW, folderName)
	 Widget          topLevelW;
	 String          folderName;
{
  SCREEN               *scn;
  static Atom          WM_DELETE_WINDOW;
  Widget               frameW;
  String               dummyS;
  int                  i;

  if (numScreens >= MAX_SCREENS - 1) {
	MuError("Maximum number of screens reached");
	MuNotice("Recompile with a larger MAX_SCREENS number");
	return (SCREEN*)NULL;
  }

  /* Find the lowest available screen slot */
  for (i = 0; i < numScreens; i++)
	if (scnList[i] == NULL) break;

  /* Allocate the space and initialize it to zero */
  scn = scnList[i] = (SCREEN*)XtCalloc(1, (unsigned)sizeof(SCREEN));
  scn->number = i;
  numScreens++;

  /*-----*/

  scn->parentW = scn->number == 0 ? topLevelW :
	XtVaCreatePopupShell(FmtString1("screen%d", scn->number), 
						 topLevelShellWidgetClass, topLevelW, NULL);

  XtOverrideTranslations(scn->parentW,
		     XtParseTranslationTable("<Message>WM_PROTOCOLS: CloseWindow()"));
  SetIcon(scn->parentW);

  /*-----*/

  scn->topLevelW = topLevelW;

  scn->panedW = AddPaned("mainPaned", scn->parentW);
  CreateMainMenu(scn, scn->panedW);
  scn->toc.tocW = CreateTocW(scn->panedW);
  CreateDialogW(scn, scn->panedW);
  scn->bodyW = CreateBodyW(scn->panedW);

#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("labelFrame", xfwfFrameWidgetClass,
									scn->panedW, NULL); 
#else
  frameW = scn->panedW;
/*  XtVaSetValues(scn->panedW, XtNinternalBorderWidth, 1, NULL);*/
#endif
  scn->labelW = AddLabel("labelW", frameW);

  scn->folder.buffer[0] = NULL;

  /* We have to set this here so that they are defined even if we fail 
	 to open the initial folder */

  scn->folder.numLetters = 0;
  scn->folder.curLetterN = -1;
  scn->folder.changed = False;

  scn->letterList[0] = NULL;
  scn->draft.name = XtNewString(FmtString2("%s.%d", DRAFT_NAME, 
										   scn->number));
  scn->draft.tmpName = XtNewString(FmtString2("%s.tmp.%d", DRAFT_NAME, 
										   scn->number));
  scn->draft.active = False;
  scn->toc.tocS = NULL;

  /*-----*/

  DisplayLogo(scn);

  /*-----*/
  
  if (scn->number) XtPopup(scn->parentW, XtGrabNone);
  else XtRealizeWidget(scn->parentW);

  WM_DELETE_WINDOW = XInternAtom(XtDisplay(scn->parentW), 
								 "WM_DELETE_WINDOW", False);
  XSetWMProtocols(XtDisplay(scn->parentW), XtWindow(scn->parentW), 
				  &WM_DELETE_WINDOW,  1);

  /*-----*/

  if (OpenFolder(scn, folderName) >= 0)
	Message(scn, FmtString3("Welcome to Mumail version %s.%s%s", VERSION, 
							REVISION, QueryMailBox(scn, &dummyS) == 
							QM_MAILBOX_HAS_MAIL ? " (BTW, mailbox has mail)" 
							: ""), MSG_CLEAR_NEVER);
  
  return scn;
}

SCREEN*
FirstScreen(scn)
	 SCREEN          *scn;
{
  int          i;

  /* Most common case */
  if (numScreens == 1) return scn;

  for (i = 0; i < MAX_SCREENS; i++)
	if (scnList[i]) return scnList[i];

  return (SCREEN*)NULL;
}

SCREEN*
NextScreen(scn)
	 SCREEN          *scn;
{
  int          i;

  /* Most common case */
  if (numScreens == 1) return (SCREEN*)NULL;

  for (i = scn->number+1; i < MAX_SCREENS; i++)
	if (scnList[i]) return scnList[i];

  return (SCREEN*)NULL;
}

int
NumberOfScreens(scn)
	 SCREEN          *scn;
{
  return numScreens;
}

SCREEN*
WidgetToScn(widget)
	 Widget widget;
{
  int          i;

  widget = GetShell(widget);
  for (i = 0; i < MAX_SCREENS; i++)
	if (scnList[i] && scnList[i]->parentW == widget) return scnList[i];

  MuError("(SERIOUS ERROR): Could not find screen from widget");
  return NULL;
}

SCREEN*
NewWindowProc(scn)
	 SCREEN          *scn;
{
  AnimStart(scn);
  Message(scn, "New window will appear soon...", MSG_CLEAR_DEFAULT);
  return AddScreen(scn->topLevelW, scn->folder.name);
}

void
NewWindowCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  NewWindowProc(scn);
}

/*---------------------------------------------------------------------------+
| Close window routines.
+---------------------------------------------------------------------------*/

void
CloseWindow(scn)
	 SCREEN          *scn;
{
  RestoreKeyboardFocus(scn);
  if (NumberOfScreens(scn) == 1) {QuickExit(scn); return;}

  XtUnmapWidget(scn->parentW);
  /* This is to insure that the message timer is not triggered after the 
	 screen is destroyed */
  Message(scn, "", MSG_REMOVE_TIMER);

  if (scn->number) XtDestroyWidget(scn->parentW);
  else {
	XtDestroyWidget(scn->panedW);
	XtUnrealizeWidget(scn->parentW);
  }

  numScreens--;
  scnList[scn->number] = NULL;
  XtFree(scn->folder.name);
  XtFree(scn->draft.name);
  XtFree(scn->draft.tmpName);
  XtFree((String)scn);
}

void
CloseWindowProc(scn, prompForExit)
	 SCREEN           *scn;
	 Boolean          prompForExit;
{  
  if (scn->folder.changed) {
	SimpleMessage(scn, "Changes were made to current folder. Discard them?");
	if (BooleanPrompt(scn) == BP_NO) return;
  }

  if (NumberOfScreens(scn) == 1 && prompForExit) {
	SimpleMessage(scn, "Last window. Exit program?");
	if (BooleanPrompt(scn) == BP_NO) return;
  }

  CloseWindow(scn);
}

void 
CloseWindowCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  CloseWindowProc((SCREEN*)clientData, True);
}

void
IconifyWindowCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  IconifyShell(scn->parentW);
}

/*---------------------------------------------------------------------------+
| Exit program routines.
+---------------------------------------------------------------------------*/

void
QuickExit(scn)
	 SCREEN          *scn;
{
  SCREEN           *curScn;

  for (curScn = FirstScreen(scn); curScn; curScn = NextScreen(curScn))
	XtUnmapWidget(curScn->parentW);
  
  XtDestroyApplicationContext(XtWidgetToApplicationContext(scn->parentW));
  exit(0);
}

void 
QuickExitCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  QuickExit((SCREEN*)clientData);
}

void 
ExitCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN           *scn = (SCREEN*)clientData, 
                   *curScn, *nextScn;

  for (curScn = FirstScreen(scn); 
	   curScn && ((nextScn = NextScreen(curScn)) || 1);
	   curScn = nextScn)
	CloseWindowProc(curScn, False);
}
