/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmToc.c --- Table of contemts handling
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Sat Jun 19 08:07:06 1993
 * Update Count    : 51
 * Status          : Mostly OK, needs some cleaning up
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <string.h>
#include "MuWin.h"
#include "MuGeneric.h"
#include "MmDecl.h"

#define MakeTocEditable(scn)\
  XtVaSetValues(scn->toc.tocW, XtNeditType, XawtextEdit, NULL);
#define MakeTocReadOnly(scn)\
  XtVaSetValues(scn->toc.tocW, XtNeditType, XawtextRead, NULL);

extern XawTextPosition
                FindStartOfCurrentLine(),
                TextGetNthLineStartPos(),
                TextGetNthLineStartPosFromCurrentPos();

int
PutTextToTocDisplay(scn, start, text)
	 SCREEN           *scn;
	 XawTextPosition   start;
	 String            text;
{
  XawTextPosition          startPos, endPos;
  XawTextBlock             textBlock;
  int                      retStatus;

  XawTextGetSelectionPos(scn->toc.tocW, &startPos, &endPos);

  SetupTextBlock(textBlock, text);
  retStatus = XawTextReplace(scn->toc.tocW, start, start+textBlock.length, 
							 &textBlock);
  
  XawTextSetSelection(scn->toc.tocW, startPos, endPos);

  return (retStatus == XawEditDone ? 0 : -1);
}

XawTextPosition
TocFindLetterLineS(scn, letterN)
	 SCREEN          *scn;
	 int             letterN;
{
  return TextGetNthLineStartPos(scn->toc.tocW, letterN+1);
}

void
TocMoveToLetterLineS(scn, letterN)
	 SCREEN          *scn;
	 int             letterN;
{
  XawTextSetInsertionPoint(scn->toc.tocW, TocFindLetterLineS(scn, letterN));

  /* Somehow after each 500 lines, the above would offset by one
	 position, so I needed this */
  MoveToStartOfLine(scn->toc.tocW);

/*
  XawTextInvalidate(scn->toc.tocW, 0, FindEndOfBuffer(scn->toc.tocW));
						   TextGetNthLineStartPos(scn->toc.tocW, letterN+1));*/
  /*  XawTextSetInsertionPoint(scn->toc.tocW, 
    TextGetNthLineStartPosFromCurrentPos(scn->toc.tocW, 
	letterN - scn->folder.curLetN));*/
}

void
TocHighlightLetter(scn, letterN)
	 SCREEN          *scn;
	 int             letterN;
{
  TocMoveToLetterLineS(scn, letterN);
  HighlightCurrentLine(scn->toc.tocW);
}

int
TocSetLetterFlag(scn, letterN, flag)
	 SCREEN          *scn;
	 int             letterN; 
	 String          flag;
{
  TocMoveToLetterLineS(scn, letterN);
/*  TocHighlightLetter(scn, letterN);*/

  /* Highlighting moves to the beginning of the current letter line */
  return PutTextToTocDisplay(scn, XawTextGetInsertionPoint(scn->toc.tocW) + 
							 scn->toc.flagPos, flag);


/*  return PutTextToTocDisplay(scn, TocFindLetterLineS(scn, letterN) + 
							 scn->toc.flagPos, flag);*/
}

void
ReDrawTocCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->toc.tocW, "redraw-display");
}

void
RedisplayToc(scn)
	 SCREEN          *scn;
{
/*  XawTextDisableRedisplay(scn->toc.tocW);*/
  TocHighlightLetter(scn, scn->folder.curLetterN);
/*  CallSimpleAction(scn->toc.tocW, "redraw-display");*/
  XawTextEnableRedisplay(scn->toc.tocW);
}

int
GetCurLetterNumberFromToc(scn)
	 SCREEN *scn;
{
  char    *tocS;
  int     letterN;

  tocS = GetCurrentTextSelection(scn->toc.tocW, BUF10);
  if (sscanf(tocS, " %d", &letterN) == 1) return letterN;
  else return -1;
}

int
SetCurLetterNumber(scn)
	 SCREEN          *scn;
{
  int          letterN, showInfo;
  

  if ((letterN = GetCurLetterNumberFromToc(scn)) <= 0 ||
	  letterN > scn->folder.numLetters)
	return -1;
  
  showInfo = (scn->folder.curLetN != --letterN);
  scn->folder.curLetN = letterN;

  if (showInfo) LetterInfo(scn);
  
  /*  printf("-%d-\n", scn->folder.curLetN);*/
  return letterN;
}

void
ScrollTocToLine(scn, lineN)
	 SCREEN          *scn;
	 int             lineN;
{
  ScrollTextToLine(scn->toc.tocW, lineN);
}




