/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MuAlert.c --- Alert popup
 * Author          : Muhammad M. Saggaf
 * Created On      : June 1993
 * Last Modified By: system admin
 * Last Modified On: Sun Jun 20 22:16:18 1993
 * Update Count    : 26
 * Status          : Mostly OK, needs some cleaning up
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Paned.h>
#include <stdlib.h>				/* for atoi */
#include <math.h>				/* for atoi */

#include "MuWin.h"
#include "MuGeneric.h"

#define BUTTON_DELIMITER "|"

int          alertReturnValue;

void
AlertEndCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  alertReturnValue = atoi(XtName(widget));
}

int
Alert(type, parentW, message, buttons)
	 int             type;
	 Widget          parentW;
	 String          message,
	                 buttons;
{
  Widget                 popupW,
                         hPanedW, vPanedW, boxW, 
                         labelW, buttonW;
  static String          buttonS;
  String                 title;
  int                    i;

  popupW = XtVaCreatePopupShell("alert",
								transientShellWidgetClass, parentW,
								XtNtransientFor, GetShell(parentW),
								XtNtitle, "Alert",
								NULL); 

  hPanedW = AddPaned("hPaned", popupW);
  vPanedW = AddPaned("vPaned", hPanedW);

  labelW = AddLabel("message", vPanedW);
  XtVaSetValues(labelW, 
				XtNlabel, message, 
				XtNjustify, XtJustifyCenter,
				NULL);

  boxW = AddBox("box", vPanedW);
  XtVaSetValues(boxW, 
				XtNshowGrip, False, 
				XtNwidth, 400,
				NULL);

  if (buttons == NULL) {
	buttonW = AddButton("1", boxW, AlertEndCallback, NULL);
	XtVaSetValues(buttonW, 
				  XtNlabel, "Ok", 
				  NULL);
  }
  else {
	if (buttonS) XtFree(buttonS);
	buttonS = XtNewString(buttons);
	for (i = 1; 
		 (title = strtok(i == 1 ? buttonS : NULL, BUTTON_DELIMITER));
		 i++) {
	  buttonW = AddButton(FmtString1("%d", i), boxW,
						  AlertEndCallback, NULL); 
	  XtVaSetValues(buttonW, 
					XtNlabel, StripStringA(title), 
					NULL);
	}
  }

  PopupCentered(popupW, parentW);

  alertReturnValue = 0;
  while(alertReturnValue == 0) 
	XtAppProcessEvent(XtWidgetToApplicationContext(parentW), XtIMAll);

  DestroyShell(popupW);
	
  return alertReturnValue;
} 
  
