/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MuChooser.c --- File chooser interface
 * Author          : Muhammad M. Saggaf
 * Created On      : June 1993
 * Last Modified By: system admin
 * Last Modified On: Mon Jun 21 00:25:35 1993
 * Update Count    : 87
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"
#if USE_FILE_CHOOSER

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <unistd.h>				/* for unlink */

#include "Xfwf/FileComp.h"
#include "MuWin.h"
#include "MuGeneric.h"
#include "MmDecl.h"

#ifndef MAX
#define MAX(a,b) (a > b ? a : b)
#endif

#define FC_OK                 1
#define FC_CANCEL             2

extern int          Alert();

String                  FcFileName();
void                    FcMessage();

void
FcGoToHomeDirCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  Widget          chooserW = (Widget)clientData;

  XtVaSetValues(chooserW, XtNfilename, FileInHomeDir(""), NULL);
  CallSimpleAction(chooserW, "complete");
}

void
FcGoToMailDirCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  Widget          chooserW = (Widget)clientData;

  XtVaSetValues(chooserW, XtNfilename, FileInMailDir(""), NULL);
  CallSimpleAction(chooserW, "complete");
}

void
FcDeleteFileCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  Widget          fcW = (Widget)clientData;
  String          fileName = FcFileName(fcW);

  if (!IsRegularFile(fileName)) FcMessage(fcW, "not a regular file");
  else if (Alert(0, widget, "Delete file?", "Ok | Cancel") == 1)
	if (unlink(fileName) < 0) FcMessage(fcW, "unable to delete file");
	else {
	  XfwfFileCompleteTrimToPath(fcW);
	  CallSimpleAction(fcW, "complete");
	  FcMessage(fcW, "file deleted");
	}
}

void
FcClearMessageTimerCallback(clientData, timerId)
	 XtPointer             clientData;
	 XtIntervalId          *timerId;
{
  Widget          statusW = (Widget)clientData;
  XtVaSetValues(statusW, XtNlabel, "", NULL);
  MuXFlush(XtDisplay(statusW));
}

void
FcMessage(fcW, msg)
	 Widget          fcW;
	 String          msg;
{
  static XtIntervalId          timerId;
  Widget                       statusW;

  if ((statusW = XtNameToWidget(fcW, "status")) == NULL) return;

  XtVaSetValues(statusW, XtNlabel, msg, NULL);
  MuXFlush(XtDisplay(fcW));

  if (timerId) XtRemoveTimeOut(timerId);
  timerId = XtAppAddTimeOut(XtWidgetToApplicationContext(fcW),
							3*1000, FcClearMessageTimerCallback, 
							(XtPointer)statusW);
}

void
FcOkCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  String                 fileName = FcFileName(widget);

  if (FileExists(fileName) && !IsRegularFile(fileName)) {
	XfwfFileCompleteTrimToPath(widget);
	FcMessage(widget, "not a regular file"); 
	return;
  }

  *(int*)clientData = FC_OK;
}

void
FcCancelCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  *(int*)clientData = FC_CANCEL;
}

String
FcFileName(fcW)
	 Widget          fcW;
{
  String          fileName;	 

  XtVaGetValues(fcW, XtNfilename, &fileName, NULL);  
  return fileName;
}

String
FileChooser(parentW, initialDir)
	 Widget                  parentW;
	 String                  initialDir;
{
  static Widget          popupW, fcW;
  Dimension              height;
  static String          fcFileName;
  String                 fileName;
  static Boolean         fileChooserUp = False;
  static int             loopValue;

  if (fileChooserUp) return NULL;

  if (popupW == NULL) {
	XtVaGetValues(parentW, XtNheight, &height, NULL);
	popupW = XtVaCreatePopupShell("fileChooser",
								  transientShellWidgetClass, parentW,
								  XtNheight, MAX(height-150, 100),
								  NULL); 

	fcW = XtVaCreateManagedWidget("fileChooserW",
									   xfwffileCompleteWidgetClass, 
									   popupW, 
									   XtNacceptableFilenameProc,
									   XfwfFCRegexFiles, NULL);

	XtAddCallback(fcW, XtNcallback, FcOkCallback, (XtPointer)&loopValue);
	XtAddCallback(fcW, XtNcancelCallback, FcCancelCallback,
				  (XtPointer)&loopValue); 
	XfwfFileCompleteAddButton(fcW, "home", FcGoToHomeDirCallback,
							  (XtPointer)fcW);
	XfwfFileCompleteAddButton(fcW, "mail", FcGoToMailDirCallback,
							  (XtPointer)fcW); 
	XfwfFileCompleteAddButton(fcW, "delete", FcDeleteFileCallback,
							  (XtPointer)fcW); 
  }

  XtVaSetValues(popupW, 
				XtNtransientFor, GetShell(parentW),
				NULL); 
  if (initialDir) XtVaSetValues(fcW, 
								XtNfilename, initialDir, 
								NULL);

  XfwfFileCompleteTrimToPath(fcW);
  CallSimpleAction(fcW, "complete");

  PopupCentered(popupW, parentW);
  fileChooserUp = True;

  loopValue = 0;
  while (loopValue == 0) 
	MuProcessEvent(parentW);

  XtPopdown(popupW);
  fileChooserUp = False;

  if (loopValue == FC_CANCEL) return NULL;

  fileName = FcFileName(fcW);

  if (fcFileName) XtFree(fcFileName);
  fcFileName = XtNewString(fileName);

  return fcFileName;
}

#endif /* USE_FILE_CHOOSER */
