/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MuGeneric.h --- Generic routines (header file)
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Sun Jun 20 16:19:06 1993
 * Update Count    : 11
 * Status          : Mostly OK, needs some cleaning up
 */

extern String
                CopyStreamToBuffer(),
                SimpleCopyStreamToBuffer(),
                CopyFileToBuffer(),
                CopyPipeToBuffer(),
                PrependToBuffer(),

                FileInHomeDir(),
                FileInMailDir(),
                ExpandTilda(),
                PureFromPackedName(),

                CurrentLocalTimeString(),
                FmtString(),
                FilterString(),
                StripStringB(),
                StripStringE(),
                StripStringA(),
                CleanSimpleCommentedBuffer(),
                CloneString(),

                NextWord(),

                Strstr(),
                CaseStrstr(),
                strend();

extern int

                OpenPFile(),
                ClosePFile(),

                WriteToPipe(),
                ReadFromPipe(),

                AppendBufferToFile(),
                AppendFileToStream(),
                AppendFileToFile(),

                PipeBufferToCommand(),

                BackupFile(),

                FileExists(),
                IsRegularFile(),
                FileIsCompressed(),
                FileIsGZipped(),

                MuSystem(),
                ExternalEditFile(),

                ElapsedUTimeGreater(),
                ElapsedMTimeGreater(),

                CaseStrSame(),
                CaseNStrSame(),
                GetNthLinePos();

extern void 
                FreeList(),

                MuError(),
                MuNotice(),
                MuPError(),

                MuProcessEvent();

#define FileIsPacked(name) (FileIsCompressed(name) || FileIsGZipped(name))

#define FmtString0(fmt) FmtString(fmt,"","","","","")
#define FmtString1(fmt,s1) FmtString(fmt,s1,"","","","")
#define FmtString2(fmt,s1,s2) FmtString(fmt,s1,s2,"","","")
#define FmtString3(fmt,s1,s2,s3) FmtString(fmt,s1,s2,s3,"","")
#define FmtString4(fmt,s1,s2,s3,s4) FmtString(fmt,s1,s2,s3,s4,"")
#define FmtString5(fmt,s1,s2,s3,s4,s5) FmtString(fmt,s1,s2,s3,s4,s5)
