/*---------------------------------------------------------------------------+
| This file is part of Mumail, Copyright (c) 1992-1993 by
| Muhammad M. Saggaf. All rights reserved.
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------+
| Doesn't this config file look pretty? It does! I stole err... `borrowed'
| this comment style from Joaquim Jorge <jorgej@cs.rpi.edu>.
+---------------------------------------------------------------------------*/

#ifndef MUMAIL_CONFIG_H
#define MUMAIL_CONFIG_H

/*---------------------------------------------------------------------------+
| Leave these alone
+---------------------------------------------------------------------------*/

#define YES  1
#define Yes  YES
#define yes  YES
#define NO   0
#define No   NO
#define no   NO

/*---------------------------------------------------------------------------+
| Whether your system has the strstr library function.
+---------------------------------------------------------------------------*/

#define HAVE_STRSTR           YES

/*---------------------------------------------------------------------------+
| Whether your system's strstr is slow. If so, Mumail will use its own 
| strstr. This affects mainly folder loading time. It's reported that 
| strstr on Suns is slow. Also, on linux using Mumail's strstr instead
| of the system's decreases folder loading time a bit. You might try both
| versions. The only file you'll have to recompile is MuGeneric.c.
+---------------------------------------------------------------------------*/

#define HAVE_SLOW_STRSTR      YES

/*---------------------------------------------------------------------------+
| Whether your system has the strerror library function.
+---------------------------------------------------------------------------*/

#define HAVE_STRERROR         YES

/*---------------------------------------------------------------------------+
| Whether your system has the strftime library function.
+---------------------------------------------------------------------------*/

#define HAVE_STRFTIME         YES

/*---------------------------------------------------------------------------+
| Whether your system has the truncate(2) system function.
+---------------------------------------------------------------------------*/

#define HAVE_TRUNCATE         YES

/*---------------------------------------------------------------------------+
| Whether you want to compile and use the File Chooser, which allows
| you to pick folders by clicking on them rather than typing their
| names. I cannot think of any reason why you don't wan to compile it
| other than if you have trouble with its compilation. In this case,
| you can take it out by simply changing YES below to NO.
+---------------------------------------------------------------------------*/

#define USE_FILE_CHOOSER      YES

/*---------------------------------------------------------------------------+
| Whether you want Mumail to have a pretty 3D look. The only reason
| you wouldn't want that is if you're unable to compile the frame
| widget. In this this case, disable this option. Otherwise, you must
| really have a poor taste :-).
+---------------------------------------------------------------------------*/

#define USE_3D_FRAME          YES

/*---------------------------------------------------------------------------+
| Your mail delivery agent (sendmail) program.
+---------------------------------------------------------------------------*/

/* moved to the resources */

/*---------------------------------------------------------------------------+
| The external editor (not necessary since Mumail has its own (very good?)
| editor). I like to use Emacs sometimes without starting a new window, so
| my external program is emacsclient. Refer to Emacs' FAQ to learn how to 
| use emacsclient (in a nutshell, type ``M-x server-start'' in an existing
| Emacs' window, then invoke emacsclient from outside, like from Mumail).
+---------------------------------------------------------------------------*/

/* moved to the resources */

#ifdef CRAY
/* I'd like to know about this! :-) */
#endif

/*---------------------------------------------------------------------------+
| Leave those alone.
+---------------------------------------------------------------------------*/

#ifndef IN_IMAKEFILE

#if !HAVE_STRSTR
extern char* strstr();
#endif

#if !HAVE_STRERROR
extern char* strerror();
#endif

#if !HAVE_STRFTIME
extern char* strftime();
#endif

#if !HAVE_TRUNCATE
extern int truncate();
#endif

#endif /* IN_IMAKEFILE */

#endif /* MUMAIL_CONFIG_H */
