\"                             -*- Mode: Nroff -*- 
\" mumail.man --- Manual page
\" Author          : Muhammad M. Saggaf
\" Created On      : April 1993
\" Last Modified By: system admin
\" Last Modified On: Fri Jun 18 16:26:03 1993
\" Update Count    : 13
\" Status          : Mostly OK
\" 

.TH Mumail 1X "June 1993" "Revision 2.0b" "X11 Super Clients" \" -*- nroff -*-
\".TH Mumail 1X "June 1993" "MMS Programs" "X11 Super Clients" \" -*- nroff -*-

.SH NAME
Mumail \- X11 Mail Reader.

.SH PRONUNCIATION

Mumail is pronounced \fImo mail\fP, as in \fImore mail\fP.

.SH SYNOPSIS

\fBMumail\fP [\-option ...] [\-toolkit_option ...]

.SH DESCRIPTION

.P 
\fIMumail\fP is a complete full-featured mail reader for the \fIX
Window System\fP. \" Some of its features are:


.SH OPTIONS

.PP
Toolkit options given at the command line (e.g. \-geometry, \-iconic, ..etc.)
all refer to the first Mumail screen (screen 0).

\"Besides the toolkit options, Mumail recognizes the following
\"command-line switches:

.SH RESOURCES

Toolkit resources (e.g. geometry, iconic, ..etc.) for Mumail's first
screen (screen 0) are specified as usual. Toolkit resources for other
screens have to be qualified by the screen number. Examples follow.

.PD 0
.IP
For screen 0:
.IP
Mumail.<resource>: <value>
.PD

.PD 0
.IP
For screen 1:
.IP
Mumail.screen1.<resource>: <value>
.PD

.PD 0
.IP
For all screens:
.IP
Mumail*<resource>: <value>
.PD

.PD 0
.IP
Invalid:
.IP
Mumail.screen0.<resource>: <value>
.PD

.PP
Besides the toolkit resources, Mumail defines some proprietry
resources. All proprietry resources are global and cannot be specified
on a per-screen basis. These resources are as follows:

.TP
.BI cite.fillColumn " (int)"
This is the column beyond which automatic line-wrapping for formatted
citation should happen. The program will break the line at the nearest
word boundary if the line goes beyond this column.
.I Default value: 70

.TP
.BI cite.indentString " (string)"
Left-hand padding for formatted citation. This string will be
prepended to the normal citation string. The default is a tab, to
left-indent quoted text a bit for a more aesthetic look.
.I Default value: \\\\t

.TP
.BI cite.nestedAttribFmt " (string)"
The attribution format string used for nested (rn-style) citation.
The content of the original letter's From: header will be substituted
for the conversion specifier (%s) in this format string.
.I Default value: \\\\n>>>>> %s wrote:\\\\n>\\\\n

.TP
.BI cite.nonNestedAttribFmt " (string)"
The attribution format string used for non-nested (sc-style)
citation. The program will prompt for a string (usually the initials
of the person to whom the cited text is attributed) to substitute for
the first conversion specifier (%s) in this format string. The content
of the original letter's From: header will be substituted for the
second conversion specifier.
.I Default value: \\\\n>>>>> %s == %s wrote:\\\\n\\\\n

.TP
.BI externalEditor " (string)"
You favorite external editor. Keep in mind though that Mumail has its
own quite capable editor.
.I Default value: emacs

.TP
.BI mailAgent.passAddress " (boolean)"
Wheather to leave the task of extracting the To:, Cc:, and Bcc:
headers from the message to the mail delivery agent, or wheather
Mumail itself should perform that task and pass the addresses in those
headers to the mail delivery agent on the command line. Refer to the
section titled \fIMail Delivery Agents\fP below for more details.
.I Default value: off

.TP
.BI mailAgent.program " (string)"
The mail delivery agent on your system. This progarm is responsible
for delivering mail to local and remote hosts, and will be invoked by
Mumail when sending letters. Refer to the section titled \fIMail
Delivery Agents\fP below for more details.
.I Default value: /usr/lib/sendmail

.TP
.BI mailAgent.arguments " (string)"
Command-line switches to pass to the mail delivery agent. Refer to the
section titled \fIMail Delivery Agents\fP below for more details.
.I Default value:  \-bm \-oi \-oem \-t


.TP
.BI mime.addHeaders " (boolean)"
Whether Mumail should add the MIME headers to outgoing messages. These
headers make the letter MIME-compiant so that it will be handled
properly if read by a MIME-aware mail reader at the other end. There
is no harm in enabling this feature other than cluttering the
headers. These headers will be available for editing by the user while
composing the draft, and are constructed according to the default
letter properties given by other resources (see below).
.I Default value: on

.TP
.BI mime.agentCommand " (string)"
The full command (including switches) of the mime agent on the
system. Mumail will pass MIME-compliant messages that are not plain
text (e.g. jpeg pictures, audio sounds, ..etc), to this agent for
viewing, subject to the resource \fImime.invokeAgent\fP.
.I Default value: metamail -d -r -x -m Mumail

.TP
.BI mime.multipartBoundary " (string)"
This is the bounadry Mumail should use to separate the MIME subparts
included in a multipart MIME letter contrcuted via the
\fImime-include\fP command. Refer to the section titled \fIMIME
Support\fP below for more details.
.I Default value: ####

.TP
.BI mime.defaultContentType " (string)"
The default content type of outgoing letters. The Content-Type header
in the draft will be set according to this resource if
\fImime.addHeaders\fP is enabled.
.I Default value: text/plain

.TP
.BI mime.defaultCharSet " (string)"
The default character set of outgoing letters. The Content-Type header
in the draft will be set according to this resource if
\fImime.addHeaders\fP is enabled.
.I Default value: US-ASCII

.TP
.BI mime.defaultTransferEncoding " (string)"
The default transfer encoding of outgoing letters. The
Content-Transfer-Encoding header in the draft will be set according to
this resource if \fImime.addHeaders\fP is enabled.
.I Default value: 7BIT

.TP
.BI mime.invokeAgent " (enumeration)"
Specifies the action taken by Mumail when the user elects to view a
MIME-compliant letter that is not plain text. This resources can be
either \fInever\fP (never invoke the MIME agent), \fIalways\fP
(automatically invoke it, without confirmation), or \fIask\fP (prompt
the user before invoking). Case is irrelevant, so Ask and ask mean the
same thing.
.I Default value: ask

.TP
.BI printCommand " (string)"
The external command (program) used on your system to send documents
to the printer for printing. This is used by Mumail for printing
letters and folders from withen the program.
.I Default value: lpr

.TP
.BI signatureFile " (string)"
The base name of the user's signature file. The program will look for
this file in the user's home directory.
.I Default value: .signature

.SH MAIL DELIVERY AGENTS

Mumail does not rely on any external programs for incorporaitng and
reading mail. However, like other mail readers of its ilk (e.g. elm,
pine, ..etc.), Mumail relies on mail delivery agents for sending mail.
It is important that Mumail is told enough information about the mail
delivery agent on your system, or outgoing letters may not be
delivered successfully due to miscommunication bewteen Mumail and the
mail delivery agent.

Mumail needs to know three things about the mail delivery agent, all
of which are set via the resources: the program's name, command
switches to pass to, and whether to pass the receipients' addresses to
it on the command line. The first two are self-explanatory, the third
means whether Mumail should extract the To:, Cc:, and Bcc: headers
from the message and pass those on the command line to the mail
delivery agent, or leave this task to be performed by the mail agent
itself. Care should be taken not to give the mail delivery agnet
conflicting options; for example, specifying \-t as a command-line
switch to smail and telling Mumail to pass the addresses to it would
result in smail not delivering the message to anybody. Suggested
settings for some of the more popular mail delivery agents are
discussed below.

By far the most popular mail delivery agents are \fIsendmail\fP,
\fIsmail\fP and \fImailx\fP (old Berkeley mail). The first two (with a
suitable switch) do not need the addresses to be passed to them. Note
that although these two progarms can be run in a mode where they need
the addresses to be passed to them, it is recommended that you do not
use that mode, but instead take advantage of their intelligence.  This
is purely a case of me having more trust of the ability of those
programs to extract the headers properly than I have in my own
program! Don't let that fool you though, Mumail is very good at what
it does, and you have to rely on it anyway if you're using mailx.

Note that regardless of what program extracts the headers, Mumail
alsways performas alias expanstion and Fcc: refiling for the message
before invoking the mail delivery agent. Suggested values for Mumail
resources describing the mail delivery agents mentioned above are as
follows:


.PD 0
.TP 
.I sendmail
.IP
Mumail.mailAgent.program: /usr/lib/sendmail
.IP
(or sendmail, if in the path)
.IP
Mumail.mailAgent.argumentss: \-bm \-oi \-oem \-t
.IP
Mumail.mailAgent.passAddress: off
.PD

.PD 0
.TP 
.I smail
.IP
Mumail.mailAgent.program: smail
.IP
(also /bin/rmail, send-mail)
.IP
Mumail.mailAgent.argumentss: \-bm \-oi \-oem \-t
.IP
Mumail.mailAgent.passAddress: off
.PD

.PP
If you want Mumail to take care of extracting the headers and to pass
them on the command line to the mail agent, then change the latter
resources in the above two examples to:

.PD 0
.IP
Mumail.mailAgent.argumentss: \-bm \-oi \-oem
.IP
Mumail.mailAgent.passAddress: on
.PD

.PD 0
.TP 
.I mailx (old Berkeley mail)
.IP
Mumail.mailAgent.program: /bin/mail
.IP
(also /usr/ucb/mail)
.IP
Mumail.mailAgent.argumentss:
.IP
Mumail.mailAgent.passAddress: on
.PD


.SH ALIASES

Mumail has full support for mail aliases. When sending a draft, the
program expands each alias to the corresponding addresses listed in
the alises file. The aliases file can be edited from withen Mumail and
is reread automatically whenever it changes, even if the change is
made by an external program.

The format of the aliases file is as follows:

.nf
.IP
alias = address
.fi

.PP
For example:

.PD 0
.nf
.IP
boss = stinker@stinking.com
.IP
colleagues = freddie@stinking.com, jane@stinking.com
.fi
.PD

.PP
Aliases can be previewed before sending the letter (useful if, for
example, the user is not sure of what alias corresponds to what
address and wants to check) via the \fIExpand Aliases\fP option of the
draft menu. This is meant for previewing only and is not required,
since all aliases and MIME inclusions are expaneded automatically when
the letter is sent.

.SH MIME SUPPORT

Mumail suppoerts the Multipurpose Internet Mail Extensions,
\fIMIME\fP. For incoming letters, Mumail identifies MIME-compliant
letters that are not plain text and passes them to the system's MIME
agent for display, subject to the resource \fImime.invokeAgent\fP. The
program also adds MIME-compliant headers to all outgoing letters,
unless the user elects not to do so. Those headers are available for
editing during letter composition and can be changed there. They are
constructed according to the MIME resources mentioned elsewhere in
this manual.

MIME subparts can be included in any outgoing letter in a straight
forward manner. To insert a MIME subpart in an outgoing letter, put a
line like the following at the place in the draft where you want the
subpart to be included:

.nf
.I @mime-include <entity> <content-type/subtype> [encoding]@
.fi

.PP
Mumail will then insert the subpart and add the appropriate boundaries
and letter headers to the document. The command will be ignored unless
it starts on a new line. The command itself can span multiple lines,
however, and does not have to fit a single line. The third argument is
optional, and text beyond it till the end of the command (as delimited
by @) is ignored. Arguments that contain spaces have to be quoted. The
resource \fImime.addHeaders\fP has to be enabled in this case, or you
may get an inconsistent (MIME-incompliant) document.

The first argument is either a file name or a shell command whose
output is be placed in the document. If this argument starts with the
dollar sign, it will considered a shell command, otherwise it is
considered file name. The second argument is the content type and
subtype of the subpart, and third is the content transfer encoding
used to encode the subpart. Examples follow.

The following commands insert a plain text subpart whose content is in
the file ~/foo.bar:

.PD 0
.nf
.IP
@mime-include ~/foo.bar text/plain 7bit@
.IP
@mime-include ~/foo.bar text/plain@
.IP
@mime-include ~/foo.bar "text/plain; charset=us-ascii" 7bit@
.fi
.PD

.PP
The following command inserts a gif image whose content has been
encoded in base64 and placed in a file called pic.b64:

.PD 0
.nf
.IP
@mime-include pic.b64 image/gif base64@
.fi
.PD

.PP
The following command encodes a jpeg image whose content is in the
file pic.jpg into base64 and then inserts the encoded result in the
document. This is the easiest and most typical use of the command.

.PD 0
.nf
.IP
@mime-include "$mmencode pic.jpg" image/jpeg base64@
.fi
.PD

.PP
A similar command, but sends an audio file instead: 

.PD 0
.IP
.nf
@mime-include "$mmencode sound.au" audio/basic base64@
.fi
.PD

.PP
Refer to RFC-1341 for details on the valid MIME content types and
transfer encodings.

Multiple subparts can be included in the letter with or without plain
text between them. Here is an example:

.PD 0
.IP
\&...
.IP
Hey Joe, here is the latest output I got from the simulation:
.nf
.IP
@mime-include "$mmencode semu-4.jpg" image/jpeg base64@
.fi
.IP
As you can see, it differes quite a bit from last week's results:
.nf
.IP
@mime-include "$mmencode semu-1.jpg" image/jpeg base64@
.IP
@mime-include "$mmencode semu-2.jpg" image/jpeg base64@
.fi
.IP
What do you think?
.IP
\&...
.PD

.PP
Included subaprts can be expanded in the draft for previewing before
the letter is sent. This can be done via the \fIExpand MIME
Inclusions\fP menu option under the draft menu. This is meant for
previewing only and is not required, since all aliases and MIME
inclusions are expaneded automatically when the letter is sent. Also
note that unlike expanding aliases, using the Expand MIME Inclusions
menu choice more than once in the same draft (do not confuse this with
expanding numerous, possibly repeated, inclusions with a single
invocation of the menu choice) will likely result in a malformed
(i.e. MIME-incompliant) document.

.SH MENUS

.TP
.B Window Menu:

.IP
.I New:
Opens a new window with the current folder. Folders are not shared
between windows, and changes in a folder in one window does not
affect the same folder if also opened in another window.

.IP
.I Close:
Closes the current window. Closing the last window exits the program
(the user is always prompted before exiting in this case).

.IP
.I Iconify <C-z>:
Iconifies the current window. 

.IP
.I Exit Program <q>:
Exits the program. The user is prompted if the folder is not saved.

.IP
.I Quick Exit <Q>:
Exits the program unconditionally. No prompt is issued, even if the
folder is not saved.

.TP
.B Folder Menu:

.IP
.I Check Mailbox:
Reports if the the user's mailbox has any mail.

.IP
.I Read New Mail:
Incorporates new mail into the inbox folder \fIMUINBOX\fP and makes it
the current folder. 

.IP
.I Open <C-o>:
Opens a folder.

.IP 
.I ReOpen:        
Reopens the current folder.

.IP
.I Open in Next Window:
Opens a folder in the next window. If no next window exits, a new one
is created.

\" New...                    

.IP
.I Save <C-s>:
Saves the current folder. The folder is saved in the same fomrat it
was opened in. For example, a compressed folder is saved as
compressed. 

.IP
.I Save As:    
Saves the current folder under a new name. The folder will
automatically be saved as compressed if the new name ends with .Z, and
as gzipped if it ends with .z or .gz.

.IP
.I Save Compressed:
Saves the current folder in compressed format. There is no need to
choose this if the folder is already compressed.

.IP
.I Save GZipped:              
Saves the current folder in gzipped format. There is no need to
choose this if the folder is already gzipped.

.IP
.I Save Unpacked (Normal):
If the folder is compressed/gzipped, this will save it as a normal
file (non-compressed/gzipped). Otherwise, it's equivalent to
\fIOpen\fP.

.IP
.I Edit:
Allows the user to edit the current folder. This should be used only
by people who know what they're doing.

.IP
.I Delete:
Deletes the current folder.

.IP
.I Commit Changes <C-c>:
Commits all changes to the folder without saving it. This is
convenient to reduce the clutter in the table of content by removing
all deleted letters.

.IP
.I Sort:  
Sorts the current folder by date in ascending order.

.IP
.I Search (Current->Last):
Searches all letters in the folder for a given string starting from
the current letter. The first letter containing the string will be
highlighted and displayed. The search is case-insensitive.

.IP
.I Reconstruct TOC:
Reconstrcuts the table of contents from the folder.

.IP
.I Redraw TOC <C-l>:
Redraws (redisplays) the table of contents.

.IP
.I Info:
Displays information about the current folder.

.TP
.B Letter Menus:

.IP
.I View <Space>: 
Displays the current letter.

.IP
.I View Whole <v>:
Displays the current letter with all its headers.

.IP
.I View in Next Window: 
Displays the current letter in the next window. If no next window
exits, a new one is created.

.IP
.I MIME View:
Passes the current letter to the MIME agent for display. Refer to the
section titled \fIMIME Support\fP for more details.

.IP
.I Compose <c>:
Allows the user to compose and send a new letter.

.IP
.I Reply <r>:
Replies to the current letter.

.IP
.I Forward <f>:
Forwards the current letter.

.IP
.I Follow-up:                     
Follows-up on the current letter.

.IP
.I Quote/Reply (SC Fmt.) <M-1>:
Quotes the current letter in formatted non-nested (SuperCite-like)
style and replies to it. Lines are adjusted withen paragraphs to fit
the width of the fill-column. Refere to the resource
\fIcite.fillColumn\fP for more details.

.IP
.I Quote/Reply (SC Unfmt.) <M-2>:
Quotes the current letter in unformatted non-nested (SuperCite-like)
style and replies to it. Lines are \fInot\fP adjusted withen
paragraphs to fit the width of the fill-column.

.IP
.I Quot/Reply (RN) <M-3>:
Quotes the current letter in unformatted nested (rn-like) style and
replies to it. Simplest type of citation.

.IP
.I External Compose
Composes a new letter using the extrnal editor. Refer to the resource
\fIexternalEditor\fP for more details. 

\"External Reply                

.IP
.I Info <i>:
Displays information about the current letter.

.IP
.I Tag/Untag <t>:
Tags or untags the current letter.

.IP
.I Tag All:
Tags all letters in the folder.

.IP
.I Tag Range:
Tags a range of letters. The user is prompted for the range.

.IP
.I Untag All:
Untags all letters in the folder.

.IP
.I Retag <T>:
Retags the letters that were tagged before the last oparation. For
example, to copy a range of letters to a file then delete them, use
Tag Range * Copy * Retag * Delete.

.IP
.I Delete <d>:
Deletes the current letter or tagged letters.

.IP
.I Undelete <u>:
Undeletes the current letter or tagged letters.

.IP
.I Copy <C>:
Copies the current letter or tagged letters to a folder.
folder name.

.IP
.I Refile <F>:
Refiles the current letter or tagged letters to a folder.

.IP
.I Pipe to Command:
Pipes the current letter or tagged letters (one at a time) to a shell
command. For example, piping a letter to the command \fIlpr\fP prints
it.
        
.IP
.I Print:
Prints the current letter or tagged letters. Refer to the resource
\fIprintCommand\fP for more details.

.IP
.I Explode Digest:
Explodes a digest into its constituent letters.

.IP
.I Explode Grotty Digest:
Explodes a digest not conforming to the de facto standard Digest
Message Format (RFC-1153) into its constituent letters. Use this if
the digest fails to explode properly using \fIExplode Digest\fP.

.IP
.I Search <C-s>:
Searches the current letter for a given string. The accelerator key is
valiad only in the body box (letter) area.

.TP
.B Draft Menu

I'm tired. Figure this one out for yourself.

.TP
.B Edit Menu

ditto.

.TP
.B Help Menu

ditto.

.SH MOUSE AND KEY BINDINGS

All Mumail mouse and key bindings can be set via the resource
translation table, so they can easily be modified by the user if the
default ones do not suit his/her taste.

The default mouse bindings for the table of contents display are as
follows.

.PD 0
.TP
.I Left Button
select letter (does not display)
.TP
.I Middle Button
select letter and display
.TP
.I Right Button
tag letter
.PD

.PP
There are also some key shortcuts, but they do not cover all menu
choices. Those are as follows. Note that they are case-sensitive.

.PD 0
.TP
.I q
exit (ask if folder not saved)
.TP
.I Q
quick exit (no confirmation)

.TP
.I o
open folder
.TP
.I Ctrl-s
save folder
.TP
.I Ctrl-c
commit changes
.TP
.I Ctrl-i
folder info
.TP
.I Ctrl-l
redraw table of contents

.TP
.I PgUp
scroll up
.TP
.I PgDown
scroll down
.TP
.I Meta-<
first page
.TP
.I Meta->
last page

.TP
.I Down
select next letter (does not display)
.TP
.I Up
select previous letter (does not display)
.TP
.I n
select next letter and display
.TP
.I p
select previous letter and display
.TP
.I "."
display current letter
.TP
.I v
display current letter with all headers (verbose)

.TP
.I space
display current letter or scroll current letter or display next letter
(as appropriate)
.TP
.I BackSapce, b
backward-page in letter
.TP
.I Return
next line in letter 

.TP
.I t
tag/untag letter
.TP
.I T
retag letters
.TP
.I d
delete letter(s)
.TP
.I u
undelete letter(s)
.TP
.I c
compose letter
.TP
.I r
reply to letter
.TP
.I Meta-r, Meta-1
quote and reply to letter (SuperCite style, formatted)
.TP
.I Ctrl-r, Meta-2
quote and reply to letter (SuperCite style, unformatted)
.TP
.I R, Meta-3
quote and reply to letter (rn style, unformatted)

.TP
.I f
forward letter
.TP
.I e
compose letter with an external editor
.TP
.I C
copy letter(s) to another folder
.TP
.I F
refile letter(s) to another folder
.TP
.I i
display letter info
.PD

.PP
In the letter view area, besides the usual mouse functions (scrolling
and such), the editor/viewer has a large number of mouse and key
bindings. I'm not going to list those here, but they generally follow
Emacs' key bindings (e.g. Ctrl-s for search, Ctrl-w for kill region,
..etc). Here are some additional ones:

.PD 0
.TP
.I PgUp
scroll back
.TP
.I PgDown
scroll down

.TP
.I Meta-S
send draft (and save)
.TP
.I Meta-C
kill draft (cancel send)
.TP
.I Meta-1
quote current letter (SuperCite style, formatted)
.TP
.I Meta-2
quote current letter (SuperCite style, unformatted)
.TP
.I Meta-3
quote current letter (rn style, unformatted)
.TP
.I Meta-s
insert signature
.PD

.SH FILES

Mumail expects all mail folders to be in the directory ~/Mail.
Program configuration files should reside in the directory ~/.mumail.

.TP
.BI ~/Mail/MUINBOX
This is the inbox folder all new incoming mail is deposited into.

.TP
.BI ~/.mumail/headers
The headers in this file is added to the headers of all outgoing
letters. These headers are visible to the user during letter
composition and can be edited before sending the letter. This file
typically contains the user's custom header.

.TP
.BI ~/.mumail/aliases
The aliases file. See the section titled \fIAliases\fP above for more
details.

.TP
.BI ~/.signature
The user's signature file. The content of this file will be inserted
in the draft when the InsertSignature function is called. An alternate
signature file can be specified via the resource \fIsignatureFile\fP

.SH SEE ALSO

mail(1), sendmail(8)

.SH BUGS

None that I know of so far, but there must be some.

.SH COPYRIGHT

Mumail is Copyright (c) 1992-1993 of Muhammad M. Saggaf. Mumail is not
public domain. Permission is granted to use and distribute Mumail
freely for any use and to sell it at any price without reference to
the copyright owner provided that in all above cases Mumail is intact
and is not made part of any program either in whole or in part and
that this copyright notice is included with Mumail. Permission is also
granted to modify the source as long as the modified source is not
distributed without prior consent of the author.

.SH AUTHOR

Muhammad M. Saggaf, alsaggaf@mit.edu. Snail Mail: Muhammad Saggaf, Box
9863, Dhahran 31311, SAUDI ARABIA. I apologize that I may not be able
to respond to all correspondence I receive.

.SH ACKNOWLEDGEMENT

Joseph Urban (jurban@norden1.com) supplied me with the RFC-1153
document and examples of digests that were not correcly handled by
older versions of the program. KidMun.Yap@mel.dit.csiro.au sent me
patches and ideas that I based some new features on. And my sincere
thanks to everybody to sent me comments, suggestions, bug fixes, or
yes, even bug reports :-).


