#ifndef OI_VUMETER_H
#define OI_VUMETER_H

class VuMeter : public OI_display_1d {
 public:
	static OI_class *clsp ; /* ptr to class record */
 private:
			int	ox;	/* old x */
			int	oy;	/* old y */
			int	xo;	/* x offset to center */
			int	yo;	/* y offset to center */
			int	diameter;	/* diameter of the rotator */
			int	ndegrees ;	/* number of degrees in the meter */
			double	nradians ;	/* number of radians in this sweep */
			double	start ;	/* starting angle */
			double	delta ;	/* delta angle (per tick) */
			double	inner_radius;	/* inner radius = 2/3 radius = 1/3 diameter */

			void	calculate_constants();
			void	construct(OI_number, OI_number, OI_number );
protected:
				VuMeter(OI_class *, const char *, OI_number, OI_number, OI_number,
					OI_number, long , long mn = 0 );
			int	arc();
	virtual		OI_stat	create();		/* create X window */
			void	new_arc( int );
	virtual		void 	paint(const XEvent *, void* = NULL);		/* handle exposure */
	virtual		void 	paint_current() { }		/* for baseclass */
			void	paint_tick_labels();
			void	paint_ticks();
	virtual		void	paint_value(long) ;		/* paint value (bar, needle pos., etc. */
	virtual		void	re_layout() { }		/* for baseclass */
			void	res_arc( void* );
			void	resize();
			void	set_arc( int );
 public:
				VuMeter(const char *, OI_number, OI_number, OI_number, OI_number, long,
					long mn =0 );
				~VuMeter();
	static	OI_bool		init(OI_connection *);		/* initialize class */
	static	VuMeter		*make_minimal(const char *, OI_minimal_type); 
	virtual		void	set_marker_orientation(OI_marker*)	{}           /* pure virtual of OI_display_1d */
};
VuMeter*	create_VuMeter( const char*, OI_number, OI_number, OI_number, OI_number, long, long );

#endif /* OI_VUMETER_H */
