/*
 * $XFree86: mit/server/ddx/x386/vga256/drivers/cirrus/cir_driver.c,v 1.9 1993/05/18 14:28:15 dawes Exp $
 * Header: /usr/local/src/Xaccel/cirrus/RCS/driver.c,v 1.6 1993/04/04 17:57:44 bill Exp
 *
 * Copyright 1993 by Bill Reynolds, Santa Fe, New Mexico
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Bill Reynolds not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Bill Reynolds makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * BILL REYNOLDS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL BILL REYNOLDS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Bill Reynolds, bill@goshawk.lanl.gov
 *
 */

#include "X.h"
#include "input.h"
#include "screenint.h"

#include "compiler.h"

#include "x386.h"
#include "x386Priv.h"
#include "x386OSD.h"
#include "vga.h"

static int cirrusChip;

#define CLGD5420_ID 0x22
#define CLGD5422_ID 0x23
#define CLGD5424_ID 0x25
#define CLGD5426_ID 0x24

#define CLGD5420    0
#define CLGD5422    1
#define CLGD5424    2
#define CLGD5426    3

				/* For now, only save a couple of the */
				/* extensions. */
typedef struct {
  vgaHWRec std;               /* good old IBM VGA */
  unsigned char GR9;		/* Graphics Offset1 */
  unsigned char GRA;		/* Graphics Offset2 */
  unsigned char GRB;		/* Graphics Extensions Control */
  unsigned char SR7;		/* Extended Sequencer */
  unsigned char SRE;		/* VCLK Numerator */
  unsigned char SRF;		/* DRAM Control */
  unsigned char SR1E;		/* VCLK Denominator */
  unsigned char CR19;		/* Interlace End */
  unsigned char CR1A;		/* Miscellaneous Control */
  unsigned char CR1B;		/* Extended Display Control */
  } vgacirrusRec, *vgacirrusPtr;

unsigned char SavedExtSeq;

static Bool     cirrusProbe();
static char *   cirrusIdent();
static void     cirrusClockSelect();
static void     cirrusEnterLeave();
static Bool     cirrusInit();
static void *   cirrusSave();
static void     cirrusRestore();
static void     cirrusAdjust();

extern void     cirrusSetRead();
extern void     cirrusSetWrite();
extern void     cirrusSetReadWrite();

vgaVideoChipRec CIRRUS = {
  cirrusProbe,			/* ChipProbe()*/
  cirrusIdent,			/* ChipIdent(); */
  cirrusEnterLeave,		/* ChipEnterLeave() */
  cirrusInit,			/* ChipInit() */
  cirrusSave,			/* ChipSave() */
  cirrusRestore,		/* ChipRestore() */
  cirrusAdjust,			/* ChipAdjust() */
  NoopDDA,			/* ChipSaveScreen() */
  NoopDDA,			/* ChipGetMode() */
  cirrusSetRead,		/* ChipSetRead() */
  cirrusSetWrite,		/* ChipSetWrite() */
  cirrusSetReadWrite,	        /* ChipSetReadWrite() */
  0x10000,			/* ChipMapSize */
  0x08000,			/* ChipSegmentSize, 32k*/
  15,				/* ChipSegmentShift */
  0x7FFF,			/* ChipSegmentMask */
  0x00000, 0x08000,		/* ChipReadBottom, ChipReadTop  */
  0x08000, 0x10000,		/* ChipWriteBottom,ChipWriteTop */
  TRUE,				/* ChipUse2Banks, Uses 2 bank */
  VGA_NO_DIVIDE_VERT,		/* ChipInterlaceType -- don't divide verts */
  {0,},				/* ChipVendorFlags -- none for this driver */
};


typedef struct {
  unsigned char numer;
  unsigned char denom;
  } cirrusClockRec;

static cirrusClockRec cirrusClockTab[] = {
  { 0x4A, 0x2B },		/* 25.227 */
  { 0x5B, 0x2F },		/* 28.325 */
  { 0x45, 0x30 }, 		/* 41.164 */
  { 0x7E, 0x33 },		/* 36.082 */
  { 0x42, 0x1F },		/* 31.500 */
  { 0x51, 0x3A },		/* 39.992 */
  { 0x55, 0x36 },		/* 45.076 */
  { 0x65, 0x3A },		/* 49.867 */
  { 0x76, 0x34 },		/* 64.983 */
  { 0x7E, 0x32 },		/* 72.163 */
  { 0x6E, 0x2A },		/* 75.000 */
  { 0x5F, 0x22 },		/* 80.013 */
};

#define NUM_CIRRUS_CLOCKS (sizeof(cirrusClockTab)/sizeof(cirrusClockRec))

/* CLOCK_FACTOR is double the osc freq in kHz (osc = 14.31818 MHz) */
#define CLOCK_FACTOR 28636

/* clock in kHz is (numer * CLOCK_FACTOR / (denom & 0x3E)) >> (denom & 1) */
#define CLOCKVAL(n, d) \
     ((((n) & 0x7F) * CLOCK_FACTOR / ((d) & 0x3E)) >> ((d) & 1))

#define MAX_5420_CLOCK 75200

#define new ((vgacirrusPtr)vgaNewVideoState)

/*
 * cirrusClockSelect -- , IHOPE
 *      select one of the possible clocks ...
 */

static void
cirrusClockSelect(no)
     int no;
{
  static unsigned char save1, save2, save3;
  unsigned char temp;
  int SR,SR1;


#ifdef DEBUG_CIRRUS
  fprintf(stderr,"Clock NO = %d\n",no);
#endif

#if 0
  SR = 0x7E; SR1 = 0x33;	/* Just in case.... */
#endif

  switch(no)
       {
     case CLK_REG_SAVE:
       save1 = inb(0x3CC);
       outb(0x3C4, 0x0E);
       save2 = inb(0x3C5);
       outb(0x3C4, 0x1E);
       save3 = inb(0x3C5);
       break;
     case CLK_REG_RESTORE:
       outb(0x3C2, save1);
       outw(0x3C4, (save2 << 8) | 0x0E);
       outw(0x3C4, (save3 << 8) | 0x1E);
       break;
     default:
       if ( no >= NUM_CIRRUS_CLOCKS )
	    return;
       if( (cirrusChip == CLGD5420) &&
           (CLOCKVAL(cirrusClockTab[no].numer, cirrusClockTab[no].denom) >
            MAX_5420_CLOCK) )
	    {
	    ErrorF( "CLGD5420 doesn't support 80MHz Clock, check Xconfig\n");
	    return;
	    }
       SR = cirrusClockTab[no].numer;
       SR1 = cirrusClockTab[no].denom;

				/*  Use VCLK3 for these extended clocks */
       temp = inb(0x3CC);
       outb(0x3C2, temp | 0x0C );
  
#ifdef DEBUG_CIRRUS
       fprintf(stderr,"Misc = %x\n",temp);
       fprintf(stderr,"Miscactual = %x\n",(temp & 0xF3) | 0x0C);
#endif
  
				/* Set SRE and SR1E */
       outb(0x3C4,0x0E);
       temp = inb(0x3C5);
       outb(0x3C5,(temp & 0x80) | (SR & 0x7F));
  
#ifdef DEBUG_CIRRUS
       fprintf(stderr,"SR = %x\n",temp);
       fprintf(stderr,"SRactual = %x\n",(temp & 0x80) | (SR & 0x7F));
#endif

       outb(0x3C4,0x1E);
       temp = inb(0x3C5);
       outb(0x3C5,(temp & 0xC0) | (SR1 & 0x3F));
  
#ifdef DEBUG_CIRRUS
       fprintf(stderr,"SR1 = %x\n",temp);
       fprintf(stderr,"SR1actual = %x\n",(temp & 0xC0) | (SR1 & 0x3F));
#endif
       break;
       }
}


/*
 * cirrusIdent -- 
 */

static char *
cirrusIdent(n)
     int n;
{
  static char *chipsets[] = {"clgd5420", "clgd5422", "clgd5424", "clgd5426"};

  if (n + 1 > sizeof(chipsets) / sizeof(char *))
    return(NULL);
  else
    return(chipsets[n]);
}


/*
 * cirrusProbe -- 
 *      check up whether a cirrus based board is installed
 */

static Bool
cirrusProbe()
{  
     int cirrusClockNo, i;
     unsigned char lockreg,IdentVal;
     unsigned char id;
     
     if (vga256InfoRec.chipset)
	  {
	  if (!StrCaseCmp(vga256InfoRec.chipset, "cirrus"))
	       {
               ErrorF("\ncirrus is no longer valid.  Use one of\n");
	       ErrorF("the names listed by the -showconfig option\n");
	       return(FALSE);
               }
	  cirrusChip = -1;
	  for (i = CLGD5420; i <= CLGD5426; i++)
	       {
	       if (!StrCaseCmp(vga256InfoRec.chipset, cirrusIdent(i)))
	            {
	            cirrusChip = i;
	            }
	       }
	  if (cirrusChip > 0)
	       {
	       cirrusEnterLeave(ENTER); /* Make the timing regs writable */
	       }
	  else
	       {
	       return(FALSE);
	       }
	  }
     else
	  {
	  unsigned char temp, origVal, newVal;
	  
	  cirrusEnterLeave(ENTER); /* Make the timing regs writable */
	  
	  /* Kited the following from the Cirrus */
	  /* Databook */
	  
	  /* If it's a Cirrus at all, we should be */
	  /* able to read back the lock register */
	  /* we wrote in cirrusEnterLeave() */
	  
	  outb(0x3C4,0x06);
	  lockreg = inb(0x3C5);
	  
	  /* Ok, if it's not 0x12, we're not a Cirrus542X. */
	  if (lockreg != 0x12)
	       {
	       cirrusEnterLeave(LEAVE);
	       return(FALSE);
	       }
	  
	  /* OK, it's a Cirrus. Now, what kind of */
	  /* Cirrus? We read in the ident reg, */
	  /* CRTC index 27 */
	  
	  
	  outb(vgaIOBase+0x04, 0x27); IdentVal = inb(vgaIOBase+0x05);
	  
	  cirrusChip = -1;
	  switch( (id = (IdentVal & 0xFC) >> 2) )
	       {
	     case CLGD5420_ID:
	       cirrusChip = CLGD5420;
	       break;
	     case CLGD5422_ID:
	       cirrusChip = CLGD5422;
	       break;
	     case CLGD5424_ID:
	       cirrusChip = CLGD5424;
	       break;
	     case CLGD5426_ID:
	       cirrusChip = CLGD5426;
	       break;
	     default:
	       ErrorF("Unknown Cirrus chipset: type 0x%02x\n", id);
	       cirrusEnterLeave(LEAVE);
	       return(FALSE);
	       break;
	       }
	  
	  }
     
     
     /* OK, we are a Cirrus */
     if (!vga256InfoRec.videoRam) 
	  {
	  unsigned char memreg;

				/* Thanks to Brad Hackenson at Cirrus for */
				/* this bit of undocumented black art....*/
	  outb(0x3C4,0x0A);
	  memreg = inb(0x3C5);
	  
	  switch( (memreg & 0x18) >> 3 )
	       {
	     case 0:
	       vga256InfoRec.videoRam = 256;
	       break;
	     case 1:
	       vga256InfoRec.videoRam = 512;
	       break;
	     case 2:
	       vga256InfoRec.videoRam = 1024;
	       break;
	     case 3:
	       vga256InfoRec.videoRam = 2048;
	       break;
	       }

	  /* Set up the clocks */

				/* The 5420 only clocks up to 75MHz */
				/* So we can't use clock number 12 */

	  if( cirrusChip == CLGD5420 ) cirrusClockNo = 11;
	  else cirrusClockNo = 12;
	       
	  if (!vga256InfoRec.clocks)
	       if (VFLG_ISSET(OPTION_PROBE_CLKS, &vga256InfoRec.vendor))
		    vgaGetClocks(cirrusClockNo, cirrusClockSelect);
	       else
		    {
		    vga256InfoRec.clocks = cirrusClockNo;
		    for (i = 0; i < cirrusClockNo; i++)
			vga256InfoRec.clock[i] =
			  CLOCKVAL(cirrusClockTab[i].numer,
				   cirrusClockTab[i].denom);
		    }
	  else
	       if (vga256InfoRec.clocks > NUM_CIRRUS_CLOCKS)
		    {
		    ErrorF("Too many Clocks specified in Xconfig.\n");
		    ErrorF("At most %d clocks may be specified\n",
			   NUM_CIRRUS_CLOCKS);
		    }
	  
	  vga256InfoRec.chipset = cirrusIdent(cirrusChip);
	  vga256InfoRec.bankedMono = FALSE;
	  VFLG_SET(OPTION_PROBE_CLKS, &CIRRUS.ChipVendorFlags);
	  return(TRUE);
	  }
     
}
     


/*
 * cirrusEnterLeave -- 
 *      enable/disable io-mapping
 */

static void 
cirrusEnterLeave(enter)
     Bool enter;
{
  static unsigned char temp;

  

  if (enter)
       {
#ifdef HAS_USL_VTS
       ioctl(x386Info.consoleFd, KDENABIO, 0);
#endif

				/* Are we Mono or Color? */
       vgaIOBase = (inb(0x3CC) & 0x01) ? 0x3D0 : 0x3B0;

       
       
       
       outb(0x3C4,0x06);
       outb(0x3C5,0x12);	 /* unlock cirrus special */

       
				/* Put the Vert. Retrace End Reg in temp */

       outb(vgaIOBase + 4, 0x11); temp = inb(vgaIOBase + 5);

				/* Put it back with PR bit set to 0 */
				/* This unprotects the 0-7 CRTC regs so */
				/* they can be modified, i.e. we can set */
				/* the timing. */

       outb(vgaIOBase + 5, temp & 0x7F);

    }
  else
       {

       outb(0x3C4,0x06);
       outb(0x3C5,0x0F);	 /*relock cirrus special */

#ifdef HAS_USL_VTS
       ioctl(x386Info.consoleFd, KDDISABIO, 0);
#endif
    }
}



/*
 * cirrusRestore -- 
 *      restore a video mode
 */

static void 
cirrusRestore(restore)
  vgacirrusPtr restore;
{
  unsigned char i;


  outw(0x3CE, 0x0009);	/* select bank 0 */
  outw(0x3CE, 0x000A);

  vgaHWRestore(restore);

/*  unsigned char GR9;		 Graphics Offset1 */
/*  unsigned char GRA;		 Graphics Offset2 */
/*  unsigned char GRB;		 Graphics Extensions Control */
/*  unsigned char SR7;		 Extended Sequencer */
/*  unsigned char SRE;		 VCLK Numerator */
/*  unsigned char SRF;		 DRAM Control */
/*  unsigned char SR1E;		 VCLK Denominator */
/*  unsigned char CR19;		 Interlace End */
/*  unsigned char CR1A;		 Miscellaneous Control */
/*  unsigned char CR1B;		 Extended Display Control */

  outw(0x3C4, 0x0100);				/* disable timing sequencer */

  outb(0x3CE,0x09);
  outb(0x3CF,restore->GR9);

  outb(0x3CE,0x0A);
  outb(0x3CF,restore->GRA);

  outb(0x3CE,0x0B);
  outb(0x3CF,restore->GRB);

  outb(0x3C4,0x07);
  outb(0x3C5,restore->SR7);

  if (restore->std.NoClock >= 0)
       {
       outb(0x3C4,0x0E);
       outb(0x3C5,restore->SRE);
       }

  outb(0x3C4,0x0F);
  outb(0x3C5,restore->SRF);

  if (restore->std.NoClock >= 0)
       {
       outb(0x3C4,0x1E);
       outb(0x3C5,restore->SR1E);
       }

  outb(vgaIOBase + 4,0x19);
  outb(vgaIOBase + 5,restore->CR19);

  outb(vgaIOBase + 4,0x1A);
  outb(vgaIOBase + 5,restore->CR1A);

  outb(vgaIOBase + 4, 0x1B);
  outb(vgaIOBase + 5,restore->CR1B);


				/* I'll leave it, since it looks like */
				/* standard VGA *QUESTION**/

 outw(0x3C4, 0x0300);  /*now reenable the timing sequencer */
}



/*
 * cirrusSave -- 
 *      save the current video mode
 */

static void *
cirrusSave(save)
     vgacirrusPtr save;
{
  unsigned char             temp1, temp2;

  
  vgaIOBase = (inb(0x3CC) & 0x01) ? 0x3D0 : 0x3B0;

  outb(0x3CE, 0x09);
  temp1 = inb(0x3CF);
  outb(0x3CF, 0x00);	/* select bank 0 */
  outb(0x3CE, 0x0A);
  temp2 = inb(0x3CF);
  outb(0x3CF, 0x00);	/* select bank 0 */

  save = (vgacirrusPtr)vgaHWSave(save, sizeof(vgacirrusRec));


/*  unsigned char GR9;		 Graphics Offset1 */
/*  unsigned char GRA;		 Graphics Offset2 */
/*  unsigned char GRB;		 Graphics Extensions Control */
/*  unsigned char SR7;		 Extended Sequencer */
/*  unsigned char SRE;		 VCLK Numerator */
/*  unsigned char SRF;		 DRAM Control */
/*  unsigned char SR1E;		 VCLK Denominator */
/*  unsigned char CR19;		 Interlace End */
/*  unsigned char CR1A;		 Miscellaneous Control */
/*  unsigned char CR1B;		 Extended Display Control */

  save->GR9 = temp1;

  save->GRA = temp2;

  outb(0x3CE,0x0B);		
  save->GRB = inb(0x3CF); 
				
  outb(0x3C4,0x07);
  save->SR7 = inb(0x3C5);

  outb(0x3C4,0x0E);
  save->SRE = inb(0x3C5);

  outb(0x3C4,0x0F);
  save->SRF = inb(0x3C5);

  outb(0x3C4,0x1E);
  save->SR1E = inb(0x3C5);

  outb(vgaIOBase + 4,0x19);
  save->CR19 = inb(vgaIOBase + 5);

  outb(vgaIOBase + 4,0x1A);
  save->CR1A = inb(vgaIOBase + 5);

  outb(vgaIOBase + 4, 0x1B);
  save->CR1B = inb(vgaIOBase + 5);

  return ((void *) save);
}



/*
 * cirrusInit -- 
 *      Handle the initialization, etc. of a screen.
 */

static Bool
cirrusInit(mode)
     DisplayModePtr mode;
{
     unsigned char temp1;
     
  if (!vgaHWInit(mode,sizeof(vgacirrusRec)))
    return(FALSE);

/*  unsigned char GR9;		 Graphics Offset1 */
/*  unsigned char GRA;		 Graphics Offset2 */
/*  unsigned char GRB;		 Graphics Extensions Control */
/*  unsigned char SR7;		 Extended Sequencer */
/*  unsigned char SRE;		 VCLK Numerator */
/*  unsigned char SRF;		 DRAM Control */
/*  unsigned char SR1E;		 VCLK Denominator */
/*  unsigned char CR19;		 Interlace End */
/*  unsigned char CR1A;		 Miscellaneous Control */
/*  unsigned char CR1B;		 Extended Display Control */


				/* Set the clock regs */

     if (new->std.NoClock >= 0)
          {
          unsigned char tempreg;
          int SR,SR1;
          
          if (new->std.NoClock >= NUM_CIRRUS_CLOCKS)
               {
               ErrorF("Invalid clock index -- too many clocks in Xconfig\n");
               return(FALSE);
               }
				/* Always use VLCK3 */

          new->std.MiscOutReg |= 0x0C;

#if 0
          SR = 0x7E; SR1 = 0x33;	/* Just in case.... */
#endif

          if( (cirrusChip == CLGD5420) &&
              (CLOCKVAL(cirrusClockTab[new->std.NoClock].numer,
		        cirrusClockTab[new->std.NoClock].denom) >
	       MAX_5420_CLOCK) )
	       {
	       ErrorF("CLGD5420 doesn't support 80MHz Clock, check Xconfig\n");
	       return (FALSE);
	       }
          SR = cirrusClockTab[new->std.NoClock].numer;
          SR1 = cirrusClockTab[new->std.NoClock].denom;

				/* Be nice to the reserved bits... */
          outb(0x3C4,0x0E);
          tempreg = inb(0x3C5);
          new->SRE = (tempreg & 0x80) | (SR & 0x7F);

          outb(0x3C4,0x1E);
          tempreg = inb(0x3C5);
          new->SR1E = (tempreg & 0xC0) | (SR1 & 0x3F);
          }
     
     
     new->std.CRTC[0x13] = vga256InfoRec.virtualX >> 3;
     
				/* Enable Dual Banking */
     new->GRB = 0x01;

				/* Setting the 5 bit to either 1 or 0 works. */
				/* I don't understand the difference. The */
				/* book says this bit is the "CRT FIFO */
				/* Depth". */
     outb(0x3C4,0x0F);
     new->SRF = inb(0x3C5);


     new->SR7 = 0x01;		/* Tell it to use 256 Colors */

#if 0
				/* Try Linear Addressing. */
     new->SR7 |= ( ((int) vgaBase) >> 16) & 0x0000F0;
     fprintf(stderr,"vgaBase = %x\n",vgaBase);
/* Doesn't work on systems w/ more than 16M memory. T.S. */
#endif
     

				/* Fill up all the overflows - ugh! */
#ifdef DEBUG_CIRRUS
     fprintf(stderr,"Init: VSyncStart + 1 = %x\n\
HsyncEnd>>3 = %x\n\
HDisplay>>3 -1 = %x\n\
VirtX = %x\n",
	     mode->VSyncStart + 1,
	     mode->HSyncEnd >> 3, 
	     (mode->HDisplay >> 3) - 1,
	     vga256InfoRec.virtualX>>4);
#endif
     
     new->CR1A = (((mode->VSyncStart + 1) & 0x300 ) >> 2)
	  | (((mode->HSyncEnd >> 3) & 0xC0) >> 2);

     if (mode->Flags & V_INTERLACE) 
	    {
				/* ``Half the Horizontal Total'' which is */
				/* really half the value in CR0 */
				/* All of these seem to work, more or less. */
				/* I think it depends more strongly on what */
				/* you have in your Xconfig. */

	    new->CR19 = ((mode->HTotal >> 3) - 5) >> 1;
#if 0
	    new->CR19 = mode->HTotal >> 4;
	    new->CR19 = 0x20 |
		 ((mode->HSyncEnd >> 3) - (mode->HTotal >> 4)) & 0x1F;
	    new->CR19 = ((mode->HSyncEnd >> 3) - (mode->HTotal >> 4));
	    new->CR19 = (mode->HSyncEnd >> 4);
#endif
	    new->CR1A |= 0x01;
	    new->std.CRTC[0x09] |= 0x80;
	    }
     else new->CR19 = 0x00;
     
     new->CR1B = (((vga256InfoRec.virtualX>>3) & 0x100) >> 4)
	  | 0x22;
     

  return(TRUE);
}




/*
 * cirrusAdjust --
 *      adjust the current video frame to display the mousecursor
 */

static void 
cirrusAdjust(x, y)
     int x, y;
{
     unsigned char CR1B;
     int Base = (y * vga256InfoRec.virtualX + x) >> 2;
     outw(vgaIOBase + 4, (Base & 0x00FF00) | 0x0C);
     outw(vgaIOBase + 4, ((Base & 0x00FF) << 8) | 0x0D);

     outb(vgaIOBase + 4,0x1B); CR1B = inb(vgaIOBase + 5);
     outb(vgaIOBase + 5,(CR1B & 0xF2) | ((Base & 0x060000) >> 15)
	  | ((Base & 0x010000) >> 16) );

}

