/*
 * $XFree86: mit/server/ddx/x386/common/x386OSD.h,v 1.22 1993/05/09 12:11:43 dawes Exp $
 * Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Thomas Roell not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Thomas Roell makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * THOMAS ROELL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THOMAS ROELL BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: /proj/X11/mit/server/ddx/x386/RCS/x386OSD.h,v 1.1 1991/06/02 22:36:17 root Exp $
 */

#ifndef _X386OSD_H
#define _X386OSD_H

#include <X11/Xos.h>
#include <stdio.h>
#include <ctype.h>
#ifndef AMOEBA
#include <sys/ioctl.h>
#if !defined(linux) && !defined(_MINIX)
#undef NULL
#endif /* !linux && !_MINIX */
#ifndef _MINIX
#include <sys/param.h>
#endif
#include <signal.h>
#ifndef MACH386
#if !defined(__386BSD__) && !defined(_MINIX)
#include <termio.h>
#else
#include <termios.h>
#define termio termios
#ifdef __386BSD__
/* Don't need this header for linkkit use */
#ifndef LINKKIT
/* this defines CONSOLE_XMODE for CODRV, and also has the pccons X ioctls */
#define COMPAT_CO011
#define COMPAT_PCCONS
#include <sys/ioctl_pc.h>
#endif /* !LINKKIT */
#endif /* __386BSD__ */
#endif /* __386BSD__ || _MINIX */
#endif /* MACH386 */
#include <errno.h>
extern int errno;

#if !defined(__386BSD__) && !defined(linux) && !defined(MACH386) && !defined(_MINIX) && !defined(__OSF__)
#ifdef _NEED_SYSI86
#include <sys/immu.h>
#include <sys/region.h>
#include <sys/proc.h>
#include <sys/tss.h>
#include <sys/sysi86.h>
#ifdef SVR4
#include <sys/seg.h>
#endif
#include <sys/v86.h>
#endif
#endif

#if defined(ATT) && !defined(i386)
#define i386 /* not defined in ANSI C mode */
#endif

#if defined(SYSV) || defined(SVR4) || defined(linux)
# define HAS_USL_VTS
#endif

#if defined(SVR4) || defined(linux) || defined(__386BSD__)
# define CLEARDTR_SUPPORT
#endif

#ifdef HAS_USL_VTS
#ifdef linux
#include <sys/mman.h>
#include <sys/kd.h>
#include <sys/vt.h>
#define LDGMAP GIO_SCRNMAP
#define LDSMAP PIO_SCRNMAP
#define LDNMAP LDSMAP
#else
#include <sys/emap.h>

#ifndef SCO
# include    <sys/at_ansi.h>
# include    <sys/kd.h>
# include    <sys/vt.h>
#else /* SCO */
# include    <sys/vtkd.h>
# include    <sys/console.h>
# include    <sys/keyboard.h>
# define LED_CAP  0x01
# define LED_NUM  0x02
# define LED_SCR  0x04
#endif /* SCO */
#endif /* linux */
#endif /* HAS_USL_VTS */

/* 
 * Special hack for isc 2.2 posix compatible include files
 */
#if !defined(O_NDELAY) && defined(O_NONBLOCK)
# define	O_NDELAY	O_NONBLOCK
#endif

#ifndef VT_ACKACQ
# define VT_ACKACQ 2  /* bed-time for bonzo ... */
#endif

#if defined(ATT) || defined(SVR4)
# define XQUEUE
# include <sys/xque.h>
#endif

#ifndef MAXHOSTNAMELEN
# define MAXHOSTNAMELEN 32
#endif

#ifndef linux

/* Do this for SVR4 too to avoid using libucb.a */
#if defined(SYSV) || defined(SVR4)
#define usleep(usec) syscall(3112, usec / 1000)
#endif

#ifdef MACH386
#ifndef __STDC__
#define __STDC__ 1
#include <i386at/kd.h>
#include <i386at/kd_queue.h>
#undef __STDC__
#else
#include <i386at/kd.h>
#include <i386at/kd_queue.h>
#endif /* __STDC__ */
#include <sys/file.h>
#define SEEK_SET L_SET
#endif /* MACH386 */

#endif

#ifdef _MINIX
#include <assert.h>
#include <limits.h>
#include <sys/memio.h>
#include <sys/kbdio.h>
#endif /* _MINIX */

#else /* AMOEBA */
#include <amoeba.h>
#include <cmdreg.h>
#include <stderr.h>
#include <ampolicy.h>
#include <proc.h>
#include <signal.h>
#include <server/iop/iop.h>
#include <errno.h>

/* keyboard types */
#define KB_84                   1
#define KB_101                  2
#define KB_OTHER                3

extern capability iopcap;
#endif /* AMOEBA */

/* This is defined in x386Config.c */
extern int StrCaseCmp(
#if NeedFunctionPrototypes
	char *,
	char *
#endif
);

#endif /* _X386OSD_H */
