
/* register definitions for the Intel 82365SL PCMCIA controller */

#ifndef i82365_h
#define i82365_h

#define I365_BASE     0x3E0   /* I/O port base */

/* Offsets for PCIC registers */
#define I365_IDENT    0x00    /* Identification and revision */
#define I365_STATUS   0x01    /* Interface status */
#define I365_POWER    0x02    /* Power and RESETDRV control */
#define I365_INTCTL   0x03    /* Interrupt and general control */
#define I365_CSC      0x04    /* Card status change */
#define I365_CSCINT   0x05    /* Card status change interrupt control */
#define I365_ADDRWIN  0x06    /* Address window enable */
#define I365_GENCTL   0x16    /* Card detect and general control register */
#define I365_GBLCTL   0x1E    /* Global control register */

#define I365_IOCTL    0x07    /* I/O control */
#define I365_IO_0     0x08    /* I/O window 0 */
#define I365_IO_1     0x0C    /* I/O window 1 */

#define I365_MEM_0    0x10    /* Memory window 0 */
#define I365_MEM_1    0x18    /* Memory window 1 */
#define I365_MEM_2    0x20    /* Memory window 2 */
#define I365_MEM_3    0x28    /* Memory window 3 */
#define I365_MEM_4    0x30    /* Memory window 4 */

/* Card detect mask for I365_STATUS */
#define CS_DETECT     0x0C

/* Flags for I365_INTCTL */
#define PC_RESET      0x40
#define PC_IOCARD     0x20

/* Offsets for I/O and memory window registers */
#define W_START       0
#define W_STOP        2
#define W_OFF         4

/* Flags for memory window registers */
#define MEM_16BIT     0x8000    /* In memory start high byte */
#define MEM_0WS       0x4000
#define MEM_WS1       0x8000    /* In memory stop high byte */
#define MEM_WS0       0x4000
#define MEM_WRPROT    0x8000    /* In offset high byte */
#define MEM_REG       0x4000

/* I365_POWER flags */
#define PWR_OFF       0x00    /* Turn off the socket */
#define PWR_OUT       0x80    /* Output enable */
#define PWR_NORESET   0x40    /* Disable RESETDRV on resume */
#define PWR_AUTO      0x20    /* Auto pwr switch enable */
#define VCC_5V        0x10    /* Vcc = 5.0v */
#define VCC_3V        0x18    /* Vcc = 3.3v */
#define VPP_5V        0x01    /* Vpp = 5.0v */
#define VPP_12V       0x02    /* Vpp = 12.0v */

/* I365_ADDRWIN flags */
#define ENA_IO_1       0x80
#define ENA_IO_0       0x40
#define ENA_MEM_4      0x10
#define ENA_MEM_3      0x08
#define ENA_MEM_2      0x04
#define ENA_MEM_1      0x02
#define ENA_MEM_0      0x01

/* I365_IOCTL flags */
#define IOCTL_1_WAIT   0x80
#define IOCTL_1_0WS    0x40
#define IOCTL_1_CS16   0x20
#define IOCTL_1_16BIT  0x10
#define IOCTL_0_WAIT   0x08
#define IOCTL_0_0WS    0x04
#define IOCTL_0_CS16   0x02
#define IOCTL_0_16BIT  0x01

#endif /* i82365_H */
