%{
/*
 * $Id: lex_config.l,v 1.1 1993/09/08 02:50:01 bjaspan Exp $
 * $Source: /u1/pcmcia/RCS/lex_config.l,v $
 */

#include "lex_config.h"

#undef output
#define output(x) syntax_error("lexical syntax error")

toktype tokval;
int config_lineno = 0;

%}

id	[a-zA-Z_][a-zA-Z_0-9]*
int	[0-9]+
hex	0x[0-9a-fA-F]+
string	\"([^"]|\\.)*\"


%%

\n			config_lineno++;
[ \t]*			;
[ ]*[#;].*		;
","			return (COMMA);
"="			return (EQ);
"-"			return (DASH);
"@"			return (AT);

"*" 			{
     			  static char b[5];
			  strcpy(b, "\".*\"");
			  return lex_string(b);
		        }

{string}		return lex_string(yytext);
{int}			return lex_int(yytext);
{hex}			return lex_int(yytext);
{id}			return lex_id(yytext);

%%

#include <stdio.h>
#include <string.h>
#include <math.h>

#define DEBUG_LEX 0

#ifdef DEBUG_LEX
int debug_lex = DEBUG_LEX;
#define PRINTF(args) if (debug_lex) printf args
#else
#define PRINTF(args)
#endif
   
struct keyword {
     char *id;
     int num; /* enum tokens num; */
};

static struct keyword kwds[] = {
     "device", DEVICE,
     "io", IO,
     "irq", IRQ,
     "mem", MEM,
     "none", NONE,
};
static int num_kwds = sizeof(kwds) / sizeof(struct keyword);

static int kw_comp(struct keyword *kw1, struct keyword *kw2)
{
     return strcmp(kw1->id, kw2->id);
}

int lex_id(char *s)
{
     int i;
     struct keyword *kw;
     static struct keyword search = { NULL, 0 };

     search.id = s;

     /* is it a keyword? */
     kw = (struct keyword *) bsearch((char *) &search, kwds,
				     num_kwds,
				     sizeof(search), kw_comp);
     
     if (kw) {
	  PRINTF(("lex_id: keyword %s (%d)\n", kw->id, kw->num));
	  return kw->num;
     } else {
	  PRINTF(("lex_id: identifier %s\n", s));
	  tokval.s = s;
	  return IDENTIFIER;
     }
}

int lex_int(char *s)
{
     tokval.n = strtol(s, NULL, 0);
     PRINTF(("lex_int: %d\n", tokval.n));
     return INT;
}

int lex_string(char *s)
{
     /* chop off leading and trailing " */
     s++;
     s[strlen(s)-1] = '\0';
     tokval.s = s;
     PRINTF(("lex_string: \"%s\"\n", tokval.s));
     return STRING;
}


