(load "sysdef")
(load "version")
(make::make :maxima)
;; clean up a bit.
(sloop::sloop for v in-package 'make do (unintern v))
(remprop :maxima :make)
(remprop :minima :make)
(sloop::sloop for v in-package 'maxima do (remprop v 'sys::definition))
;(load "autol") 
;(load "max_ext")
;(gc)
(defparameter lisp::*load-paths* '(#"./" #"/usr/local/maxima/**/" #"./**/" #"~/**/"))
(defun run (&optional continuable)
  (declare (ignore continuable))
  (sys::driver #'maxima::macsyma-top-level)
)
(setq *driver* ;; top level
  #'(lambda ()
      (setq maxima::*window* (sys::make-window))
      (setf (symbol-function 'bye)
            #'(lambda () (close maxima::*window*) (exit))
      )
      (format t "~A ~A~%"
                ;"~A ~A~%Maxima 4.0 (with enhancements by W. Schelter).~%Type (run) to start Maxima."
                (lisp-implementation-type) (lisp-implementation-version)
      )
      (in-package "USER")
      (setq *driver* #'run)
    )
)
(setq *break-driver* #'run) ;; remove this if you want to debug at Lisp level

(savemem "maxima.mem")
