;;Copyright William F. Schelter 1990, All Rights Reserved

(in-package "MAXIMA")
(eval-when (compile) (proclaim '(optimize (safety 0))))

#+kcl (clines "#include \"drawps.hc\"")
(defvar $transform_xy nil)
(defvar *z-range* nil)
(defvar $colour_z nil)
(defvar *original-points* nil)
(defvar $axes_length 4.0)
(defvar *rot* (make-array 9 :element-type 'double-float))
(defvar $rot nil)
(defvar $view_direction '((mlist) 1 1 1))
(defvar $pt_range '((mlist) -2.0 2.0 -2.0 2.0))
(defvar $plot_ticks '((mlist) 30 30))
(defvar $pstream nil)


#|
(defun ff (x y) (expt 2 (- (* x x) (* y y))))
|#



#+kcl (defentry sort-ngons  (object object int) (int "sort_ngons"))

(defun print-pt1 (f str)
  (format str "~,3f " f))


(defmacro defbinop (name op type)
  `(progn
     (defun ,name (x y) (the ,type (,op  (the ,type x) (the ,type y))))
     (eval-when (compile eval)     
     (#+kcl si::DEFINE-COMPILER-MACRO #-kcl
	    defmacro ,name (x y)
         `(the ,',type (,',op  (the ,',type ,x) (the ,',type ,y)))))))

(defbinop f+ + fixnum)
(defbinop f- - fixnum)

(defbinop $+ + double-float)
(defbinop $- - double-float)
(defbinop $* * double-float)
(defbinop $/ / double-float)

(eval-when (compile eval)

(defmacro f* (a b &optional c)
  (if c `(f* (f* ,a ,b) ,c)
    `(the fixnum (* (the fixnum ,a) (the fixnum ,b)))))

(defmacro $< (a b) `(< (the double-float ,a) (the double-float ,b)))
  



(defmacro z-pt (ar i) `(aref ,ar (the fixnum (+ 2 (* ,i 3)))))
(defmacro y-pt (ar i) `(aref ,ar (the fixnum (+ 1 (* ,i 3)))))
(defmacro x-pt (ar i) `(aref ,ar (the fixnum (+ 0 (* ,i 3)))))
(defmacro rot (m i j) `(aref ,m (the fixnum (+ ,i (the fixnum (* 3 ,j))))))



(defmacro print-pt (f)
  `(print-pt1 ,f $pstream ))

#+kcl
(push '((double-float t) t t t "(((#1)->sm.sm_fp ? fprintf((#1)->sm.sm_fp,\"%.3f\",(#0)): 0),Cnil)") (get 'print-pt1 'compiler::inline-unsafe))



(defstruct (polygon (:type list)
		    (:constructor make-polygon (pts edges))
		    )
  (dummy '($polygon simp))
  pts edges)

(defmacro make-polygon (a b) `(list '($polygon) ,a ,b))
)

(defun draw3d (f minx maxx miny maxy  nxint nyint)
  (let* ((epsx (/ (- maxx minx) nxint))
	 (x 0.0)  ( y 0.0)
	 (epsy (/ (- maxy miny) nyint))
	 (nx (+ nxint 1))
	 (l 0)
	 (ny (+ nyint 1))
	 (ar (make-array  (+ 12  ; 12  for axes
			     (f* (f* 3 nx) ny))  :fill-pointer (f* (f* 3 nx) ny)
			 :element-type 'double-float
			 :adjustable t
			 )))
    (declare (double-float x y epsy epsx)
	     (fixnum nx  ny l)
	     (type (array double-float) ar))
    (sloop for j below ny
	   initially (setq y miny)
	   do (setq x minx)
	   (sloop for i below nx
		  do
		  (setf (x-pt ar l) x)
		  (setf (y-pt ar l) y)
		  (setf (z-pt ar l) (funcall f x y))
		  (incf l)
		  (setq x (+ x epsx))
		  )
	   (setq y (+ y epsy)))
    (make-polygon  ar  (make-grid-vertices nxint nyint))))

;; The following is 3x2 = 6 rectangles
;; call (make-vertices 3 2)
;; there are 4x3 = 12 points.
;; ordering is x0,y0,z0,x1,y1,z1,....,x11,y11,z11
;; ----
;; ||||
;; ----
;; ||||
;; ----

(defun make-grid-vertices (nx ny)
  (declare (fixnum nx ny))
  (let* ((tem (make-array (+ 15 (f* 5 nx ny)) :fill-pointer (f* 5 nx ny)
			  :adjustable t
			  :element-type '(mod  65000)))
	 (m  nx )
	 (nxpt (+ nx 1))
	 (i 0)
	 )
    (declare (fixnum i nxpt m)
	     (type (array (mod 65000))))
    (sloop for k below (length tem)
	   do
	   (setf (aref tem k) i)
	   (setf (aref tem (incf k))
		 (+ nxpt i))
	   (setf (aref tem (incf k))
		 (+ nxpt (incf i )))
	   (setf (aref tem (incf k)) i)
	   (setf (aref tem (incf k)) 0)	;place for max
	   (setq m (- m 1))
	   (cond ((eql  m 0)
		  (setq m nx)
		  (setq i (+ i 1))))
	   )
    tem))



(defun add-axes (pts vert)
  (let ((origin (/ (length pts) 3)))
    (sloop for i from -3 below 9
	   do
	   (vector-push-extend  (if (eql 0 (mod i 4)) $axes_length 0.0) pts))
    (sloop for i below 15
	   do (vector-push-extend
	       (if (eql 1 (mod i 5)) (+ origin (ceiling i 5))  origin)
	       vert)
	   )))
  
  
	 




(defun $rotation1 (phi th)
  (let ((sinph (sin phi))
	(cosph (cos phi))
	(sinth (sin th))
	(costh (cos th)))
    `(($MATRIX SIMP)
      ((MLIST SIMP) ,(* COSPH COSTH)
       ,(* -1.0 COSPH SINTH)
       ,SINPH)
      ((MLIST SIMP) ,SINTH ,COSTH 0.0)
      ((MLIST SIMP) ,(- (*  SINPH COSTH))
       ,(* SINPH SINTH)
       ,COSPH))))
   
; pts is a vector of bts [x0,y0,z0,x1,y1,z1,...] and each tuple xi,yi,zi is rotated
; also the *z-range* is computed.
(defun $rotate_pts(pts rotation-matrix)
  (or ($matrixp rotation-matrix) (error "second arg not matrix"))
  (let* ((rot *rot*)
	 (l (length pts))
	 (x 0.0) (y 0.0) (z 0.0)
	 )
    (declare (double-float  x y z))
    (declare (type (array double-float) rot))
    ($copy_pts rotation-matrix *rot* 0)
	
;    (setf (rot rot  0 0) (* cosphi costh))
;    (setf (rot rot  1 0) (- sinth))
;    (setf (rot rot 2 0) (* costh sinphi))
;
;    (setf (rot rot  0 1) (* cosphi sinth))
;    (setf (rot rot  1 1) costh)
;    (setf (rot rot 2 1) (* sinth sinphi))
;
;    (setf (rot rot  0 2) (- sinphi))
;    (setf (rot rot  1 2) 0.0)
;    (setf (rot rot 2 2) cosphi)

    (sloop with j = 0
	   while (< j l)
	   do
	   (setq x (aref pts j))
	   (setq y (aref pts (+ j 1)))
	   (setq z (aref pts (+ j 2)))
	   (sloop for i below 3 with a = 0.0
		  declare (double-float a)
		  do
		  (setq a (* x (aref rot (+ (* 3 i) 0))))
		  (setq a (+ a (* y (aref rot (+ (* 3 i) 1)))))
		  (setq a (+ a (* z (aref rot (+ (* 3 i) 2)))))
		  (setf (aref pts (+ j i )) a))
	   (setf j (+ j 3)))))


(defun $rotate_list (x)
  (cond ((and ($listp x) (not (mbagp (nth 1 x))))
         ($list_matrix_entries (ncmul*  $rot x)))
        ((mbagp x) (cons (car x) (mapcar '$rotate_list (cdr x))))))

	  

(defun $get_range (pts k &aux (z 0.0) (max most-negative-double-float) (min most-positive-double-float))
  (declare (double-float z max min))
  (declare (type (vector double-float) pts))
  (sloop for i from k below (length pts) by 3
	 do (setq z (aref pts i))
	 (cond ((< z min) (setq min z)))
	 (cond ((> z max) (setq max z))))
  (list min max (- max min)))


;; if this is '$polar_to_xy then the x y coordinates are interpreted as r theta

(defun add-ps-finish (opts)
  (p (if opts
	 "/xr .30 def
/xb 0.60 def
/xg .60  def
/myset { .018 mul dup xr add exch
 dup xb add exch
 xg add
setrgbcolor} def

/myfinish { myset  gsave fill grestore 0 setgray stroke  } def"

       "/myfinish {.9 setgray gsave fill grestore .1 setgray stroke  } def")))

(defun $draw_ngons(pts ngons number_edges &aux (i 0)(j 0) (s 0)
		       (opts *original-points*)
		       (maxz  most-negative-double-float))
  (declare (type (array double-float) pts opts)
	   (type (array (mod 64000)) ngons)
	   (fixnum number_edges i s j number_edges)
	   (double-float maxz))
  (setq j (length ngons))
  (add-ps-finish opts)
  (sloop while (< i j) 
	 do 
	 (sloop initially (setq s number_edges)
		do
		;(print-pt (aref pts (f* 3 (aref ngons i))))
		(print-pt (x-pt pts  (aref ngons i)))
		;(print-pt (aref pts (f+ 1 (f* 3 (aref ngons i)))))
		(print-pt (y-pt pts  (aref ngons i)))
		
		(cond (opts (if (> (z-pt opts (aref ngons i)) maxz)
			      (setq maxz (z-pt opts (aref ngons i))))))
		(cond ((eql number_edges s) (p " moveto %"
					       ;(aref pts (f+ 2 (f* 3 (aref ngons i))))
					       
					       ))
		      (t (p "lineto %" ;(aref pts (f+ 2 (f* 3 (aref ngons i))))
			    )))
		(setq i (f+ i 1))
		while (> (setq s (f- s 1)) 0))
	 (setq i (f+ i 1))
	 (cond (opts
		(p (f+ 1 (round ($* 10.0 ($/ ($- maxz (car *z-range*))
					  (or (third *z-range*)
					      ($- (second *z-range*) (car *z-range*))))))))
		(setq maxz most-negative-double-float)
		))
	 (p " myfinish")
	 ))








;; figure out the rotation to make pt the direction from which we view,
;; and to rotate z axis to vertical.
;; First get v, so p.v=0 then do u= p X v to give image of y axis
;; ans = transpose(matrix( v,u,p))

(defun $norm (pt) (sloop for v in (cdr pt) sum (* v v)))
(defun $length_one (pt)
  (let ((len (sqrt ($norm pt))))
    (cons '(mlist) (sloop for v in (cdr pt) collect (/  (lisp::float v 0.0d0) len)))))


(defun $cross_product (u v)
  (flet ((cp (i j)
	     (- (* (nth i u) (nth j v))
		(* (nth i v) (nth j u)))))
	`((mlist) ,(cp 2 3) ,(cp 3 1) ,(cp 1 2))))
	
(defun $GET_ROTATION (pt)
  (setq pt ($length_one pt))
  (let (v tem u)
    (cond ((setq tem (find 0.0 pt))
	   (setq v (cons '(mlist) (list 0.0 0.0 0.0)))
	   (setf (nth tem v) 1.0))
	  (t (setq v ($length_one `((mlist) ,(- (nth 2 pt))      , (nth 1 pt) 0.0)))))
    (setq u ($cross_product pt v))
    (let* (($rot   `(($matrix) ,v,u,pt))
	   (th (get-theta-for-vertical-z
		(nth 3 (nth 1 $rot))
		(nth 3 (nth 2 $rot)))))
      (or (zerop th)
	  (setq $rot (ncmul* ($rotation1 0.0 th)     $rot)))
      $rot)))

      

(defun get-theta-for-vertical-z (z1 z2)
  (cond ((eql z1 0.0) (if (> z2 0.0) 0.0  pi))
	(t (lisp::atan  z2 z1 ))))
    
    
    
  
;
;(defun $ps_axes ( ph th &optional (m 0.0))
;  (let ((tem (make-array 9 :element-type 'double-float)))
;    (setf (aref tem 0) 4.0)
;    (setf (aref tem 4) 4.0)
;    (setf (aref tem 8) 4.0)
;    (show tem)
;    ($rotate_pts tem 0.0  m)
;    ($rotate_pts tem ph 0.0)
;    ($rotate_pts tem 0.0 th)
;    (p 0 0 "moveto")
;    (p (aref tem 0) (aref tem 1) "lineto stroke")
;    (p  (aref tem 0) (aref tem 1) "moveto (x) show")
;    (p 0 0 "moveto")
;    (p (aref tem 3) (aref tem 4) "lineto stroke")
;    (p  (aref tem 3) (aref tem 4) "moveto (y) show")    
;    (p 0 0 "moveto")
;    (p (aref tem 6) (aref tem 7) "lineto stroke")
;    (p  (aref tem 6) (aref tem 7) "moveto (z) show")    
;))

(defun $ps_axes ( rot )
  (let ((tem (make-array 9 :element-type 'double-float)))
    (setf (aref tem 0) 4.0)
    (setf (aref tem 4) 4.0)
    (setf (aref tem 8) 4.0)
    ($rotate_pts tem rot)
    (p 0 0 "moveto")
    (p (aref tem 0) (aref tem 1) "lineto stroke")
    (p  (aref tem 0) (aref tem 1) "moveto (x) show")
    (p 0 0 "moveto")
    (p (aref tem 3) (aref tem 4) "lineto stroke")
    (p  (aref tem 3) (aref tem 4) "moveto (y) show")    
    (p 0 0 "moveto")
    (p (aref tem 6) (aref tem 7) "lineto stroke")
    (p  (aref tem 6) (aref tem 7) "moveto (z) show")    
    ))


;(defun example-sqrt-fun (r th)
;  (* (expt r .5) (cos (/ th 2))))

;;Plot of real(z^(1/2))
;($closeps)(let (($transform_xy '$polar_to_xy))(p "/show {pop} def") ($plot3d 'example-sqrt-fun #$[1,1,1.4]$ #$[0.0,1.0,0.0,4*3.14]$ #$[12,80]$))

;;Plot of real(z^(1/3))
;($closeps)(let (($transform_xy '$polar_to_xy))(p "/show {pop} def") ($plot3d #'(lambda (r th)(* (expt r .3333)(cos (/ th 3))))  #$[1,1,1.4]$ #$[0.0,1.0,0.0,6*3.14]$ #$[12,80]$))
;($closeps)(let (($colour_z t)($transform_xy '$polar_to_xy))(p "/show {pop} def") ($plot3d #'(lambda (r th)(* (expt r .3333)(cos (/ th 3))))  #$[1,1,1.4]$ #$[0.0,1.0,0.0,6*3.14]$ #$[12,80]$))


(defun $plot3d (f &optional viewdir  ptrange  ticks  (rot ($get_rotation viewdir))
		  &aux ($transform_xy $transform_xy)
		  ($numer t))
  (setq ptrange (meval* ptrange))
  (setq viewdir (meval* viewdir))
  (setq f (coerce-float-fun f))
  (flet  ((get-default (item dflt leng)
		       (let ((ans (or item dflt)))
			 (or (and ($listp ans)
				  (eql ($length ans) leng))
			     (error "~a is wrong type or length" ans))
			 (if (> leng 2)
			     (setq ans (cons (car ans)
				             (mapcar #'(lambda (x) (lisp::float x 0.0d0))
					             (cdr ans)))))
			 ans)))
    (setq viewdir (get-default viewdir $view_direction 3))
    (setq ptrange (get-default ptrange $pt_range 4))
    (setq ticks (get-default ticks  $plot_ticks 2)))
  (assert ($matrixp rot))
  (let ((pl (apply 'draw3d f
		    (cdr ($append ptrange ticks))))
	*original-points*)
    (assureps)
    (if $transform_xy (mfuncall $transform_xy (polygon-pts pl)))
    (cond ($colour_z
	   (setq *original-points* (copy-seq (polygon-pts pl)))
	   (setq *z-range* ($get_range (polygon-pts pl) 2))))
    ($rotate_pts (polygon-pts pl) rot)
    (sort-ngons (polygon-pts pl) (polygon-edges pl) 4 )
    ($ps_axes rot)
    ($draw_ngons (polygon-pts pl) (polygon-edges pl) 4 )
    (p "[.1] 0 setdash")    ($ps_axes rot)    (p "[] 0 setdash")
    ))



(defun $polar_to_xy (pts &aux (r 0.0) (th 0.0))
  (declare (double-float r th))
  (declare (type (array double-float) pts))
  (assert (typep pts '(vector double-float)))
  (sloop for i below (length pts) by 3
	 do (setq r (aref pts i))
	 (setq th (aref pts (f+ i 1)))
	 (setf (aref pts i) (* r (cos th)))
	 (setf (aref pts (f+ i 1)) (* r (sin th)))))



;; return a function suitable for the transform function in plot3d.
(defun $make_transform (lvars fx fy fz )
  (declare (type (array double-float) pts))
  (setq fx (symbol-function (coerce-float-fun fx lvars)))
  (setq fy (symbol-function (coerce-float-fun fy lvars)))
  (setq fz (symbol-function (coerce-float-fun fz lvars)))
  (let ((sym (gensym "transform")))
    (setf (symbol-function sym)
  #'(lambda (pts &aux  (x1 0.0)(x2 0.0)(x3 0.0))
      (declare (double-float  x1 x2 x3))      
      (sloop for i below (length pts) by 3
	     do
	 (setq x1 (aref pts i))
	 (setq x2 (aref pts (f+ i 1)))
	 (setq x3 (aref pts (f+ i 2)))
	 (setf (aref pts i) (funcall fx x1 x2 x3))
	 (setf (aref pts (f+ 1 i)) (funcall fy x1 x2 x3))
	 (setf (aref pts (f+ 1 2)) (funcall fz x1 x2 x3)))))))


(defun coerce-float-fun (expr &optional lvars)
  (cond ((and (consp expr) (functionp expr))
	 expr)
	((symbolp expr)
	 (cond ((fboundp expr) expr)
	       (t (mfuncall '$translate expr) expr)))
	(t
	 (let ((vars (or lvars ($sort ($listofvars expr))))
	       (na (gensym "TMPF")))
	   (when (and (eql (length vars) 2)
		      (member '$r vars))
		 (setq $transform_xy  '$polar_to_xy )
		 (format t "Using polar coordinates"))
	 (meval* `((MDEFINE SIMP) ((,na) ,@(cdr vars))
		     ((MPROGN) (($MODEDECLARE) ,vars  $FLOAT)
		      ,expr)))
	 (coerce-float-fun na)))))
	   
(defun $concat_polygons (pl1 pl2 &aux tem new)
  (setq new
	  (sloop for v in pl1 
		 for w in pl2
		 for l = (+ (length v) (length w))
		 do (setq tem (make-array l
					  :element-type (array-element-type v)
					  :fill-pointer  l
					  )
			  )
		 collect tem))
  (setq new (make-polygon (first new) (second new)) )

  #+kcl
  (si::copy-array-portion (polygon-pts pl1) (polygon-pts new)
			  0 0 (length (polygon-pts pl1)))
  #-kcl
  (sloop for i from 0 below (length (polygon-pts pl1))
         with ar1 = (polygon-pts pl1)
         with arnew = (polygon-pts new)
         do (setf (aref arnew i) (aref ar1 i)))
  #+kcl
  (si::copy-array-portion (polygon-pts pl2) (polygon-pts new)
			  (length (polygon-pts pl1))
			  0 (length (polygon-pts pl2)))
  #-kcl
  (sloop for i from 0 below (length (polygon-pts pl2))
         with j = (length (polygon-pts pl1))
         with ar2 = (polygon-pts pl2)
         with arnew = (polygon-pts new)
         do (setf (aref arnew (+ i j)) (aref ar2 i)))
  #+kcl
  (si::copy-array-portion (polygon-edges pl1) (polygon-edges new)
			  0 0 (length (polygon-edges pl1)))
  #-kcl
  (sloop for i from 0 below (length (polygon-edges pl1))
         with ar1 = (polygon-edges pl1)
         with arnew = (polygon-pts new)
         do (setf (aref arnew i) (aref ar1 i)))
  (sloop for i from (length (polygon-edges pl1))
	 for j from 0 below (length (polygon-edges pl2))
	 with  lpts1  =  (length (polygon-pts pl1))
	 with ar2   =  (polygon-edges pl2)
	 with arnew =  (polygon-edges new)
	 do (setf (aref arnew i) (f+ lpts1 (aref ar2 j)))))

(defun $copy_pts(lis vec start)
  (declare (fixnum start))
  (let ((tem vec))
    (declare (type (array double-float) tem))
    (cond ((numberp lis)
	   (or (typep lis 'double-float) (setq lis (lisp::float lis 0.0d0)))
	   (setf (aref tem start) lis)
	   
	   (+ start 1))
	  ((typep lis 'cons)
	   ($copy_pts (cdr lis) vec  ($copy_pts (car lis) vec start)))

	  ((symbolp lis) start)
	  (t (error "bad lis")))))
  

;; arrange so that the list of points x0,y0,x1,y1,.. on the curve
;; never have abs(y1-y0 ) and (x1-x0) <= deltax 

(defun draw2d (f range &optional deltax)
  (setq f (coerce-float-fun f))
  (let* ((x (lisp::float (nth 1 range) 0.0d0))
	 (xend (lisp::float (nth 2 range) 0.0d0))
	 (eps (if deltax (lisp::float deltax 0.0d0)
		($/ (- xend x) 100.0)))
	 (x1 x)
	 (y1 0.0)
	 (y (funcall f x))
	 (dy 0.0)
	 (eps2 (* eps eps))
	 )
    (declare (double-float x1 y1 x y dy eps2 eps ))
    (cons '(mlist)
	  (sloop   do (setq x1 (+ eps x))
		  (setq y1 (funcall f x1))
		  (setq dy (- y1 y))
		  (cond ((< dy 0)
			 (setq dy (- dy))
			 (cond ((> dy eps)
				(setq x1 (+ x (/ eps2 dy)))
				(setq y1 (funcall f x1))))))
		  (setq x x1)
		  (setq y y1)
		  collect x1 collect y1
		  when (>= x xend)
		  collect xend and collect (funcall f xend)
		  and do (sloop::loop-finish)))))


(defun get-range (lis)
  (let ((ymin most-positive-double-float)
	(tem 0.0)
	(ymax most-negative-double-float))
    (declare (double-float ymin ymax))
    (do ((l lis (cddr l)))
	((null l))
      (cond (($<   (car l)ymin)
	     (setq ymin (car l))))
      (cond (($<  ymax  (car l))
	      (setq ymax (car l)))))
    (list '(mlist) ymin ymax)))


(defun $getrange(x &optional xrange &aux yrange)
  (setq yrange  (get-range (cddr x)))
  (or xrange (setq xrange (get-range (cdr x))))
    (let* ((cy (/ (+ (nth 2 yrange) (nth 1 yrange)) 2.0))
	   (CX (/ (+ (nth 2 xrange) (nth 1 xrange)) 2.0))
	   (scaley (/ (nth 2 $window_size)
		      (* 1.2  (- (nth 2 yrange) (nth 1 yrange)))))
	   (scalex (/ (nth 1 $window_size)
		      (* 1.2 (- (nth 2 xrange) (nth 1 xrange)))))
	   ($ps_scale
	     (progn
	       (cond ((< scalex scaley)
			   (setq scaley scalex)))
		    `((mlist) , scaley ,scaley)))
	   ($ps_translate `((mlist) , CX ,CY)))
      (ASSUREPS)))
      
 
(defun $paramplot (f g range &optional (delta .1) &aux pts ($numer t))
  (setq f (coerce-float-fun f))
  (setq g (coerce-float-fun g))
  (setq range (meval* range))
  (setq pts(cons '(Mlist)
		 (sloop with tt = (lisp::float (nth 1 range) 0.0d0)
		    with end = (lisp::float (nth 2 range) 0.0d0)
		    while ($< tt end)
		    collect (funcall f tt)
		    collect (funcall g tt)
		    do (setq tt ($+ tt delta)))))
  ($closeps)
  ($getrange pts)
  ($psdraw_curve pts)
  ($closeps)
  ($viewps))

	 
	 
  
  
(defun $plot2d(&rest l &aux ($numer t))
  (setq l (copy-list l))
  (setf (second l)  (meval* (second l)))
  (let ((tem (apply 'draw2d l))
	(range (second l))
	)
    ($closeps)
    ($getrange tem (SECOND L))
    ($psdraw_curve tem)
    ($psaxes range)
    (p "showpage")
    ($viewps)))


(defun $plot2d_xgraph(&rest l &aux ($numer t) ll $display2d)
  (setq l (copy-list l))
  (setf (second l)  (meval* (second l)))
  (or ($listp (car l)) (setf (car l) `((mlist) ,(car l))))
  (with-open-file (st  "xgraph-out" :direction :output)  
  (dolist (v (cdar l))
    (setq ll (cons v (cdr l)))
    (format st "~%~% \"~a\"~%" (coerce (mstring (car ll)) 'string))
    (let ((tem (apply 'draw2d ll))
	  (range (second ll))
	  )
      (sloop for (v w) on (cdr tem) by 'cddr
	 do (format st "~,3f ~,3f ~%" v w))))
      
  (#+kcl system #+CLISP shell "xgraph -t 'Maxima Plot' < xgraph-out &")))



(defun average-slope (m1 m2)
  (tan ($/ ($+ (lisp::atan m1) (lisp::atan m2)) 2.0)))

(defun slope (x1 y1 x2 y2 &aux (del ($- x2 x1)))
  (declare (double-float x1 y1 x2 y2 del))
  (cond ((eql del 0.0)
	 #. (expt 10 30))
	(t ($/ ($- y2 y1) del))))

		   
  
	  
	   
;(defun $pscurve (lis &aux (current-slope 0.0) (slope-end 0.0)(x0 0.0)(y0 0.0))
;  (declare (double-float current-slope slope-end x0 y0))
;  (assert ($listp lis))
;  (setq lis (cdr lis))
;  (cond ((numberp (car lis)))
;	((and ($listp (car lis)) (numberp (nth 1 (car lis))))
;	 (setq lis (sloop for w in lis collect
;			  (nth 1 w)
;			  collect (nth 2 w))))
;	(t (error "pscurve:Neither [x0,y0,x1,y1,...] nor [[x0,y0],[x1,y1],...]")))
;  (sloop for v on lis do (setf (car v) (lisp::float (car v) 0.0d0)))
;  (let ((len (length lis)))
;    (assert (and (evenp len)
;		 (>= len 8 ))))
;  ($moveto (car lis) (second lis))
;  (setq current-slope (slope (nth 0 lis)
;			     (nth 1 lis)
;			     (nth 2 lis)
;			     (nth 3 lis)))
;  (setq x0 (car lis))
;  (setq y0 (second lis))
;  (setq lis (cddr lis))
;  (sloop while (nthcdr 5 lis)
;	 with prev
;	 do
;	 (let ((x1 (pop lis))
;	       (y1 (pop lis))
;	       (x2 (pop lis))
;	       (y2 (pop lis))
;	       (x3 (pop lis))
;	       (y3 (pop lis)))
;	   (setq slope-end (slope x2 y2 x3 y3))
;	   (cond (lis
;		  (setq slope-end (average-slope
;				   slope-end
;				   (slope x3 y3 (nth 0 lis) (nth 1 lis))))
;		  (setq x2 ($+  x3 -.01)
;			y2 ($+ y3 (* slope-end -.01)))))
;	   (setq x1 ($+ x0 .01)
;		 y1 ($+ y0 ($* current-slope .01)))
;	   (p x1 y1 x2 y2 x3 y3 "curveto")
;	   (setq current-slope slope-end)
;	   (setq x0 x3)
;	   (setq y0 y3)
;	   )
	 
;	 ))



	   
		
		
  

	   
    
    
	  
	  

	   
	   
		  
		  
  


#|
Here is what the user inputs to draw the lattice picture.

/*Initially 1 unit = 1 pt = 1/72 inch
This makes 1 unit be 50/72 inch
*/
ps_scale:[50,50];

/*This moves the origin to 400/72 inches up and over from bottom left corner
[ie roughly center of page]
*/
ps_translate:[8,8];


f(x):=if (x = 0) then 100  else 1/x;

foo():=block([],
closeps(),
ps_translate:[6,6],
ps_scale:[50,50],
psdraw_curve(join(xcord,map(f,xcord))),
psdraw_curve(join(-xcord,map(f,xcord))),
psdraw_curve(join(xcord,-map(f,xcord))),
psdraw_curve(join(-xcord,-map(f,xcord))),
psdraw_points(lattice),
psaxes(8));


And here is the output .ps file which you should be
able to print on a laserwriter, or view on screen if you have
ghostscript (or another postscript screen previewer).

|#

;;When we initialize we move the origin to the middle of $window_size
;;Then to offset from that use translate.
(defvar $ps_translate '((mlist) 0 0))

;; initially 1/72 of inch is the scale
(defvar $ps_scale '((mlist) 72  72))

(eval-when (compile eval)
 (defmacro coerce-float (x)
   `(lisp::float x 0.0d0))
  )

(defun $pscom (&rest l)
  (apply 'p l))
;-10 to 10
(defun psx (x) x)
(defun psy (y) y)

(defun p (&rest l)
  (assureps)
  (sloop for v in l do
	 (if (symbolp v) (setq v (maxima-string v)))
	; (if (numberp v) (setq v (* 70 v)))
	 (cond ((consp v)
		(sloop for w in (cdr v) do (p w)))
	       ((floatp v) (format $pstream "~,4f" v))
	       (t(princ v $pstream)))
	  (princ " " $pstream))
  (terpri $pstream))

(defun psapply (f lis)
  (if ($listp lis) (setq lis (cdr lis)))
  (apply 'p lis)
  (p f))

(defun $moveto (x y)
  (p (psx x) (psy y) "moveto ")) 

(defun $join (x y)
  (cons '(mlist)(sloop for w in (cdr x) for u in (cdr y)
		       collect w collect u)))

(defun $psline (a b c d)
  (p (psx a) (psy b) "moveto ")
  (p  (psx c) (psy d) "lineto"))

(defvar $window_size '((mlist)
		       #.(* 8.5 72) #. (* 11 72) ))

(defun assureps ()
  (unless (streamp $pstream)
	  (setq $pstream (open "maxout.ps" :direction :output))
	  (p "%!")
	  (p  (* .5 (nth 1 $window_size))
	     (* .5 (nth 2 $window_size))
	     "translate"
	     )
	  (psapply "scale" $ps_scale)
	  (p  (- (nth 1 $ps_translate))
	     (- (nth 2 $ps_translate))
	     "translate"
	     )
	  (p " 1.5 " (second $ps_scale) "div setlinewidth
/Helvetica findfont 14 " (second $ps_scale) " div scalefont setfont
/dotradius .05 def
/drawdot {
 /yy exch def
 /xx exch def
  gsave
  xx yy dotradius 0 360 arc
  fill
  grestore
}def

/ticklength  .03 def
/axiswidth  .01 def
/drawtick {
 /yy exch def
 /xx exch def
  gsave
  xx ticklength sub yy moveto
  xx ticklength add yy lineto
  stroke	
  xx yy  ticklength sub  moveto
  xx yy  ticklength add  lineto
  stroke
  grestore
} def
")))

(defun $closeps ()
  (prog1
      (when (and (streamp $pstream)
		 (#+kcl si::fp-output-stream #-kcl output-stream-p $pstream))
	        (p "showpage")
		(close  $pstream))
    (setq $pstream nil)))


	
(defun ps-fixup-points(lis)
  (assert ($listp lis))
  (setq lis (cdr lis))
  (cond ((numberp (car lis)))
	((and ($listp (car lis)) (numberp (nth 1 (car lis))))
	 (setq lis (sloop for w in lis collect
			  (nth 1 w)
			  collect (nth 2 w))))
	(t (error
	    "pscurve:Neither [x0,y0,x1,y1,...] nor [[x0,y0],[x1,y1],...]")))
  lis)
;
;(defun $pscurve (lis &aux tem)
;  (setq lis (ps-fixup-points lis))
;  (let ((len (length lis)))
;    (assert (and (evenp len)
;		 (>= len 8 ))))
;  ($moveto (car lis) (second lis))
;  (setq lis (cddr lis))
;  (sloop while (setq tem (nthcdr 5 lis))
;	 do (p (psx (nth 0 lis))
;	       (psy (nth 1 lis))
;	       (psx (nth 2 lis))
;	       (psy (nth 3 lis))
;	       (psx (nth 4 lis))
;	       (psy (nth 5 lis))
;	       "curveto ")
;	 (setq lis (cdr tem))
;	 ))

(defun $psdraw_curve (lis &aux (n 0))
  (declare (fixnum n))
  (setq lis (ps-fixup-points lis))
  (p "newpath" (nth 0 lis) (nth 1 lis) "moveto")
  (sloop while lis with second
     do
     (or (setq second (cadr lis)) (error "odd length list of points"))
     (cond ((eql n 0)
	    (p (car lis) second "moveto"))
	   (t  (p (car lis) second "lineto")
	       ))
     (setq n (+ n 1))
     (cond ((eql 0 (mod n 20))
	    (p "stroke")
	    (setq n 0))
	   (t (setq lis (cddr lis)))))
  (or (eql n 0) (p "stroke")))



(defvar $viewps_command  "(gs -I. -Q  ~a)")

(defvar  $viewps_command "echo /def /show {pop} def |  cat - ~a | x11ps")

;; If your gs has custom features for understanding mouse clicks


;;Your gs will loop for ever if you don't have showpage at the end of it!!
(defvar $viewps_command   "echo '/showpage { .copypage readmouseclick /ke exch def ke 1 eq { erasepage initgraphics} {ke 5 ne {quit} if} ifelse} def  {(~a) run } loop' | gs  -title 'Maxima  (click left to exit, middle to redraw)' > /dev/null 2>/dev/null &")

	;; allow this to be set in a system init file (sys-init.lsp)

(defun $viewps ( &optional file)
  (cond  ((and (streamp $pstream)(#+kcl si::fp-output-stream #-kcl output-stream-p $pstream))
	  ($pscom "showpage")
	  (force-output $pstream)))
  (cond (file (setq file (maxima-string file)))
	(t(setq file "maxout.ps")
	 
	 (if (and (streamp $pstream)(#+kcl si::fp-output-stream #-kcl output-stream-p $pstream))
	     (force-output $pstream))))
  (if (equal $viewps_command "(gs -I. -Q  ~a)")
        (format t "~%type `quit' to exit back to affine or maxima
  To reprint a page do
  GS>showpage
  GS>(maxout.ps)run
  GS> -150 -150 translate 1.2 1.2 scale (maxout.ps)run
  would print it moved 150/72 inches to left, and down, and scaled by 1.2 times
  showpage clears scaling."))

  (#+kcl system #+CLISP shell   (format nil $viewps_command file)))

(defun $chkpt (a)
  (or (and ($listp a)
       (numberp (nth 1 a))
       (numberp (nth 2 a)))
      (error "illegal pt ~a" a))
  t)
       
       
       
(defvar $pslineno nil)
(defun $psdrawline (a &optional b c d)
  (cond ((null b)
	 (assert (and ($listp a)
		      ($chkpt (nth 1 a))))
	 (setq b (nth 2 a))
	 (setq a (nth 1 a))))
  (cond ((null c)
	 ($chkpt b)
	 (setq c (nth 1 b))
	 (setq d (nth 2 b))))
  (cond (($listp a)
	 (setq b (nth 2 a) a (nth 1 a))))
  (cond ((null c)
	 (setq c (nth 1 b))
	 (setq c (nth 2 b))))

  (when $pslineno
      (incf $pslineno)
      ($pslabelline a b c d $pslineno))
      
  (p a b "moveto")
  (p c d "lineto")
  (p "stroke"))

(defun $pslabelline (a b c d $pslineno)
   (p (/ (+ a c) 2)
      (/ (+ b d) 2)
      "moveto"
      (format nil "(<--L~a)show" $pslineno)))

(defun $sort_polys (lis)
  (let ((tem
	 (sloop for v in (cdr lis)
		collect (cons
			 (sloop for w in (cdr v)
				maximize (nth 3 w))
			 v))))
    (print 'next)
    (cons '(mlist) (mapcar 'cdr (sortcar tem '<)))))


(defun $drawpoly (x)
  (p "gsave")
  (p (cdadr x) "moveto")
  (setq x (cddr x))
  (sloop for edge in x
	 do (p (cdr edge) "lineto")
	 finally (p "1 setgray fill"))
  ($psdrawline x)
  (p "grestore"))

(defun $psdrawpolys (polys)
  (dolist (v (cdr polys))
	  ($drawpoly v)))

		   
	  
  


   
      
      

;; draw the axes through $psdef
(defun $psaxes (leng &optional (lengy leng))
  (p "gsave axiswidth setlinewidth")
  (let (begx begy endx endy)
    (cond ((numberp leng)
	   (setq begx (- leng))
	   (setq endx leng))
	  (t (setq begx (nth 1 leng))
	     (setq endx (nth 2 leng))))
    (cond ((numberp lengy)
	   (setq begy (- lengy))
	   (setq endy lengy))
	  (t (setq begy (nth 1 lengy))
	     (setq endy (nth 2 lengy))))

    (sloop for i from (floor begx) below (ceiling endx)
	   do 
	   ($psdrawline i 0 (+ i 1) 0)
	   (p i 0 "drawtick")
	   (p (+ i 1) 0 "drawtick"))

    (sloop for i from (floor begy) below (ceiling endy)
	   do
	   ($psdrawline 0 i 0 (+ i 1) )
	   (p 0 i "drawtick")
	   (p 0 (+ i 1)  "drawtick"))

  
    (p "grestore")))
  


(defun $psdraw_points(lis)
    (assert (and ($listp lis)
		 ($listp (cadr lis))))
    (sloop for w in (cdr lis)
	   do (p (nth 1 w)
		 (nth 2 w)
		 "drawdot")))





  

  

  


