
/* Copyright (C) 1993 Free Software Association of Germany

   The following is only valid, if you use this program outside
   the Federal Republic of Germany.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   If you don't have a a copy of the GNU General Public License
   write to the Free Software Foundation, Inc., 675 Mass Ave, 
   Cambridge, MA 02139, USA.

   ----------------------------------------------------------------

   Fuer die Nutzung dieses Programms innerhalb der Bundesrepublik
   Deutschland gilt:

   Dieses Programm ist freie Software und kann unter den Bedingungen
   der Deutschen Free Software Lizenz weitergeben und/oder modifiziert
   werden.

   Wir haben dieses Programm in der Hoffnung entwickelt, dass es
   sich als nuetzlich erweist. Wir uebernehmen jedoch *KEINERLEI*
   Garantien auf die Funktion oder Verwendbarkeit dieses Programms.
   Der Anwender nutzt dieses Programm * AUF EIGENES RISIKO *

   Diesem Programm sollte eine Kopie der Deutschen Free Software Lizenz
   (DFSL) beigefuegt sein. Falls nicht, kann eine Kopie von uns angefordert
   werden: Free Software Association of Germany, Heimatring 19,
   60596 Frankfurt (fsag@eurom.fsag.rhein-main.de)

   (C)opyright 1993 FREE SOFTWARE ASSOCIATION OF GERMANY */

#include <stdio.h>
#include <sys/types.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/signal.h>
#include <errno.h>
#include <fcntl.h>

#undef TLOG

#ifdef TLOG
#include "tlog.h"
#else
#include <syslog.h>
#endif

mstrcmp(s1,s2)
char s1[],s2[];
{
	char *ss;

	if (strlen(s2) < strlen(s1))
		return (0);

	ss = (char *)malloc (strlen(s2)+1);
	if (ss == NULL)
		return (0);
	strcpy(ss,s2);
	ss[strlen(s1)] = 0;
	if (!strcasecmp(s1,ss))	{
		free(ss);
		return (1);
		}
	free(ss);
	return (0);
}

mstrstr(char *kurz,char *lang)
{
	int a,b;

	a = strlen(lang) - strlen(kurz);
	if (a < 0)
		return(-1);

	for (b = 0; b <= a+1; b++)	{
		if (mstrcmp(kurz,&lang[b]))
			return(b);
		}
	return (-1);
}


main(argc,argv)
int argc;
char **argv;
{
	struct in_addr adress;
	int a;
	struct sockaddr_in	cli_addr;
	struct hostent	*hp;
	unsigned long ip_addr;
	int	hd,ch, addrlen;
	char inc[100];
	char *param[30];
	char ip[100];
	char na[100];

	strcpy(ip,"0.0.0.0");
	strcpy(na,"$$UNKNOWN$$");
	strcpy(inc,"Unknown service");

	for (a = 0; a < 30; a++)
		param[a] = (char *) NULL;

	for (a = 2; a < argc; a++)
		param[a-2] = argv[a];

	if (argc > 1)	{
		strcpy(inc,argv[1]);
		if (!strcmp(argv[1],"-d"))
			test_con();
		}

#ifdef TLOG			
	open_tlog("netkey");		
#else
	openlog("netkey",LOG_CONS,LOG_USER);
#endif

	addrlen = sizeof(cli_addr);
	if (getpeername(0, &cli_addr, &addrlen) < 0)	{
#ifdef TLOG
		tlog(1,"%s, can't get peername of host",inc);
#else
		syslog(LOG_NOTICE|LOG_USER,"%s, can't get peername of host",inc);
		closelog();
#endif
		exit(3);
		}
	adress.s_addr = cli_addr.sin_addr.s_addr;
	strcpy(ip,inet_ntoa(adress));
	hp = gethostbyaddr((char *) &cli_addr.sin_addr,sizeof(struct in_addr),cli_addr.sin_family);
	if (hp)	
		strcpy(na,hp->h_name);
	else
		strcpy(na,ip);

	if(read_config(0,inc,ip,na) == 0)	{
#ifdef TLOG
		tlog(1,"request: %s from %s (%s) denied",inc,na,ip);
		close_tlog();
#else
		syslog(LOG_WARNING|LOG_USER,"request: %s from %s (%s) denied",
			inc,na,ip);
		closelog();
#endif
		exit(1);
		}
#ifdef TLOG
	tlog(1,"request: %s from %s (%s) accepted",inc,na,ip);
	close_tlog();
#else
	syslog(LOG_WARNING|LOG_USER,"request: %s from %s (%s) accepted",
			inc,na,ip);
	closelog();
#endif
	execv(argv[1],param);
}


get_host_ip(char *s,char *o)
{
	struct in_addr adress;
	struct hostent *hp;
	struct sockaddr_in	ma_addr;
	unsigned long ip_addr;

	bzero(( char *) &ma_addr, sizeof(ma_addr));

	if (( hp = gethostbyname(s)) == NULL)
			return (-3);	
	bcopy(hp->h_addr, (char *) &ma_addr.sin_addr,
			hp->h_length);
	adress.s_addr = ma_addr.sin_addr.s_addr;
	strcpy(o,inet_ntoa(adress));
/*	tlog(1,"Secure IP: %s",o); */
	return(0);
}


read_config(int md,char *serv,char *nu,char *na)
{
	FILE *fp;
	int su = 0;
	char tmp[200];
	char out[200];
	int defalt = 0;
	int ok = -1;

	if (md)
		printf("+ Setting all services to NO of not listed\n");


	fp = fopen("/etc/netkey.conf","r");
	if (fp == NULL)	{
		if (!md)
#ifdef TLOG
			tlog(1,"Can't open config.file");
#else
			syslog(LOG_ERR|LOG_USER,"Can't open config file");
#endif
		else
			printf("netkey: Can't open config.file\n");
		exit(0);
		}

	while(fgets(tmp,100,fp) != NULL)	{
		if (tmp[0] == 10 || tmp[0] == '#')
			continue;
		strip_all(tmp);

		if (!strcmp(tmp,"+all"))	{
			if (md)
				printf("+ found +all: setting all service default to YES\n");			
			defalt = 1;
			continue;
			}

		if (!strcmp(tmp,"-all"))	{
			if (md)
				printf("+ found -all: setting all service default to NO\n");
			defalt = 0;
			continue;
			}

		if (mstrcmp("-all",tmp))	{
			if (joker(na,&tmp[5]))	{
				if (md)
					printf("+ switching global to NO <%s> = <%s>\n",na,&tmp[5]);
				defalt = 0;
				continue;
				}
			if (md)
				printf("no match  <%s> != <%s>\n",na,&tmp[5]);
			}

		if (mstrcmp("+all",tmp))	{
			if (joker(na,&tmp[5]))	{
				if (md)
					printf("+ switching global to YES <%s> = <%s>\n",na,&tmp[5]);
				defalt = 1;
				continue;
				}
			if (md)
				printf("no match  <%s> != <%s>\n",na,&tmp[5]);
			}

		if (tmp[0] == '*')	{
			if (su)
				break;
			if (!strcmp(&tmp[1],serv))	{
				if (md)
					printf("+ found service <%s>\n",serv);
				su = 1;
				}
			continue;
			}
		if (!su)
			continue;
		if (!strcmp(tmp,"+default"))	{
			if (md)
				printf("+ switching default for %s to YES\n",serv);
			defalt = 1;
			continue;
			}

		if (!strcmp(tmp,"-default"))	{
			if (md)
				printf("+ switching default for %s to NO\n",serv);
			defalt = 0;
			continue;
			}

		if (mstrcmp(":print",tmp))	{
			if (md)	
				printf("+ sending <%s>",&tmp[7]);
			sprintf(out,"%s\r\n",&tmp[7]);
			write(1,out,strlen(out));
			continue;
			}

		if (mstrcmp("+r",tmp))	{
			if (joker(na,&tmp[3]))	{
				if (md)
					printf("+ switching to YES <%s> = <%s>\n",na,&tmp[3]);
				ok = 1;
				continue;
				}
			if (md)
				printf("+ no match <%s> != <%s>\n",na,&tmp[3]);
			}

		if (mstrcmp("-r",tmp))	{
			if (joker(na,&tmp[3]))	{
				ok = 0;
				if (md)
					printf("+ switching to NO <%s> = <%s>\n",na,&tmp[3]);
				continue;
				}
			if (md)
				printf("no match  <%s> != <%s>\n",na,&tmp[3]);
			}

		if (mstrcmp("+",tmp))	{
			if (joker(nu,&tmp[2]))	{
				ok = 1;
				if (md)
					printf("+ switching to YES <%s> = <%s>\n",nu,&tmp[2]);
				continue;
				}
			if (md)
				printf("+ no match <%s> != <%s>\n",nu,&tmp[2]);
			}

		if (mstrcmp("-",tmp))	{
			if (joker(nu,&tmp[2]))	{
				ok = 0;
				if (md)
					printf("+ switching to NO <%s> = <%s>\n",nu,&tmp[2]);
				continue;
				}
			if (md)
				printf("+ no match <%s> != <%s>\n",nu,&tmp[2]);
			}
		}
	if (ok >= 0)
		return (ok);
	return(defalt);
}

joker(char *x1,char *x2)
{
	char tsk[200];
	char tsl[200];
	char tst[200];
	char s1[1024];
	char s2[1024];
	int a;

	strcpy(s1,x1);
	strcpy(s2,x2);

	for (a = 0; a < strlen(s1); a++)
		s1[a]=tolower(s1[a]);

	for (a = 0; a < strlen(s2); a++)
		s2[a]=tolower(s2[a]);



	if (s2[0] != '*' && s2[strlen(s2)-1] != '*')	{
		/* Exact matching */
		if (!strcasecmp(s2,s1))
			return (1);
		return (0);
		}

	if (s2[strlen(s2)-1] == '*')	{
			/* Right hand star */
		s2[strlen(s2)-1] = 0;
		if (strlen(s2) > strlen(s1))
			return(0);
		if (mstrcmp(s2,s1))
			return(1);
		return(0);
		}

	if (s2[0] == '*')	{
			/* Left hand star */
		strcpy(tst,&s2[1]);
		if (strlen(tst) > strlen(s1))
			return (0);
		if (!strcasecmp(&s1[strlen(s1)-strlen(tst)],tst))
			return(1);
		return(0);
		}
	return (0);
}

test_con()
{
	int a;
	char ip[100];
	char na[100];
	char se[100];

	printf("Enter IP-Number: ");
	fflush(stdout);
	gets(ip);
	printf("Enter Sys-Name : ");
	fflush(stdout);
	gets(na);
	printf("Enter Service  : ");
	fflush(stdout);
	gets(se);
	a = read_config(1,se,ip,na);
	if (a == 0)
		printf("+ Access denied for %s (%s) and service %s\n",
			na,ip,se);
	else
		printf("+ Access ok for %s (%s) and service %s\n",
			na,ip,se);
	exit(0);
}

strip_all(char *s)
{
	int a;

	s[strlen(s)-1] = 0;

	for (a = 0; a < strlen(s); a++)	{
		if (s[a] == '#')	{
			s[a] = 0;
			break;
			}
		}		

	for (a = strlen(s); a > 0; a--)	{
		if (s[a] == '#' || s[a] == 0 || s[a] == ' ' || s[a] == 9)
			continue;
		break;
		}
	s[++a] = 0;
}

