/***
 *** configfile.h: funtions to process config file
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#ifndef _CONFIGFILE_H
#define _CONFIGFILE_H

/* bitmasks for label options */
#define LABEL_REQUIRED   1
#define LABEL_FROMSTART  2
#define LABEL_LAST       4

#define LABEL_OPTIONAL  0
#define LABEL_FROMCURRENT  0

void cleanupstring(char *tstring);

char* findlabel(FILE* inputfile, char* reqlabel, int options);

FILE* open_param_file(char* conf_file);

char* showopts(const char* optstrings[], int num_optstrings);

int findoption(char* inputstr, const char* optstrings[], int num_optstrings, char* optiontype);

void check_int_range(int cvalue, int lmin, int lmax, char* descstr);

int getbyte(char* instring, char* descrstring, int lmin, int lmax);

float getfloat(char* instring, char* descrstring, int lmin, int lmax);

int GetPathOption(FILE *param_file, char *optionstring, int label_config, char *path);

void ParseFontXY(char *inputstr, int *x, int*y);

void Run_extern_Prog(char *description, char *commandstring, char *arguments);

void check_bounds_realtime(FILE *param_file, char *descrline, float checkval, float defaultmin, float defaultmax, char *textdescr);


#endif

