/*
	Copyright (c) Frank Klemm 1992. All Rights reserved.
	Frank.Klemm@HpUx.Rz.Uni-Jena.De

	Ported to linux 5 Feb 93 
	  Ray Balister - balister@cebaf.gov
	Changed to run for the SPEA Mercury PCI 2MB VRAM on 4 Feb 95
	  Andreas Beck - becka@hp.rz.uni-duesseldorf.de
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "set.h"

/*
	An example of an program for DOS. It sets the pixel clock to the given
	value.
*/

#define TRUE      1
#define FALSE     0

inline void outportb( unsigned short port, char value)
{
__asm__ __volatile__ ("outb %%al,%%dx"
		::"a" ((char) value),"d" ((unsigned short) port));
}

inline unsigned int inportb(unsigned short port)
{
	unsigned int _v;
__asm__ __volatile__ ("inb %%dx,%%al"
		:"=a" (_v):"d" ((unsigned short) port),"0" (0));
	return _v;
}

/*
** Routine to set the permissions of i/o
** ports used for clock manipulation.  May not
** be clean, but it works.  --  RLB
*/

void perm_ports(int perm)
{
  ioperm(0x3c2, 1, perm);
  ioperm(0x3cc, 1, perm);
  ioperm(0x3d4, 1, perm);
  ioperm(0x3d5, 1, perm);
}

/* Enable S3 extended CRTC registers - AB */
void enable_s3(void)
{ outportb(0x03d4,0x38);outportb(0x03d5,0x48);
  outportb(0x03d4,0x39);outportb(0x03d5,0xa0);
}

int main(int argc, char **argv)
  { unsigned long freq	 ;
    unsigned long newfreq;
    double	freqin;
    int		a_parm=-1;

    if (argc < 2)
      { fprintf(stderr,"usage: FREQ pixelclock [MHz] [#42-force-parameter]\n");
	return 1;
      }

    sscanf(argv[1],"%lf",&freqin);
    freq=1000.0*freqin;

    if (freq!=0 &&(freq<300l || freq>128000l))
      { fprintf(stderr,"Pixel clock must be in the range [0.3-128] MHz or 0 to select 28 Mhz.\n");
	return 1;
      }
    if (freq>86000)
      fprintf(stderr,"Clock generator is running outside the specification (86MHz) \n");

    if (argc==3) sscanf(argv[2],"%d",&a_parm);

    perm_ports( TRUE );  /* set i/o permissions - RLB */
    enable_s3();	 /* set access to S3-Registers - AB */
    newfreq=setfreq(freq,a_parm);
    printf("[%1X-%1X-%2X-%2X]=[%06lX]\t%5lu kHz instead of%6lu kHz\n",
	    _bin,_gen,_mul,_div,_value,newfreq,freq);
    perm_ports( FALSE ); /* clear i/o permissions - RLB */
    return 0;
  }

/* End of FREQ.C */
