/***
 *** grabmode
 *** Copyright (c) 1995 by Koen Gadeyne (kmg@barco.be)
 ***
 *** This program outputs the current text or graphics mode, in an SVGATextMode (or XF86Config-like) compatible line
 *** Should work on ANY VGA card, since it only uses standard VGA registers
 ***
 ***/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifndef DOS
#include <unistd.h>
#include <asm/io.h>
#endif

#include "vga_prg.h"
#include "messages.h"
#include "probe.h"

#ifdef DOS
#define get_VGA_io_perm(x)
#undef Renounce_SUID
#define Renounce_SUID
extern int optind;
#endif

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (-1)
#endif
#define UNDEFINED 0  /* not TRUE, not FALSE */


char *CommandName;
int debug_messages=FALSE;

void usage()
{
     PMESSAGE(("version %s. (c) 1995 Koen Gadeyne (kmg@barco.be)\n Usage: %s [options] \n\n\
     Options: -n  Don't program VGA hardware\n\
              -d  print debugging information\n\
              -X  Output compatible with XF86Config mode line\n\
              -T  Output compatible with TextConfig mode line\n\
              -h  print usage information\n",
     VERSION, CommandName))
}

/***********************************************************************************************************/
 
int main (int argc, char* argv[])
{
  int program_hardware=TRUE;
  int Xmode=UNDEFINED;
  char c;
  
  int charsperline, start_hsync, stop_hsync, totalh;
  int activelines, start_vsync, stop_vsync, totalv;
  
  int hsyncpol, vsyncpol;
  
  int fontwidth, fontheight;
  
  float pclock;
  
  CommandName = argv[0];
 
 /*
  * command-line argument parsing
  */

  while ((c = getopt (argc, argv, "ndhXT")) != EOF)
    switch (c)
    {
      case 'n': program_hardware=FALSE;
                break;
      case 'd': debug_messages=TRUE;
                break;
      case 'X': Xmode = TRUE;
                break;
      case 'T': Xmode = FALSE;
                break;
      case 'h': usage();
                exit(0);
                break;
      case '?': usage();
                PERROR(("Bad option '%s'\n",argv[optind-1]));
                exit(-1);
                break;
      default: PERROR(("getopt returned unknown token '%c'.",c));
    }

/*
 * start doing something usefull
 */
 
 if (program_hardware==TRUE)
  {
     get_VGA_io_perm(CS_VGA);
     unlock(CS_VGA); /* unlock standard VGA locked registers */

     charsperline = Get_HOR_DISPL_END();
     start_hsync = Get_HSYNC_START();
     stop_hsync = Get_HSYNC_END();
     totalh = Get_HOR_TOTAL();
     activelines = Get_VERT_DISPL_END();
     start_vsync = Get_VRETRACE_START();
     stop_vsync = Get_VRETRACE_END();
     totalv = Get_VERT_TOTAL();
     
     fontwidth = get_charwidth();
     fontheight = Get_MAX_SCANLINE();
     
     hsyncpol = Get_HSYNC_POLARITY();
     vsyncpol = Get_VSYNC_POLARITY();
     
     PMESSAGE(("Please be patient. This may take a while (up to 1 minute)"));
     
     pclock = pixclock(totalh*fontwidth, totalv);
     
     /* auto selection between graphics/text mode if not defined on command line */
     if (Xmode==UNDEFINED) Xmode = (Get_TX_GR_Mode() ? TRUE : FALSE);
     
     if (Xmode==FALSE)
     {
       printf("\"%dx%d\"   %1.3f   %d %d %d %d   %d %d %d %d   %cHsync %cVsync  font %dx%d   # %1.3fkHz/%1.2fHz\n",
           charsperline, activelines/fontheight, pclock, 
           charsperline*8, start_hsync*8, stop_hsync*8, totalh*8, activelines, start_vsync, stop_vsync, totalv,
           (hsyncpol > 0) ? '+' : '-', (vsyncpol > 0) ? '+' : '-',
           fontwidth, fontheight,
           (pclock/totalh/fontwidth)*1000,
           (pclock/totalh/fontwidth/totalv)*1000000);
     }
     else
     {
       printf("\"%dx%d\"   %1.3f   %d %d %d %d   %d %d %d %d   %cHsync %cVsync   # %1.3fkHz/%1.2fHz\n",
           charsperline*8, activelines, pclock, 
           charsperline*8, start_hsync*8, stop_hsync*8, totalh*8, activelines, start_vsync, stop_vsync, totalv,
           (hsyncpol > 0) ? '+' : '-', (vsyncpol > 0) ? '+' : '-',
           (pclock/totalh/fontwidth)*1000,
           (pclock/totalh/fontwidth/totalv)*1000000);
     }
     
  }
  return(0);
}
