/***
 *** message printing tools
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#ifndef _MESSAGES_H
#define _MESSAGES_H

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (-1)
#endif

void print_msg(char *format,...);

extern char* CommandName;
extern int debug_messages;

#define MSGTYP_ERR   3
#define MSGTYP_WARN  2
#define MSGTYP_MSG   1
#define MSGTYP_DBG   0

extern int msgtype;


#define PDEBUG(arg) { msgtype=MSGTYP_DBG ; print_msg arg; }

#define PERROR(arg) { msgtype=MSGTYP_ERR ; print_msg arg; exit (1); }

#define PWARNING(arg) { msgtype=MSGTYP_WARN ; print_msg arg; }

#define PMESSAGE(arg) { msgtype=MSGTYP_MSG ; print_msg arg; }

#endif

