/***
 *** SVGA clock programming functions for SVGATextMode
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#ifndef _SETCLOCK_H
#define _SETCLOCK_H

typedef unsigned char byte;
typedef int Bool;  /* for XFREE clock chip code */


/*
 * Cirrus Logic specific clock stuff
 */

#define CIRRUS_MIN_CLOCK 5.0
#define CIRRUS_MAX_CLOCK 85.0
#define CIRRUS_CLOCK_REF (14.318*2)   /* or 28.322 ??? */
#define CIRRUS_REF_KHZ (int)(CIRRUS_CLOCK_REF*1000)


/*
 * Supported ClockChips
 */
 
#define NUM_CLKCHIPS       6

#define CLKCHIP_ICD2061A     0
#define CLKCHIP_ICS2595      1
#define CLKCHIP_S3GENDAC     2
#define CLKCHIP_S3_SDAC      3    /* exactly the same as S3GENDAC for clock programming, but included for compatibility with X */
#define CLKCHIP_SC11412      4
#define CLKCHIP_TI3025       5    /* TI ViewPoint 3020/3025 RAMDAC with builtin clock generator */

#define CLKCHIP_STRINGS      { "icd2061a" , "ics2595" , "s3gendac" , "s3_sdac" , "sc11412" , "ti3025" }
 


/*
 * Clock selection error codes (MUST be negative !!!)
 */

#define CLKSEL_OUT_OF_BOUNDS    -4
#define CLKSEL_DONOTHING        -3
#define CLKSEL_ILLEGAL_NUM      -2
#define CLKSEL_NULLCLOCK        -1

/*
 * clock stuff
 */

#define MAX_CLOCKS              64   /* I suppose there are no chipsets with more clocks out there */

#define MIN_CLOCK               0.0
#define MAX_CLOCK               500.0


#define SET_CLOCKBITS_0_1(no)   ( outb(( inb(VGA_MISC_R) & 0xf3) | (((no) << 2) & 0x0C) , VGA_MISC_W) ) /* bits 0 and 1 of clock no */


int findclosestclock(float *gclocks, int num_gclocks, float req_clock, float *closest_clock);

int GetClock(int chipset, float* clocks, int num_clocks, float freq, float *closestfreq, int optmask);

void SetClock(int chipset, float* clocks, int num_clocks, float freq, float *closestfreq, int optmask);

void set_s3_clockchip_clock(int clockchip, long freq, int optmask);


#endif

