# mgetty.login
#
# This is a sample "login dispatcher" configuration file
#
# Format:
#	username userid login_program
#
# username may be prefixed / suffixed by "*" (wildcard)
#
# userid is a valid user name from /etc/passwd, or "-" to not set
# a login user id and keep the uid/euid root (needed for /bin/login)
#
# the username is always appended to the "login program" string(s)
#
# SAMPLES:
# Use this one with my Taylor-UUCP patch (taylor104.p1) and Taylor-UUCP
# passwd files. (Big advantage: tuucp can use the same passwd file for
# serial dial-in and tcp dial-in [uucico running as in.uucpd]).
#
U*	uucp	/usr/lib/uucp/uucico -L
#
# Use this one for fido calls (login name /FIDO/ is handled specially)
#
# You need Eugene Crosser's "ifmail" package for this to work.
# mgetty has to be compiled with "-DFIDO", otherwise a fido call won't
# be detected.
#
/FIDO/	uucp	/usr/local/lib/fnet/ifcico
#
# This is the "standard" behaviour - *dont* set a userid here,
# otherwise /bin/login will fail!
# This entry isn't really necessary: if it's missing, the built-in
# default will do exactly this.
#
*	-	/bin/login
