/* $Header: /home/klaus/mgetty/voice/RCS/vanswer.c,v 1.13 1994/02/02 23:43:41 klaus Exp $ */

/* handle a voice call: play answering message, beep, record
   and switch back to data mode if appropiate. */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#include <sys/times.h>

#include "policy.h"
#include "mgetty.h"
#include "fax_lib.h"
#include "voclib.h"

#ifdef NO_STRSTR
char *
strstr _P2((haystack, needle), const char* haystack, const char* needle)
{
    /* This isn't terribly efficient, but it'll do for now. */
    int l, n;
    l=strlen(haystack);
    n=strlen(needle);

    for (i = 0; i < l; i++) {
        if (strncmp(&haystack[i], needle, n) == 0) return haystack + i;
    }
    return 0;
}
#endif

void
voice_message_light _P1((rings_wanted), int *rings_wanted)
{
    /* With external modems, the auto-answer LED can be used
       to show a status flag. vgetty uses this to indicate
       that new messages have arrived.
       
       Since vgetty doesn't remember what happened during previous
       calls, a flag file is used to mark the status. */

#ifdef R_MESSAGE_FLAG_FILE
    /* Are there messages waiting ? */
    FILE *flag=fopen(message_flag_file, "r");

    if(flag) {
	/* turn on the AA lamp */
	voice_command("ATS0=255", "OK", STDIN);
	*rings_wanted -= TOLL_SAVER_RINGS;
	if( *rings_wanted < 1) *rings_wanted=1;
	fclose(flag);
    } else {
	/* turn it off */
	voice_command("ATS0=0", "OK", STDIN);
    }
#endif
}

int /* answer_mode */
get_answer_mode _P1((Device), char *Device) {
    /* check for a "answer mode" file (/etc/answer.<device>) */
    
    FILE *fin;
    int i,l;
    int answer_mode = 0;
    char buf[MAXLINE];
    
    sprintf( buf, voice_answer_file, Device );
    fin=fopen(buf, "r");
    if(!fin) return ANSWER_FAX | ANSWER_VOICE | ANSWER_DATA;

    while(!feof(fin)) {
	fgets(buf, MAXLINE, fin);
	
	l=strlen(buf);
	for(i=0; i<l; i++) buf[i]=tolower(buf[i]);

	if (strstr(buf, "voice") ) answer_mode |= ANSWER_VOICE;
	if (strstr(buf, "fax"  ) ) answer_mode |= ANSWER_FAX;
	if (strstr(buf, "data" ) ) answer_mode |= ANSWER_DATA;
	
	lprintf( L_NOISE, "answer_mode is %d", answer_mode );
	if (answer_mode==0) {
	    lprintf( L_MESG, "don't accept any kind of call!" );
	    clean_line( STDIN, 80 );	/* wait for ringing to stop */
	    exit(1);
	}
    }
    return answer_mode;
}

static char *
greeting_message_file _P0(void)
{
    static char path[MAXPATH];
    
    FILE *list;
    char msg[MAXPATH];
    
    list=fopen(voice_message_list, "r");
    if (!list) {
	strcpy(msg, voice_backup_message);
    } else {
	int i, m, n=0;
	/* count the messages */
	while(!feof(list)) {
	    fgets(msg, MAXPATH, list);
	    if(strlen(msg)>1) n++;
	}
	lprintf(L_MESG, "found %d messages", n);
	/* pick a random one (could use rand() here) */
	m=getpid() % n;
	rewind(list);
	for(i=0; i<=m; i++) fgets(msg, MAXPATH, list);
	i=strlen(msg);
	if(i && msg[i-1]=='\n') msg[i-1]=0;
	fclose(list);
    }
    
    /* make the filename */
    if ( msg[0]!='/' ) {
	sprintf( path, "%s/%s", voice_message_dir, msg);
    } else {
	strcpy( path, msg);
    }
    
    lprintf( L_NOISE, "picked file %s", path );
    return path;
}

static void
remove_message _P1((message), char *message)
{
    /* throw away the recording */
    lprintf( L_MESG, "removing recording." );
    unlink(message);
}

static void
button_program_and_exit _P0(void)
{
    /* exec button program */
    lprintf( L_NOISE, "button pressed" );
#ifdef R_BUTTON_PROGRAM
    lprintf( L_NOISE, "executing %s", button_program );
    (void) execl(button_program, button_program,
		 "button", (char *) NULL);
    (void) execl("/bin/sh", "sh", "-c",
		 button_program,
		 "button", (char *) NULL);
    lprintf(L_ERROR, "cannot execute %s", button_program);
#endif
    exit(1);
}

static void
keep_message_and_exit _P2((message, silence), char *message, int silence)
{
    char res[20];
    
    lprintf( L_MESG, "Voice message received, stored in %s.",
	    message );

    /* beep */
    voice_beep( STDIN, 2, "[933,0,12]");
	    
#ifdef R_MESSAGE_PROGRAM
    sprintf(res, "%d", silence);
    lprintf( L_NOISE, "executing %s %s %s", message_program, message, res );
    (void) execl(message_program, message_program,
		 message, res, (char *) NULL);
    (void) execl("/bin/sh", "sh", "-c",
		 message_program, message, res, (char *) NULL);
    lprintf(L_ERROR, "cannot execute %s", message_program);
#endif
    exit(1);
}

static void
dtmf_program_and_exit _P1((dtmf), char *dtmf)
{
    lprintf( L_MESG, "got DTMF command <%s>.", dtmf );

    /* call the external program to handle the DTMF command. */
#ifdef R_DTMF_PROGRAM
    lprintf( L_NOISE, "executing %s %s", dtmf_program, dtmf );
    (void) execl(dtmf_program, dtmf_program, dtmf, (char *) NULL);
    (void) execl("/bin/sh", "sh", "-c",
		 dtmf_program, dtmf, (char *) NULL);
    lprintf(L_ERROR, "cannot execute %s", dtmf_program);
#endif
    exit(1);
}

void
voice_answer _P5((rings, rings_wanted, answer_chat_actions, answer_chat_timeout,
		  answer_mode), int rings, int rings_wanted,
		  chat_action_t answer_chat_actions[],
		  int answer_chat_timeout, int answer_mode )
{
    action_t what_action;
    static char *answer_chat_seq[] = { "", "ATA", "CONNECT", "\\c", "\n", NULL };

    if( rings == 0 ) {
	/* The data/voice button was pushed, but the phone didn't */
	/* ring. Call the external program. */
	button_program_and_exit();
    } else if ( rings == rings_wanted && (answer_mode & ANSWER_VOICE)) {
	/* answer the phone normally */
	char *path;
	int ret;
	char logmsg[1024];
	extern char *Device;

	/* play a greeting message */
	path=greeting_message_file();
	ret=voice_send_file( path, STDIN, 2 ) ;
	
	sprintf( logmsg, "dev=%s, pid=%d, caller=%s, name='%s'",
		Device, getpid(), CallerId, CallName);
	
	if ( ret=='#' || ret=='V' ) {
	    lprintf(L_AUDIT, "hangup request, %s", logmsg);
	    exit(1);
	} else if ( ret=='d' || ret=='b' ) {
	    lprintf(L_AUDIT, "nobody there, %s", logmsg);
	    exit(1);
	} else if ( ret==0 || ret=='*' ) {
	    /* try to record a message and/or DTMF tones */
	    char message[MAXPATH];
	    char dtmf[DTMFLEN];
	    int result;

	    time_t call_end;
	    extern time_t call_start;

	    message[0] = dtmf[0] = '\0';
	    
	    /* beep */
	    voice_beep( STDIN, 2, "[933,0,12]");
	    
	    /* record message */
	    sprintf( message, "%s/voc-XXXXXX", voice_receive_dir);
	    mktemp( message );
	    result=voice_record_file(message, STDIN, 2,
				     VOICE_REC_COMPRESSION,
				     VOICE_SILENCE_LEN,
				     VOICE_SILENCE_THRESHOLD,
				     VOICE_MAX_LEN, dtmf, DTMFLEN);

	    time(&call_end);
	    call_end -= call_start;

	    sprintf( logmsg+strlen(logmsg),
		    ", time=%02d:%02d:%02d",
		    (int)(call_end / 3600),
		    (int)((call_end / 60) % 60),
		    (int)(call_end % 60));

	    if ( strlen(dtmf) ) {
		/* Caller typed a DTMF command */
		remove_message( message );
		lprintf( L_AUDIT, "voice dtmf='%s', %s\n", dtmf, logmsg );
		dtmf_program_and_exit( dtmf );
	    } else if( (result >='0' && result <='9')
		      || result == 's' || result == 'c'
		      ) {
		/* It wasn't a voice message, throw away the recording */
		remove_message( message );
		/* now drop through to fax/data mode */
	    } else {
		/* seems to have been a normal voice message.
		 * q:quiet after non-quiet, b:busy, d:dialtone
		 * #:hangup request
		 * ERROR: try to save the recording anyway
		 */
		int silence = 0;
		if ( result == 'q' ) silence = VOICE_SILENCE_LEN ;
		lprintf( L_AUDIT, "voice keep %s\n", logmsg );
		keep_message_and_exit( message, silence );
	    }	    
	} else {
	    /* drop through to data/fax mode after an aborted greeting
	     * message, due to fax calling tone or user request ('0'-'9') */
	}
    }
    
    /* Enter fax/data mode. This can happen for one of three reasons:
     *  - not enough rings were detected (the user pushed DATA/VOICE)
     *    [ rings < rings_wanted ]
     *  - voice answer was disabled due to /etc/answer.<device> setting
     *  - fax calling tone or dtmf digit during greeting msg playback
     *    [ if(ret) fallthrough ]
     *  - silence or empty dtmf string during message recording
     *    [ if(result) fallthrough ]
     */
       
    lprintf( L_NOISE, "Trying fax/data connection..." );

    /* switch the modem back to fax/data mode */
    voice_command( "AT+FCLASS=2;+FAA=1", "OK", STDIN );
    
    /* reanswer the phone */
    if ( do_chat( STDIN, answer_chat_seq, answer_chat_actions,
		 &what_action, answer_chat_timeout, TRUE ) == FAIL)
    {
	if ( what_action == A_FAX ) {
	    if (answer_mode & ANSWER_FAX) {
		lprintf( L_MESG, "Got fax connect, starting fax receiver");
		faxrec( FAX_SPOOL_IN );
		lprintf( L_MESG, "fax receiver finished, exiting...");
		exit(1);
	    } else {
		lprintf( L_MESG, "fax reception is disabled, exiting...");
		exit(1);
	    }
	}
	
	lprintf( L_MESG, "data/fax connection failed, exiting..." );
	rmlocks();
	exit(1);
    }

    if (answer_mode & ANSWER_DATA) {
	lprintf( L_MESG, "Got data connect." );
	/* If we get here, we have a modem connect. Business as usual,
	 * i.e. return to the main function and try to get a login */

	return;
    } else {
	lprintf( L_MESG, "data connection is disabled, exiting..." );
	exit(1);
    }
}
