/* $Header: /home/klaus/mgetty/voice/RCS/voclib.c,v 1.20 1994/02/02 23:43:33 klaus Exp $
 *
 * (mostly stolen from Gert Doering's fax routines)
 *
 * Various utility functions for using the ZyXEL voice commands
 *
 * ALPHA software, beware...
 */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif
#include <sys/ioctl.h>
#include <signal.h>
#include <ctype.h>

#include "mgetty.h"
#include "voclib.h"
#include "tio.h"

static boolean fwf_timeout = FALSE;

static void fwf_sig_alarm _P0(void)	/* SIGALRM handler */
{
    signal( SIGALRM, fwf_sig_alarm );
    lprintf( L_WARN, "Warning: got alarm signal!" );
    fwf_timeout = TRUE;
}

/* voice_read_byte
 * read one byte from "fd", with buffering
 * caveat: only one fd allowed (only one buffer), no way to flush buffers
 */

int voice_read_byte _P2( (fd, c), int fd, char * c )
{
    static char frb_buf[512];
    static int  frb_rp = 0;
    static int  frb_len = 0;

    if ( frb_rp >= frb_len )
    {
	frb_len = read( fd, frb_buf, sizeof( frb_buf ) );
	if ( frb_len <= 0 )
	{
	    lprintf( L_ERROR, "voice_read_byte: read returned %d", frb_len );
	    return frb_len;
	}
	/*!!	lprintf( L_JUNK, "voice_read_byte: read %d bytes", frb_len );*/
	frb_rp = 0;
    }
    
    *c = frb_buf[ frb_rp++ ];
    return 1;
}

#define NALT 10

int voice_wait_for _P2((s_in, fd),  char * s_in, int fd )
{
    char buffer[1000];
    char str[1000];
    char c;
    int bufferp;
    char *st[NALT], *si;
    int nalt;
    int found=0;

    lprintf( L_MESG, "voice_wait_for(%s)", s_in );

    strcpy(str, s_in);
    st[0]=str;
    nalt=1;
    for(si=str; *si; si++) {
	if(*si=='|') {
	    *si=0;
	    st[nalt++]=si+1;
	}
    }

    fwf_timeout = FALSE;
    signal( SIGALRM, fwf_sig_alarm );

    while (!found) 
    {
	int i;
	alarm( FAX_RESPONSE_TIMEOUT );
	
	bufferp = 0;
	lprintf( L_JUNK, "got:" );
	
	/* get one string, not empty, printable chars only, ended by '\n' */
	do
	{
	    if( voice_read_byte( fd, &c ) != 1 )
	    {
		lprintf( L_ERROR, "voice_wait_for: cannot read byte, return" );
		alarm( 0 ); signal( SIGALRM, SIG_DFL );
			    return ERROR;
	    }
	    lputc( L_JUNK, c );
	    if ( isprint( c ) ) buffer[ bufferp++ ] = c;
	}
	while ( bufferp == 0 || c != 0x0a );
	buffer[bufferp] = 0;
	
	lprintf( L_NOISE, "voice_wait_for: string '%s'", buffer );
	
	for(i=0; i<nalt; i++) {
	    if (strncmp( st[i], buffer, strlen(st[i]) ) == 0)
		found=1;
	}
    }
    lputs( L_MESG, "** found **" );

    alarm( 0 );
    signal( SIGALRM, SIG_DFL );
    return NOERROR;
}

int voice_send _P2((s, fd),  char * s, int fd )
{
    lprintf( L_NOISE, "voice_send: '%s'", s );
    return write( fd, s, strlen( s ) );
}

int voice_command _P3((send, expect, fd), char * send, char * expect, int fd )
{
    lprintf( L_MESG, "voice_command: send '%s'", send );

     /* The ZyXEL seems to have problems keeping up with fast
      * computers. This ought to help.
      */
    delay(10);		/* wait 10 milliseconds */

    if ( write( fd, send, strlen( send ) ) != strlen( send ) ||
	write( fd, "\r\n", 2 ) != 2 )
    {
	lprintf( L_ERROR, "voice_command: cannot write" );
	return ERROR;
    }
    return voice_wait_for( expect, fd );
}

int voice_open_device _P1((voice_tty), char * voice_tty )
{
    char device[MAXPATH];
    int	fd;
    TIO vtio;

    if ( verbose ) printf( "Trying voice device '/dev/%s'... ", voice_tty );

    if ( makelock( voice_tty ) != SUCCESS )
    {
	if ( verbose ) printf( "locked!\n" );
	lprintf( L_MESG, "cannot lock %s", voice_tty );
	return -1;
    }
    
    sprintf( device, "/dev/%s", voice_tty );

    if ( ( fd = open( device, O_RDWR | O_NDELAY ) ) == -1 )
    {
	lprintf( L_ERROR, "error opening %s", device );
	if ( verbose ) printf( "cannot open!\n" );
	rmlocks();
	return fd;
    }

    /* unset O_NDELAY (otherwise waiting for characters */
    /* would be "busy waiting", eating up all cpu) */

    if ( fcntl( fd, F_SETFL, O_RDWR ) == -1 )
    {
	lprintf( L_ERROR, "error in fcntl" );
	close( fd );
	if ( verbose ) printf( "cannot fcntl!\n" );
	rmlocks();
	return -1;
    }

    /* initialize baud rate, hardware handshake, ... */
    tio_get( fd, &vtio);
    tio_set_speed( &vtio, VOICE_SEND_BAUD );
    tio_mode_sane( &vtio, TRUE );
    tio_set_flow_control( fd, &vtio, FLOW_SOFT );
    tio_mode_raw( &vtio );

    if ( tio_set( fd, &vtio) == ERROR )
    {
	lprintf( L_ERROR, "error in tio_set" );
	if ( verbose ) printf( "cannot set termio values!\n" );
	rmlocks();
	return -1;
	close(fd);
    }        
    
    lprintf( L_NOISE, "voice_open_device succeeded, %s -> %d", voice_tty, fd );
    if ( verbose ) printf( "OK.\n" );
    return fd;
}

/* voice_open: loop through all devices in voice_ttys until voice_open_device()
 * succeeds on one of them; then return file descriptor
 * return "-1" of no open succeeded (all locked, permission denied, ...)
 */

int voice_open _P1((voice_ttys), char * voice_ttys )
{
    char * p, * voice_tty;
    int fd;

    p = voice_tty = voice_ttys;
    do
    {
	p = strchr( voice_tty, ':' );
	if ( p != NULL ) *p = 0;
	fd = voice_open_device( voice_tty );
	if ( p != NULL ) *p = ':';
	voice_tty = p+1;
    }
    while ( p != NULL && fd == -1 );
    return fd;
}

/* finish off - close modem device, rm lockfile */

void voice_close _P1((fd), int fd )
{
    close( fd );
    rmlocks();
}

static volatile boolean voice_quit = FALSE;

#ifndef RETSIGTYPE
# define RETSIGTYPE void
#endif

typedef RETSIGTYPE (*sighandler_t) _PROTO((int));

void voice_sig_hangup _P1((sig_num), int sig_num )
{
    signal( SIGHUP, voice_sig_hangup );
    lprintf( L_WARN, "got hangup! what's this? exiting..." );
    voice_quit = TRUE;
}

void voice_sig_alarm _P1((sig_num), int sig_num )
{
    signal( SIGALRM, voice_sig_alarm );
    lprintf( L_MESG, "timeout..." );
    voice_quit = TRUE;
}

int voice_beep _P3((fd, voc_io, beep), int fd, int voc_io, char *beep )
{
    char cmd[256];

    sprintf( cmd, "ATL%s +VLS=%d",
	    voc_io == 16 ? SPEAKER_PLAY_VOLUME : SPEAKER_ANSWER_VOLUME,
	    voc_io );

    if ( voice_command( cmd, "VCON|OK", fd ) == ERROR )
    {
	lprintf( L_WARN, "modem error, abort beep!" );
	return ERROR;
    }
    
    sprintf( cmd, "AT+VTS=%s", beep );
    if ( voice_command( cmd , "VCON|OK", fd ) == ERROR )
    {
	lprintf( L_WARN, "modem error, abort beep!" );
	return ERROR;
    }
    return 0;
}

/* voice_record_file
 *
 * record a file and listen for DTMF tones and other
 * <DLE>-shielded messages from the modem
 */
int voice_record_file _P9((voc_file, fd, voc_io, compr, silence, threshold,
		           timeout, digits, nmax),
		      char * voc_file, int fd, int voc_io,
		      int compr, int silence, int threshold,
		      int timeout, char *digits, int nmax )
{
    TIO vtio, save_tio;
    FILE * voc_fp;
    char cmd[128];
    char c;
    char WasDLE;
    int ErrorCount = 0;
    int ByteCount = 0;
    int MaxBytes;
    int ret = ERROR;
    int ndigits=0;
    static char header[] = { 'Z', 'y', 'X', 'E', 'L', 2, 0, 0,
			  0, 0, 0, 0, 0, 0, 0, 0 };
    static int datarate[] = VOICE_DATA_RATES;
    sighandler_t Sigalrm, Sighup, Sigquit, Sigterm, Sigint;
    char *cur_blk, *blk_base;
    int blksize, blk_read, blk_wrt, nblk, bi;

    /* install signal handlers */
    Sigalrm = signal( SIGALRM, voice_sig_alarm );
    Sighup  = signal( SIGHUP,  voice_sig_hangup );
    Sigquit = signal( SIGQUIT, voice_sig_hangup );
    Sigterm = signal( SIGTERM, voice_sig_hangup );
    Sigint  = signal( SIGINT , voice_sig_hangup );
    voice_quit = FALSE;

    MaxBytes = datarate[compr] * timeout;

    /* Setup tty interface
     * Do not set c_cflag, assume that caller has set bit rate,
     * hardware handshake, ... properly
     */

    tio_get( fd, &vtio );
    save_tio = vtio;
    fcntl( fd, F_SETFL, O_RDWR );
    tio_mode_sane( &vtio, TRUE );
    tio_set_flow_control( fd, &vtio, FLOW_XON_IN );
    tio_mode_raw( &vtio );
    tio_map_cr( &vtio, FALSE );
    tio_set( fd, &vtio );
    
    voc_fp = fopen( voc_file, "w" );
    if ( ! voc_fp)
    {
	lprintf( L_ERROR, "opening %s failed!", voc_file );
	ret = ERROR;
	goto exit;
    }
    
    header[10] = compr - 1;
    fwrite( header, 16, 1, voc_fp );

    sprintf( cmd, "AT+VSM=%d;+VLS=%d;+VSD=%d,%d",
	    compr, voc_io, threshold, silence );

    if ( voice_command( cmd, "VCON|OK", fd ) == ERROR )
    {
	lprintf( L_WARN, "AT+VLS -> some error, abort voice recording!" );
	ret = ERROR;
	goto exit;
    }

    if (ZYXEL_R610==1) {
	if ( voice_command( "ATS39.7=0;S39.6=1", "VCON|OK", fd ) == ERROR ) {
	    lprintf( L_WARN, "Selecting data format didn't work, trying to continue" );
    	}
    }

    if ( voice_command( "AT+VRX", "CONNECT", fd ) == ERROR )
    {
	lprintf( L_WARN, "AT+VTX -> some error, abort voice recording!" );
	ret = ERROR;
	goto exit;
    }

    lprintf( L_MESG, "voice_record: receiving %s...", voc_file );

    /* Remove the silence at the end of recordings, if appropiate.
     * To do this, a ring buffer is kept, it contains n+1 blocks
     * that each contain one second of data, where n is the number
     * of seconds of silence received.
     */

    nblk = silence/10 + 1;
    blksize = datarate[compr];

    cur_blk = blk_base = (char *)malloc(nblk * blksize);
    if( !blk_base ) {
	lprintf( L_WARN, "not enough memory for ring buffer, continuing" );
	/* DON'T exit, just deactivate the ring buffer */
    }

    blk_read = blk_wrt = 0;
    bi = 0;
    
    WasDLE = 0;
    do
    {
	int got_char = 0;
	
	/* refresh alarm timer every 1024 bytes
	 * (to refresh it for every byte is considered too expensive)
	 */
	if ( ( ByteCount & 0x3ff ) == 0 )
	{
	    alarm(FAX_PAGE_TIMEOUT);
	}

	if ( ( ByteCount & 0xfff ) == 0 )
	{
	    if ( !checkspace(voc_file) )
	    {
		lprintf( L_ERROR, "Out of space - exiting" );
		ret = ERROR;
		goto exit;
	    }
	}

	if ( voice_read_byte( fd, &c ) != 1 )
	{
	    ErrorCount++;
	    lprintf( L_ERROR, "voice record: cannot read from port (%d)!",
	                      ErrorCount );
	    if (ErrorCount > 10) {
		ret = ERROR;
		goto exit;
	    }
	}
	ByteCount++;

	if ( WasDLE ) {
	    if ( c == DLE ) {
		got_char = 1; /* DLE DLE -> DLE */
	    } else {
		lprintf( L_MESG, "Got <DLE>" );
		lputc( L_MESG, c );
		if ( c=='*' ) {
		    ndigits=0; /* remove previous digits */
		} else if ( c>='0' && c<='9' ) {
		    if(digits && ndigits<nmax-1) digits[ndigits++] = c;
		} else {
		    lprintf( L_MESG, "Stop recording." );
		    ret = c;
		    break;
		}
	    }
	    WasDLE = 0;
	} else {
	    if ( c == DLE ) {
		WasDLE = 1;
	    } else {
		got_char = 1; /* write it later */
	    }
	}

	if(got_char) {
	    if( !blk_base ) {
		fputc( c, voc_fp );
	    } else {	
		/* put one byte in the ring buffer */
		cur_blk[bi++] = c;
		if( bi==blksize ) {
		    /* current block is finished, get a new one */
		    bi = 0;
		    blk_read ++;
		    cur_blk = blk_base + (blk_read % nblk) * blksize;
		    if( blk_read >= nblk ) {
			/* new block was filled, write old contents */
			fwrite(cur_blk, 1, blksize, voc_fp);
			blk_wrt ++;
		    }
		}
	    }
	}
    }
    while ( ( c != ETX || ! WasDLE ) 
	   && !voice_quit
	   && ByteCount < MaxBytes );

    if( blk_base ) {
	/* write out any stuff left in the ring buffer */
	if( ret != 'q' ) {
	    int i;
	    /* write out all the old blocks */

	    for(i=blk_wrt; i<blk_read; i++) {
		fwrite(blk_base + (i % nblk) *blksize,
		       1, blksize, voc_fp);
	    }
	}
	if( bi ) {
	    /* write the partly filled last block */
	    fwrite(cur_blk, 1, bi, voc_fp);
	}
    }
	
    fclose( voc_fp );
    lprintf( L_MESG, "voice record: end, bytes received: %d", ByteCount);

    voice_command( "", "VCON|OK", fd );

    if ( ByteCount >= MaxBytes ) {
	lprintf( L_MESG, "voice record: max speaking time exceeded." );
	ret='q';
    }

    if ( voice_quit )
    {
	lprintf( L_MESG, "voice record: recording aborted, timeout!" );
	ret = ERROR;
	goto exit;
    }

  exit:
    if(digits) digits[ndigits] = 0;
    tio_set( fd, &save_tio );
    alarm(0);
    signal(SIGALRM, Sigalrm);
    signal(SIGHUP,  Sighup );
    signal(SIGINT,  Sigint );
    signal(SIGQUIT, Sigquit);
    signal(SIGTERM, Sigterm);

    return ret;
}

/* voice_send_file - send one complete voice file to the modem
 *
 */
int voice_send_file _P3((voc_file, fd, voc_io),
			char * voc_file, int fd, int voc_io )
{
    int vocfd;
    char ch;
    char buf[1024];
    char wbuf[ sizeof(buf) * 2 ];
    char cmd[128];
    int compr=2;
    static char voice_end_of_page[] = { DLE, ETX };
    int ret = ERROR;
    int WasDLE = 0;
    int r, i, w;
    TIO vtio, save_tio;
    sighandler_t Sighup, Sigquit, Sigterm, Sigint;
    char *vcon="VCON";
    int vcon_ptr = 0, vcon_len = 4;


    Sighup  = signal( SIGHUP,  voice_sig_hangup );
    Sigquit = signal( SIGQUIT, voice_sig_hangup );
    Sigterm = signal( SIGTERM, voice_sig_hangup );
    Sigint  = signal( SIGINT , voice_sig_hangup );
    voice_quit = FALSE;

    lprintf( L_NOISE, "voice_send_file(\"%s\") started...", voc_file );

    tio_get( fd, &vtio );
    save_tio = vtio;
    fcntl( fd, F_SETFL, O_RDWR );
    tio_mode_sane( &vtio, TRUE );
    tio_set_flow_control( fd, &vtio, FLOW_XON_OUT );
    tio_mode_raw( &vtio );
    tio_set( fd, &vtio );

    lprintf( L_MESG, "sending %s...", voc_file );

    vocfd = open( voc_file, O_RDONLY );
    if ( vocfd == -1 ) {
	lprintf( L_ERROR, "cannot open %s", voc_file );
	ret = 0; /* record anyway if the msg doesn't exist */
	goto exit;
    } else {
	/* read zfax header */
	r = read( vocfd, buf, 16 );
	
	if ( r >= 16 && strncmp( buf, "ZyXEL", 5 ) == 0 )
	{
	    compr=buf[10] + 1;
	    lprintf( L_MESG,
		    "reading zfax header, compression is %s",
		    compr == 1 ? "CELP" : ( compr == 2 ?
					   "ADPCM-2"
					   : "ADPCM-3"));
	} else {
	    lprintf( L_WARN, "No ZFAX header found, aborting!" );
	    ret = 0;
	    goto exit;
	}
    }
    
    /* tell modem that we're ready to send - modem will answer
     * with VCON
     */

    sprintf( cmd, "ATL%s +VSM=%d;+VLS=%d",
	    voc_io == 16 ? SPEAKER_PLAY_VOLUME : SPEAKER_ANSWER_VOLUME,
	    compr, voc_io );

    if ( voice_command( cmd, "VCON|OK", fd ) == ERROR )
    {
	lprintf( L_WARN, "AT+VLS -> some error, abort voice send!"
		);
	ret = ERROR;
	goto exit;
    }

    if (ZYXEL_R610==1) {
	if ( voice_command( "ATS39.7=0;S39.6=1", "VCON|OK", fd ) == ERROR ) {
	    lprintf( L_WARN, "Selecting data format didn't work, trying to continue" );
    	}
    }

    if ( voice_command( "AT+VTX", "CONNECT", fd ) == ERROR )
    {
	lprintf( L_WARN, "AT+VTX -> some error, abort voice send!" );
	ret = ERROR;
	goto exit;
    }
    
    /* send one page */
    
    while (!voice_quit && ( r = read( vocfd, buf, 1024 ) ) > 0 ) {
	i = 0;

	for ( w = 0; i < r; i++ ) {
	    wbuf[ w ] = buf[ i ];
	    if ( wbuf[ w++ ] == DLE ) wbuf[ w++ ] = DLE;
	}

	lprintf( L_JUNK, "read %d, write %d", r, w );
	
	if ( write( fd, wbuf, w ) != w ) {
	    lprintf( L_ERROR, "could not write all %d bytes", w );
	}

	/* look if there's something to read
	 *
	 * If the modem detects DTMF tones, it
	 * will send <DLE><n>, n=0123456789#*
	 *
	 */

	if ( check_for_input( fd ) ) {
	    do {
		/* intentionally don't use voice_read_byte here */
		if ( read( fd, &ch, 1 ) != 1 ) {
		    lprintf( L_ERROR, "read failed" );
		    break;
		} else {
		    lprintf( L_NOISE, "input: got " );
		    lputc( L_NOISE, ch );
		    if ( WasDLE ) {
			ret = ch;
			WasDLE=0;
			voice_quit = TRUE;
		    } else {
			if ( ch == DLE ) WasDLE=1;
			if ( ch == vcon[vcon_ptr] ) {
			    lprintf( L_NOISE, "vcon??? got %c",vcon[vcon_ptr]);
			    vcon_ptr ++;
			    if(vcon_ptr == vcon_len) {
				ret = 'V';
				voice_quit = TRUE;
				/* clean_line(STDIN, 1); */
			    }
			} else {
			    vcon_ptr = 0;
			}
		    }
		}
	    }
	    while ( check_for_input( fd ) );
	}
    } /* end while (more voice data to read) */

    if ( ret != 'V' ) {
	/* transmit end of page */
	lprintf( L_NOISE, "sending DLE ETX..." );
	write( fd, voice_end_of_page, sizeof( voice_end_of_page ));
	
	if ( voice_wait_for( "VCON|OK", fd ) == ERROR ) {
	    ret=ERROR;
	    goto exit;
	}
    }

    if(!voice_quit) ret=0;
  exit:
    tio_set( fd, &save_tio );
    signal(SIGHUP,  Sighup );
    signal(SIGINT,  Sigint );
    signal(SIGQUIT, Sigquit);
    signal(SIGTERM, Sigterm);

    return ret;
}

