/* $Header: /home/klaus/mgetty/voice/RCS/voclib.h,v 1.27 1994/01/27 16:57:45 klaus Exp $ */

/***** voice options *****/

/* maximum recording length in seconds, hang up if somebody talks
 * longer than this
 */
#define VOICE_MAX_LEN 300

/* silence length in 1/10 seconds, default 7 seconds. */
#define VOICE_SILENCE_LEN 70

/* silence threshold, 0-31, increase this if you have a noisy
 * phone line and the silence detection doesn't work reliably.
 */
#define VOICE_SILENCE_THRESHOLD 16

/* compression mode for incoming messages
 * 1=CELP,  2=ADPCM-2,  3=ADPCM-3
 */
#define VOICE_REC_COMPRESSION 3

/* data rates (bytes per second) for the compression types defined above.
 * The values below are for the ZyXEL.
 */
#define VOICE_DATA_RATES { 0, 1200, 2400, 3600 }
 
/* bps rate for zplay.c */
#define VOICE_SEND_BAUD 38400

/***** Volume settings for the internal speaker *****/

/* Volume of the internal speaker when answering the phone,
 * ZyXEL:   0 - 7
 * Dolphin: 0 - 3
 *
 * If the modem returns an error when changing the volume with
 * ATL, try reducing this.
 */
#define SPEAKER_ANSWER_VOLUME "5"

/* Volume of the internal speaker when it is used to play a message.
 */
#define SPEAKER_PLAY_VOLUME "7"

/* command sequence used to answer the phone.
 * ATN sets the ring volume, I hope that setting this to zero
 * while answering will finally get rid of the `bleep' noise. If not,
 * I'll scream very loudly and shoot the modem...
 */
#define VOICE_ATA "ATN0 \\dA N5"

/***** files and directories *****/

/* VOICE_DIR is defined in the Makefile, default /usr/spool/voice.
 * All paths below are relative to VOICE_DIR unless they start with
 * a slash.
 */

/* Log file for the `zplay' utility */
#define R_VOICE_LOG		"Voicelog"

/* Location of the optional answer mode file, %s is replaced with
 * the device name.
 * If the file doesn't exist, use 'voice/fax/data' as default
 * setting.
 */
#define R_VOICE_ANSWER_FILE	"/etc/answer.%s"

/* where to put the incoming voice messages */
#define R_VOICE_RECEIVE_DIR	"incoming"

/* directory containing the greeting messages */
#define R_VOICE_MESSAGE_DIR	"messages"

/* file containing message file names,
 * one per line, no white space, path relative to VOICE_MESSAGE_DIR
 */
#define R_VOICE_MESSAGE_LIST	"messages/Index"

/* filename of a backup greeting message in VOICE_MESSAGE_DIR
 * (used if the random selection fails to find a message)
 */
#define R_VOICE_BACKUP_MESSAGE	"messages/standard"

/***** external programs *****/

/* If you change the defines below, you will have to edit the shell
 * scripts for the external programs or supply your own.
 * Some of the file names below are hardcoded.
 */

/* If vgetty knows that there are new messages (the flag file
 * exists), it will turn on the AA lamp and enable the toll saver - it
 * will also answer the phone TOLL_SAVER_RINGS earlier than the default.
 * The external programs are responsible for creating and removing the
 * flag file appropiately. */
#define R_MESSAGE_FLAG_FILE	".flag"
#define TOLL_SAVER_RINGS 2

/* The programs defined below get called by vgetty. The modem will
 * still be in voice mode and is connected to STDIN. vgetty will
 * set the argument(s) ($1 for shell scripts, argv[1] for C programs)
 * as described.
 * (Undefine the macro if you don't want the program to be called)
 */

/* Program called when a voice message has been received.
 * Argument: filename of the recorded message
 */
#define R_MESSAGE_PROGRAM		"vg_message"

/* Program called when the DATA/VOICE button is
 * pressed and the modem hasn't heard a ring yet. (If it has,
 * the button causes it to pick up the phone immediately.)
 * Argument: "button" (a constant string)
 */
#define R_BUTTON_PROGRAM		"vg_button"

/* Program called when a DTMF command ( '*DIGITS#' )
 * is received.
 * Argument: the DIGITS received (without '*' and '#')
 */
#define R_DTMF_PROGRAM		"vg_dtmf"

/***** End of configuration options *****/

/* nothing configurable below this line */

typedef char *path_t;

extern path_t voice_log, voice_receive_dir, voice_message_dir,
              voice_message_list, voice_backup_message, message_flag_file,
	      message_program, button_program, dtmf_program,
              voice_answer_file;

extern boolean verbose;
extern void voice_path_init _PROTO((void));
extern int voice_command _PROTO(( char * send, char * expect, int fd ));
extern int voice_open_device _PROTO(( char * voice_tty ));
extern int voice_open _PROTO(( char * voice_ttys ));
extern void voice_close _PROTO(( int fd ));
extern int voice_beep _PROTO(( int fd, int voc_io, char *beep ));
extern int voice_send_file _PROTO(( char * voc_file, int fd, int voc_io ));
extern int voice_record_file _PROTO(( char *voc_file, int fd, int voc_io,
			     int compr, int silence, int threshold,
			     int timeout, char *digits, int nmax ));
extern void voice_message_light _PROTO(( int *rings_wanted ));
extern int get_answer_mode _PROTO(( char *Device ));
extern void voice_answer _PROTO(( int rings, int rings_wanted,
			 chat_action_t answer_chat_actions[],
			 int answer_chat_timeout, int answer_mode ));

#define ETX	003
#define DLE	020
#define DC2	022
#define XON	021
#define XOFF	023

#define DTMFLEN 500

#define	ERROR	-1
#define NOERROR	0

#define ANSWER_DATA  0x01
#define ANSWER_FAX   0x02
#define ANSWER_VOICE 0x04
