/* $Header: /home/klaus/mgetty/voice/RCS/vpaths.c,v 1.5 1994/01/27 17:01:03 klaus Exp $ */

#include <string.h>
#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif

#include "mgetty.h"
#include "voclib.h"

path_t voice_log, voice_receive_dir, voice_message_dir,
       voice_message_list, voice_backup_message, message_flag_file, 
       message_program, button_program, dtmf_program,
       voice_answer_file;

static char *
makepath _P2((rel, base), char *rel, char *base)
{
    char *path;
    
    if(rel[0]=='/') {
    	path=malloc(strlen(rel)+1);
    	if(!path) {
    	    lprintf(L_FATAL, "Not enough memory for paths");
    	    exit(1);
    	}
    	strcpy(path, rel);
    } else {
    	path=malloc(strlen(base)+strlen(rel)+2);
    	if(!path) {
    	    lprintf(L_FATAL, "Not enough memory for paths");
    	    exit(1);
    	}
    	strcpy(path, base);
    	strcat(path, "/");
    	strcat(path, rel);
    }

    return path;
}

void
voice_path_init _P0(void)
{
    voice_log = makepath(R_VOICE_LOG, VOICE_DIR);
    voice_receive_dir = makepath(R_VOICE_RECEIVE_DIR, VOICE_DIR);
    voice_message_dir = makepath(R_VOICE_MESSAGE_DIR, VOICE_DIR);
    voice_message_list = makepath(R_VOICE_MESSAGE_LIST, VOICE_DIR);
    voice_backup_message = makepath(R_VOICE_BACKUP_MESSAGE, VOICE_DIR);
    message_flag_file = makepath(R_MESSAGE_FLAG_FILE, VOICE_DIR);
    message_program = makepath(R_MESSAGE_PROGRAM, VOICE_DIR);
    button_program = makepath(R_BUTTON_PROGRAM, VOICE_DIR);
    dtmf_program = makepath(R_DTMF_PROGRAM, VOICE_DIR);
    voice_answer_file = makepath(R_VOICE_ANSWER_FILE, VOICE_DIR);
}
