/* $Header: /home/klaus/mgetty/voice/RCS/zplay.c,v 1.12 1994/01/24 21:44:49 klaus Exp $
 *
 * (mostly stolen from Gert Doering's fax routines)
 *
 * Play or record a voice file
 */

#include <stdio.h>
#include <string.h>
#ifndef _NOSTDLIB_H
#include <unistd.h>
#endif
#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif

#include "mgetty.h"
#include "voclib.h"
#include "policy.h"

boolean verbose = FALSE;

void exit_usage _P1((program), char * program )
{
    fprintf( stderr,
	    "usage: %s [options] [<files to play >] [-b beep] [-r <output>]\n",
	    program);
    fprintf( stderr,
	    "\t-r s record voice data in <s>\n");
    fprintf( stderr,
	    "\t-c n use compression type <n>, 1:CELP, 2:ADPCM-2, 3:ADPCM-3\n");
    fprintf( stderr,
	    "\t     (recording only, default is %d)\n",
	    VOICE_REC_COMPRESSION);
    fprintf( stderr,
	    "\t-t   use telco line for i/o (default)\n");
    fprintf( stderr,
	    "\t-s   output to internal speaker\n");
    fprintf( stderr,
	    "\t-m   input from external microphone\n");
    fprintf( stderr,
	    "\t-T n set silence time to n/10 seconds\n");
    fprintf( stderr,
	    "\t-V n set silence volume to n, n=0..31\n");
    fprintf( stderr,
	    "\t-L n set maximum recording length to n seconds\n");
    fprintf( stderr,
	    "\t-b s beep (AT+VTS=<s>), i.e. -b '[933,0,12]'\n");
    fprintf( stderr,
	    "\t-v   verbose output\n");
    fprintf( stderr,
	    "\t-x n set debugging level to <n>\n");
    fprintf( stderr,
	    "\t-l s set device string to <s>, i.e. -l ttyS1:ttyS2\n");
    fprintf( stderr,
	    "\t-S   modem is on stdin (for use in shell scripts)\n");
    exit(1);
}

int main _P2((argc, argv), int argc, char ** argv )
{
    int argidx;
    int fd;
    int ch;

    static char	voice_device_string[] = FAX_MODEM_TTYS;	/* writable! */
    char *	voice_devices = voice_device_string; /* override with "-l" */

    int	voc_io = 2;
    int compr = VOICE_REC_COMPRESSION;
    int voice_max_len = VOICE_MAX_LEN;
    int voice_silence_len = VOICE_SILENCE_LEN;
    int voice_silence_threshold = VOICE_SILENCE_THRESHOLD;
    int use_stdin = FALSE;
    char *beep = 0;
    char *record = 0;
    
    char dtmf[DTMFLEN];

    dtmf[0] = '\0';

    voice_path_init();

    /* initialize logging */
    strcpy( log_path, voice_log );
    log_level = L_NOISE;

    while ((ch = getopt(argc, argv, "TV:L:Sr:b:c:vx:l:tsm")) != EOF) {
	switch (ch) {
	  case 'T':
	    voice_silence_len=atoi(optarg); /* time in n/10 seconds */
	    break;
	  case 'V':
	    voice_silence_threshold=atoi(optarg); /* 0..31 */
	    break;
	  case 'L':
	    voice_max_len = atoi(optarg);   /* length in seconds */
	    break;
	  case 'S':
	    use_stdin = TRUE;	/* modem connected to stdin */
	    break;
	  case 'r':		/* record voice file */
	    record = optarg;
	    break;
	  case 'b':		/* beep */
	    beep = optarg;
	    break;
	  case 'c':		/* compression mode */
	    compr = atoi( optarg );
	    break;
	  case 'v':		/* switch on verbose mode */
	    verbose = TRUE;
	    break;
	  case 'x':		/* set debug level */
	    log_level = atoi(optarg);
	    break;
	  case 'l':		/* set device(s) to use */
	    voice_devices = optarg;
	    if ( strchr( optarg, '/' ) != NULL )
		{
		    fprintf( stderr, "%s: -l: use device name without path\n",
			    argv[0]);
		    exit(1);
		}
	    break;
	  case 't':		/* i/o: telco line */
	    voc_io=2;
	    break;
	  case 's':		/* output: speaker */
	    voc_io=16;
	    break;
	  case 'm':		/* input: microphone */
	    voc_io=8;
	    break;
	  case '?':		/* unrecognized parameter */
	    exit_usage(argv[0]);
	    break;
	}
    }

    argidx = optind;

    if ( argidx >= argc && !beep && !record ) 
	exit_usage(argv[0]);

    if ( ! use_stdin ) {
	fd = voice_open( voice_devices );

	if ( fd == -1 ) {
	    lprintf( L_WARN, "cannot open voice device(s)" );
	    fprintf( stderr, "%s: cannot access voice device(s) (locked?)\n", argv[0] );
	    exit(2);
	}

	if ( voice_command( "AT", "OK", fd ) == ERROR ||
	    voice_command( "AT&H3 +FCLASS=8", "OK", fd ) == ERROR ) {
	    lprintf( L_ERROR, "cannot initialize faxmodem" );
	    fprintf( stderr, "%s: cannot initialize faxmodem\n", argv[0] );
	    voice_close( fd );
	    exit(3);
	}
	
    } else {
	fd = STDIN;
    }

    while ( argidx < argc ) {
	/* play voice file */
	if ( verbose ) printf( "sending '%s'...\n", argv[ argidx ] );
	if ( voice_send_file( argv[ argidx ], fd , voc_io ) ==
	    ERROR ) break;
	argidx++;
    }

    if ( beep ) {
	voice_beep( fd, voc_io, beep );
    }

    if ( record ) {
	if ( verbose ) printf( "recording '%s'...\n", record );
	voice_record_file( record, fd , voc_io, compr,
			  voice_silence_len,
			  voice_silence_threshold,
			  voice_max_len,
			  dtmf, DTMFLEN );
    }

    if ( ! use_stdin ) {
	voice_command( "AT+VLS=0;+FCLASS=0", "OK", fd ); /* end session */
	voice_close( fd );
    }

    if ( strlen(dtmf) ) printf("%s\n", dtmf);
    return 0;
}
