/* $Header: */
/* conversion to/from ADPCM
 *
 * based on the ZyXEL documentation, I'm not sure if this is
 * entirely correct, the modem sometimes gets out of sync and
 * starts playing white noise.
 */

#include <stdio.h>
#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif
#include "mgetty.h"
#include "pvflib.h"

typedef struct {
        int word;
        int nleft;
} state_t;

static state_t state_init = { 0x0000, 0 };

static int Mx[2][4] = {{ 0x3800, 0x5600, 0, 0 },
                { 0x399a, 0x3a9f, 0x4d14, 0x6607}};

static int bitmask[9] = { 0, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff }; 

static int
get_bits _P3((nbits, s, in), int nbits, state_t *s, FILE *in) {
    while( s->nleft < nbits) {
	int d=getc(in);
	if (d==EOF) return EOF;
	s->word = (s->word<<8) | d;
	s->nleft+=8;
    }
    s->nleft -= nbits;
    return (s->word >> s->nleft) & bitmask[nbits];
}

static void
put_bits _P4((data, nbits, s, out), int data, int nbits, state_t *s, FILE *out) {
    s->word = (s->word<<nbits) | (data & bitmask[nbits]);
    s->nleft += nbits;
    while(s->nleft>=8) {
	int d = (s->word >> (s->nleft-8));
	putc(d&255, out);
	s->nleft-=8;
    }
}

int
pvfadpcm _P2((argc, argv), int argc, char **argv ) {
    FILE *in=stdin, *out=stdout;
    static char buf[16]={'Z','y','X','E','L',2 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 };
    int nbits;
    state_t s;
    int a=0, d=5;
    int r610 = ZYXEL_R610;

    s=state_init;

    if(argc>=2) {
	if(strcmp(argv[1], "-r610")==0) r610 = 1;
	else if(strcmp(argv[1], "-r601")==0) r610 = 0;
	else USAGE("[-r610|-r601]");
    }

    nbits= argv[0][strlen(argv[0])-1] -'0';
    if(nbits<2 || nbits >3) {
	fread(buf, 16, 1, in);
	nbits=buf[10]+1;

	while(1) {
	    int sign;
	    int e=get_bits(nbits, &s, in);
	    if(e==EOF) break;
	    
	    sign = ( e>>(nbits-1) ) ? -1 : 1 ;
	    e = e&bitmask[nbits-1];
	    
	    if(r610) {
		/* modified conversion algorithm for ROM >= 6.10 */
		long t0;

		t0 = a;
		t0 *= 3973;
		t0 += 2048;
		t0 >>= 12;
		a = t0;
	    }

	    a += sign * ((e<<1)+1) * d >>1;
	    if ( (d&1) ) a++;
	    zput(a<<2, out);
	    
	    d = (d*Mx[nbits-2][ e ] + 0x2000) >>14;
	    if ( d < 5 ) d=5;	    
	}
    } else {
	buf[10]=nbits-1;
	fwrite(buf, 16, 1, out);

	while(1) {
	    int e=0;
	    int sign;
	    int delta;
	    int nmax = 1 << (nbits-1);
	    
	    delta = (zget(in) >> 2) - a;
	    if(feof(in))
	       break;
	    
	    if(delta<0) {
		e = nmax;
		delta = -delta;
	    }
	    while( --nmax && delta > d ) {
		delta -= d;
		e++;
	    }

	    if(r610) {
		/* modified conversion algorithm for ROM >= 6.10 */
		long t0;

		t0 = a;
		t0 *= 3973;
		t0 += 2048;
		t0 >>= 12;
		a = t0;
	    }
	    
	    put_bits( e, nbits, &s, out);

	    sign = ( e>>(nbits-1) ) ? -1 : 1 ;
	    e = e&bitmask[nbits-1];
	    
	    a += sign * ((e<<1)+1) * d >>1;
	    if ( (d&1) ) a++;

	    d = (d*Mx[nbits-2][ e ] + 0x2000) >>14;
	    if ( d < 5 ) d=5;
	}
	if(s.nleft) put_bits(0, 8-s.nleft, &s, out);
    }
    return 0;
}
