#include <stdio.h>
#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif
#include "mgetty.h"
#include "pvflib.h"

int
pvftolin _P2((argc, argv), int argc, char **argv ) {
    FILE *in=stdin, *out=stdout;
    int sgned = 0;

    if (argc > 1 && !strcmp(argv[1], "-signed"))
    {
	sgned = 1;
	--argc, argv++;
    }
    
    if( argc>1 ) USAGE("[-signed]");

    if(sgned) {
	while(1) {
	    int d=zget(in);
	    if(feof(in)) break;
	    putc(d>>8, out );
	}
    } else {
	while(1) {
	    int d=zget(in);
	    if(feof(in)) break;
	    putc((d>>8)+0x80, out);
	}
    }
    return 0;
}

int
lintopvf _P2((argc, argv), int argc, char **argv ) {
    FILE *in=stdin, *out=stdout;
    int skip=0, sgned=0;
    int i, d;

    if (argc > 1 && !strcmp(argv[1], "-signed"))
    {
	sgned = 1;
	--argc, argv++;
    }
    
    if( argc>1 && (skip=atoi(argv[1])))
	--argc, argv++;
    
    if( argc>1 ) USAGE("[-signed] [skip]");

    for(i=0; i<skip; i++) getc(in);
    
    if(sgned) {
	while( (d=getc(in))!=EOF ) {
	    d = (d<<8);
	    if (d >= 0x8000)
		d -= 0x10000;
	    zput(d, out );
	}
    } else {
	while( (d=getc(in))!=EOF )
	    zput((d-0x80)<<8, out );
    }
    return 0;
}

