/* $Header: /home/klaus/mgetty/voice/RCS/zplay.c,v 1.16 1994/04/22 21:56:02 klaus Exp $
 *
 * (mostly stolen from Gert Doering's fax routines)
 *
 * Play or record a voice file
 */

#include <stdio.h>
#include <string.h>
#ifndef _NOSTDLIB_H
#include <unistd.h>
#endif
#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif
#include <sys/types.h>
#include <sys/wait.h>

#include "mgetty.h"
#include "voclib.h"
#include "policy.h"

boolean verbose = FALSE;

void exit_usage _P1((program), char * program )
{
    fprintf( stderr,
	    "usage: %s [options] [<files to play >] [-b beep] [-r <output>]\n",
	    program);
    fprintf( stderr,
	    "\t-r s record voice data in <s>\n");
    fprintf( stderr,
	    "\t-c n use compression type <n>, 1:CELP, 2:ADPCM-2, 3:ADPCM-3\n");
    fprintf( stderr,
	    "\t     (recording only, default is %d)\n",
	    VOICE_REC_COMPRESSION);
    fprintf( stderr,
	    "\t-t   use telco line for i/o (default)\n");
    fprintf( stderr,
	    "\t-s   output to internal speaker\n");
    fprintf( stderr,
	    "\t-m   input from external microphone\n");
    fprintf( stderr,
	    "\t-T n set silence time to n/10 seconds\n");
    fprintf( stderr,
	    "\t-V n set silence volume to n, n=0..31\n");
    fprintf( stderr,
	    "\t-L n set maximum recording length to n seconds\n");
    fprintf( stderr,
	    "\t-b s beep (AT+VTS=<s>), i.e. -b '[933,0,12]'\n");
    fprintf( stderr,
	    "\t-v   verbose output\n");
    fprintf( stderr,
	    "\t-x n set debugging level to <n>\n");
    fprintf( stderr,
	    "\t-l s set device string to <s>, i.e. -l ttyS1:ttyS2\n");
    fprintf( stderr,
	    "\t-S   modem is on stdin (for use in shell scripts)\n");
    fprintf( stderr,
	    "\t-C   enable DTMF commands (for shell scripts)\n");
    fprintf( stderr,
	    "\t-D   print DTMF return code on stdout (for shell scripts)\n");
    fprintf( stderr,
	    "\t-X s connect the modem to stdin, call the shell <s>\n");
    exit(1);
}

int main _P2((argc, argv), int argc, char ** argv )
{
    int argidx;
    int fd;
    int ch;

    static char	voice_device_string[] = FAX_MODEM_TTYS;	/* writable! */
    char *	voice_devices = voice_device_string; /* override with "-l" */

    int	voc_io = 2;
    int compr = VOICE_REC_COMPRESSION;
    int voice_max_len = VOICE_MAX_LEN;
    int voice_silence_len = VOICE_SILENCE_LEN;
    int voice_silence_threshold = VOICE_SILENCE_THRESHOLD;
    int use_stdin = FALSE;
    int print_ret = FALSE;
    int use_commands = FALSE;
    char *beep = 0;
    char *record = 0;
    int zreturn = 0;
    char *shell = 0;
    
    char dtmf[DTMFLEN];

    dtmf[0] = '\0';

    voice_path_init();

    /* initialize logging */
    log_init_paths( argv[0], voice_log, NULL );
    log_set_llevel( L_NOISE );

    while ((ch = getopt(argc, argv, "b:c:l:mr:stvx:CDL:STVX:")) != EOF) {
	switch (ch) {
	  case 'T':
	    voice_silence_len=atoi(optarg); /* time in n/10 seconds */
	    break;
	  case 'V':
	    voice_silence_threshold=atoi(optarg); /* 0..31 */
	    break;
	  case 'L':
	    voice_max_len = atoi(optarg);   /* length in seconds */
	    break;
	  case 'S':
	    use_stdin = TRUE;	/* modem connected to stdin */
	    break;
	  case 'r':		/* record voice file */
	    record = optarg;
	    break;
	  case 'b':		/* beep */
	    beep = optarg;
	    break;
	  case 'c':		/* compression mode */
	    compr = atoi( optarg );
	    break;
	  case 'v':		/* switch on verbose mode */
	    verbose = TRUE;
	    break;
	  case 'x':		/* set debug level */
	    log_set_llevel( atoi(optarg) );
	    break;
	  case 'l':		/* set device(s) to use */
	    voice_devices = optarg;
	    if ( strchr( optarg, '/' ) != NULL )
		{
		    fprintf( stderr, "%s: -l: use device name without path\n",
			    argv[0]);
		    exit(1);
		}
	    break;
	  case 't':		/* i/o: telco line */
	    voc_io=2;
	    break;
	  case 's':		/* output: speaker */
	    voc_io=16;
	    break;
	  case 'm':		/* input: microphone */
	    voc_io=8;
	    break;
	  case 'D':		/* print return code */
	    print_ret = TRUE;
	    break;
	  case 'C':		/* enable DTMF commands */
	    use_commands = TRUE;
	    break;
	  case 'X':
	    shell = optarg;
	    break;
	  case '?':		/* unrecognized parameter */
	    exit_usage(argv[0]);
	    break;
	}
    }

    argidx = optind;

    if ( argidx >= argc && !beep && !record ) 
	exit_usage(argv[0]);

    if ( ! use_stdin ) {
	fd = voice_open( voice_devices );

	if ( fd == -1 ) {
	    lprintf( L_WARN, "cannot open voice device(s)" );
	    fprintf( stderr, "%s: cannot access voice device(s) (locked?)\n", argv[0] );
	    exit(1);
	}

	if ( voice_command( "AT", "OK", fd ) == ERROR ||
	    voice_command( "AT+FCLASS=8", "OK", fd ) == ERROR ) {
	    lprintf( L_ERROR, "cannot initialize faxmodem" );
	    fprintf( stderr, "%s: cannot initialize faxmodem\n", argv[0] );
	    voice_close( fd );
	    exit(1);
	}
	
    } else {
	fd = STDIN;
    }

    if (shell) {
	int status;
	
	if (fd > 0) {
	    (void) close(0);
	    if (dup(fd) != 0) {
		lprintf(L_ERROR,"cannot open stdin");
		exit(FAIL);
	    }
	}

	switch(fork()) {
	  case -1:
	    lprintf(L_ERROR, "cannot fork");
	    exit(1);
	    break;
	  case 0:
	    /* child */
	    (void) execl(shell, "sh", argv[argidx], (char *) NULL);
	    lprintf(L_WARN, "cannot execute '%s %s'", shell, argv[argidx]);
	    fprintf(stderr, "cannot execute '%s %s'\n", shell, argv[argidx]);
	    exit(1);
	}
	/* parent */
	wait(&status);
	voice_command( "AT+VLS=0;+FCLASS=0", "OK", fd ); /* end session */
	voice_close( fd );
	exit(0);
    }

    while ( argidx < argc ) {
	/* play voice file */
	int ret;

	if ( verbose ) printf("sending '%s'...\n", argv[ argidx ]);
	ret = voice_send_file(argv[ argidx ], fd , voc_io,
			      ((print_ret || use_commands)
			       ? voice_silence_len : 0),
			      use_commands ? dtmf : (char*)0,
			      DTMFLEN );
	if ( ret==ERROR )
	    fprintf(stderr, "Error sending %s%s\n",
		    argv[argidx],
		    argidx+1<argc ? ", trying to continue" : "");
	if ( print_ret ) printf("%c\n", ret);
	if (ret=='q' || ret=='d' || ret=='s') zreturn = 2;
	argidx++;
    }

    if ( beep ) {
	voice_beep( fd, voc_io, beep );
    }

    if ( record ) {
	int ret;

	if ( verbose ) printf( "recording '%s'...\n", record );
	ret = voice_record_file(record, fd , voc_io, compr,
				voice_silence_len,
				voice_silence_threshold,
				voice_max_len,
				use_commands ? dtmf : (char*)0,
				DTMFLEN );
	if ( print_ret ) printf("%c\n", ret);
	if (ret=='q' || ret=='d' || ret=='s') zreturn = 2;
    }

    if ( ! use_stdin ) {
	voice_command( "AT+VLS=0;+FCLASS=0", "OK", fd ); /* end session */
	voice_close( fd );
    }

    if ( strlen(dtmf) ) printf("%s\n", dtmf);
    return zreturn;
}
